/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.fluid;

import java.util.ArrayList;
import java.util.List;
import mods.eln.fluid.TankData;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.text.StringsKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lmods/eln/fluid/TankData;", "Lmods/eln/misc/INBTTReady;", "tank", "Lnet/minecraftforge/fluids/FluidTank;", "fluidWhitelist", "", "Lnet/minecraftforge/fluids/Fluid;", "fractionalDemandMb", "", "(Lnet/minecraftforge/fluids/FluidTank;Ljava/util/List;D)V", "getFluidWhitelist", "()Ljava/util/List;", "getFractionalDemandMb", "()D", "setFractionalDemandMb", "(D)V", "getTank", "()Lnet/minecraftforge/fluids/FluidTank;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "toString", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nTankData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TankData.kt\nmods/eln/fluid/TankData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1855#2,2:43\n*S KotlinDebug\n*F\n+ 1 TankData.kt\nmods/eln/fluid/TankData\n*L\n18#1:43,2\n*E\n"})
public final class TankData
implements INBTTReady {
    @NotNull
    private final FluidTank tank;
    @NotNull
    private final List<Fluid> fluidWhitelist;
    private double fractionalDemandMb;

    public TankData(@NotNull FluidTank tank, @NotNull List<Fluid> fluidWhitelist, double fractionalDemandMb) {
        Intrinsics.checkNotNullParameter(tank, "tank");
        Intrinsics.checkNotNullParameter(fluidWhitelist, "fluidWhitelist");
        this.tank = tank;
        this.fluidWhitelist = fluidWhitelist;
        this.fractionalDemandMb = fractionalDemandMb;
    }

    public /* synthetic */ TankData(FluidTank fluidTank, List list, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        if ((n & 4) != 0) {
            d = 0.0;
        }
        this(fluidTank, list, d);
    }

    @NotNull
    public final FluidTank getTank() {
        return this.tank;
    }

    @NotNull
    public final List<Fluid> getFluidWhitelist() {
        return this.fluidWhitelist;
    }

    public final double getFractionalDemandMb() {
        return this.fractionalDemandMb;
    }

    public final void setFractionalDemandMb(double d) {
        this.fractionalDemandMb = d;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        List list;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.tank.readFromNBT(nbt.func_74775_l(str + "tank"));
        String string = nbt.func_74779_i(str + "whitelist");
        if (string != null) {
            String[] stringArray = new String[]{"|"};
            list = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
        } else {
            list = null;
        }
        Intrinsics.checkNotNull(list);
        List fluidWhitelistNames = list;
        this.fluidWhitelist.clear();
        Iterable $this$forEach$iv = fluidWhitelistNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                Fluid fluid = FluidRegistry.getFluid((String)it);
                Intrinsics.checkNotNullExpressionValue(fluid, "getFluid(it)");
                this.fluidWhitelist.add(fluid);
            }
            catch (Exception e) {
                Utils.println("Error, could not find fluid " + it);
            }
        }
        this.fractionalDemandMb = nbt.func_74769_h(str + "demandMb");
        this.tank.setCapacity(nbt.func_74762_e(str + "capacity"));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        NBTTagCompound tag = new NBTTagCompound();
        this.tank.writeToNBT(tag);
        nbt.func_74782_a(str + "tank", (NBTBase)tag);
        nbt.func_74778_a(str + "whitelist", CollectionsKt.joinToString$default(this.fluidWhitelist, "|", null, null, 0, null, writeToNBT.1.INSTANCE, 30, null));
        nbt.func_74780_a(str + "demandMb", this.fractionalDemandMb);
        nbt.func_74768_a(str + "capacity", this.tank.getCapacity());
    }

    @NotNull
    public String toString() {
        return "TankData(" + this.tank.getFluidAmount() + '/' + this.tank.getCapacity() + "mB of " + this.tank.getFluid() + ", whitelist: " + this.fluidWhitelist + ", " + this.fractionalDemandMb + "mB spare";
    }

    @NotNull
    public final FluidTank component1() {
        return this.tank;
    }

    @NotNull
    public final List<Fluid> component2() {
        return this.fluidWhitelist;
    }

    public final double component3() {
        return this.fractionalDemandMb;
    }

    @NotNull
    public final TankData copy(@NotNull FluidTank tank, @NotNull List<Fluid> fluidWhitelist, double fractionalDemandMb) {
        Intrinsics.checkNotNullParameter(tank, "tank");
        Intrinsics.checkNotNullParameter(fluidWhitelist, "fluidWhitelist");
        return new TankData(tank, fluidWhitelist, fractionalDemandMb);
    }

    public static /* synthetic */ TankData copy$default(TankData tankData, FluidTank fluidTank, List list, double d, int n, Object object) {
        if ((n & 1) != 0) {
            fluidTank = tankData.tank;
        }
        if ((n & 2) != 0) {
            list = tankData.fluidWhitelist;
        }
        if ((n & 4) != 0) {
            d = tankData.fractionalDemandMb;
        }
        return tankData.copy(fluidTank, list, d);
    }

    public int hashCode() {
        int result = this.tank.hashCode();
        result = result * 31 + ((Object)this.fluidWhitelist).hashCode();
        result = result * 31 + Double.hashCode(this.fractionalDemandMb);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TankData)) {
            return false;
        }
        TankData tankData = (TankData)other;
        if (!Intrinsics.areEqual(this.tank, tankData.tank)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fluidWhitelist, tankData.fluidWhitelist)) {
            return false;
        }
        return Double.compare(this.fractionalDemandMb, tankData.fractionalDemandMb) == 0;
    }
}

