/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.generic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import mods.eln.Eln;
import mods.eln.generic.GenericItemBlockUsingDamage;
import mods.eln.misc.RealisticEnum;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class GenericItemBlockUsingDamageDescriptor {
    String iconName;
    IIcon iconIndex;
    public String name;
    public static String INVALID_NAME = "$NO_DESCRIPTOR";
    public static HashMap<String, GenericItemBlockUsingDamageDescriptor> byName = new HashMap();
    public Item parentItem;
    public int parentItemDamage;

    public static GenericItemBlockUsingDamageDescriptor getByName(String name) {
        return byName.get(name);
    }

    public GenericItemBlockUsingDamageDescriptor(String name) {
        this(name, name);
    }

    public GenericItemBlockUsingDamageDescriptor(String name, String iconName) {
        this.setDefaultIcon(iconName);
        this.name = name;
        byName.put(name, this);
    }

    public void setDefaultIcon(String name) {
        String iconName = name.replaceAll(" ", "").toLowerCase();
        this.iconName = Eln.noSymbols && this.getClass().getClassLoader().getResource("assets/eln/textures/blocks/" + iconName + "-ni.png") != null ? iconName + "-ni" : iconName;
    }

    public NBTTagCompound getDefaultNBT() {
        return null;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean par4) {
    }

    public RealisticEnum addRealismContext(List<String> list) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateIcons(IIconRegister iconRegister) {
        this.iconIndex = iconRegister.func_94245_a("eln:" + this.iconName);
    }

    public IIcon getIcon() {
        return this.iconIndex;
    }

    public String getName(ItemStack stack) {
        return this.name;
    }

    public void setParent(Item item, int damage) {
        this.parentItem = item;
        this.parentItemDamage = damage;
    }

    public ItemStack newItemStack(int size) {
        return new ItemStack(this.parentItem, size, this.parentItemDamage);
    }

    public ItemStack newItemStack() {
        return new ItemStack(this.parentItem, 1, this.parentItemDamage);
    }

    public boolean checkSameItemStack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == this.parentItem && stack.func_77960_j() == this.parentItemDamage;
    }

    public static GenericItemBlockUsingDamageDescriptor getDescriptor(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof GenericItemBlockUsingDamage)) {
            return null;
        }
        GenericItemBlockUsingDamage genItem = (GenericItemBlockUsingDamage)item;
        return genItem.getDescriptor(stack);
    }

    public static GenericItemBlockUsingDamageDescriptor getDescriptor(ItemStack stack, Class extendClass) {
        GenericItemBlockUsingDamageDescriptor desc = GenericItemBlockUsingDamageDescriptor.getDescriptor(stack);
        if (desc == null) {
            return null;
        }
        if (!extendClass.isAssignableFrom(desc.getClass())) {
            return null;
        }
        return desc;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player) {
        return false;
    }
}

