/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.ghost;

import java.util.ArrayList;
import java.util.Iterator;
import mods.eln.Eln;
import mods.eln.ghost.GhostBlock;
import mods.eln.ghost.GhostGroupElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.block.Block;
import net.minecraft.world.World;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ6\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\"\u001a\u00020\rJ\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u001dJ\u0010\u0010%\u001a\u00020\u00002\b\u0010&\u001a\u0004\u0018\u00010'J\u001a\u0010%\u001a\u00020\u00002\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)J\u001e\u0010*\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\rJ\u001e\u0010,\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ6\u0010-\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rJ\u0006\u0010.\u001a\u00020\rR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006/"}, d2={"Lmods/eln/ghost/GhostGroup;", "", "()V", "elementList", "Ljava/util/ArrayList;", "Lmods/eln/ghost/GhostGroupElement;", "getElementList", "()Ljava/util/ArrayList;", "setElementList", "(Ljava/util/ArrayList;)V", "addElement", "", "x", "", "y", "z", "block", "Lnet/minecraft/block/Block;", "meta", "addRectangle", "x1", "x2", "y1", "y2", "z1", "z2", "canBePloted", "", "c", "Lmods/eln/misc/Coordinate;", "world", "Lnet/minecraft/world/World;", "erase", "observerCoordinate", "uuid", "eraseGeo", "coordinate", "newRotate", "dir", "Lmods/eln/misc/Direction;", "front", "Lmods/eln/misc/LRDU;", "plot", "UUID", "removeElement", "removeRectangle", "size", "Eln"})
public final class GhostGroup {
    @NotNull
    private ArrayList<GhostGroupElement> elementList = new ArrayList();

    @NotNull
    public final ArrayList<GhostGroupElement> getElementList() {
        return this.elementList;
    }

    public final void setElementList(@NotNull ArrayList<GhostGroupElement> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.elementList = arrayList;
    }

    public final void addElement(int x, int y, int z) {
        GhostBlock ghostBlock = Eln.ghostBlock;
        Intrinsics.checkNotNullExpressionValue((Object)ghostBlock, "ghostBlock");
        this.elementList.add(new GhostGroupElement(x, y, z, ghostBlock, 0));
    }

    public final void addElement(int x, int y, int z, @NotNull Block block, int meta) {
        Intrinsics.checkNotNullParameter(block, "block");
        this.elementList.add(new GhostGroupElement(x, y, z, block, meta));
    }

    public final void removeElement(int x, int y, int z) {
        Iterator<GhostGroupElement> iterator2 = this.elementList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "elementList.iterator()");
        Iterator<GhostGroupElement> i = iterator2;
        GhostGroupElement g = null;
        while (i.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(i.next(), "i.next()");
            if (g.getX() != x || g.getY() != y || g.getZ() != z) continue;
            i.remove();
        }
    }

    public final void addRectangle(int x1, int x2, int y1, int y2, int z1, int z2) {
        int x = x1;
        if (x <= x2) {
            while (true) {
                int y;
                if ((y = y1) <= y2) {
                    while (true) {
                        int z;
                        if ((z = z1) <= z2) {
                            while (true) {
                                this.addElement(x, y, z);
                                if (z == z2) break;
                                ++z;
                            }
                        }
                        if (y == y2) break;
                        ++y;
                    }
                }
                if (x == x2) break;
                ++x;
            }
        }
    }

    public final void removeRectangle(int x1, int x2, int y1, int y2, int z1, int z2) {
        int x = x1;
        if (x <= x2) {
            while (true) {
                int y;
                if ((y = y1) <= y2) {
                    while (true) {
                        int z;
                        if ((z = z1) <= z2) {
                            while (true) {
                                this.removeElement(x, y, z);
                                if (z == z2) break;
                                ++z;
                            }
                        }
                        if (y == y2) break;
                        ++y;
                    }
                }
                if (x == x2) break;
                ++x;
            }
        }
    }

    public final boolean canBePloted(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter(c, "c");
        return this.canBePloted(c.world(), c.x, c.y, c.z);
    }

    public final boolean canBePloted(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter(world, "world");
        for (GhostGroupElement element : this.elementList) {
            if (Eln.ghostManager.canCreateGhostAt(world, x + element.getX(), y + element.getY(), z + element.getZ())) continue;
            return false;
        }
        return true;
    }

    public final boolean plot(@NotNull Coordinate coordinate, @NotNull Coordinate observerCoordinate, int UUID2) {
        Intrinsics.checkNotNullParameter(coordinate, "coordinate");
        Intrinsics.checkNotNullParameter(observerCoordinate, "observerCoordinate");
        if (!this.canBePloted(coordinate.world(), coordinate.x, coordinate.y, coordinate.z)) {
            return false;
        }
        for (GhostGroupElement element : this.elementList) {
            Coordinate offsetCoordinate = coordinate.newWithOffset(element.getX(), element.getY(), element.getZ());
            Eln.ghostManager.createGhost(offsetCoordinate, observerCoordinate, UUID2, element.getBlock(), element.getMeta());
        }
        return true;
    }

    public final void erase(@Nullable Coordinate observerCoordinate) {
        Eln.ghostManager.removeGhostAndBlockWithObserver(observerCoordinate);
    }

    public final void erase(@Nullable Coordinate observerCoordinate, int uuid) {
        Eln.ghostManager.removeGhostAndBlockWithObserver(observerCoordinate, uuid);
    }

    public final void eraseGeo(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter(coordinate, "coordinate");
        for (GhostGroupElement element : this.elementList) {
            Eln.ghostManager.removeGhostAndBlock(coordinate.newWithOffset(element.getX(), element.getY(), element.getZ()));
        }
    }

    @NotNull
    public final GhostGroup newRotate(@Nullable Direction dir) {
        GhostGroup other = new GhostGroup();
        for (GhostGroupElement element : this.elementList) {
            int x = 0;
            int y = 0;
            int z = 0;
            Direction direction = dir;
            switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    x = element.getX();
                    y = element.getY();
                    z = element.getZ();
                    break;
                }
                case 2: {
                    x = -element.getX();
                    y = element.getY();
                    z = -element.getZ();
                    break;
                }
                case 3: {
                    x = -element.getZ();
                    y = element.getY();
                    z = element.getX();
                    break;
                }
                case 4: {
                    x = element.getZ();
                    y = element.getY();
                    z = -element.getX();
                    break;
                }
                case 5: {
                    x = -element.getY();
                    y = element.getX();
                    z = element.getZ();
                    break;
                }
                case 6: {
                    x = element.getY();
                    y = -element.getX();
                    z = element.getZ();
                    break;
                }
                default: {
                    x = -element.getY();
                    y = element.getX();
                    z = element.getZ();
                }
            }
            other.addElement(x, y, z, element.getBlock(), element.getMeta());
        }
        return other;
    }

    @NotNull
    public final GhostGroup newRotate(@Nullable Direction dir, @Nullable LRDU front) {
        return this.newRotate(dir);
    }

    public final int size() {
        return this.elementList.size();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.XN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.XP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ZN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ZP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.YN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.YP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

