/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.ghost;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.ghost.GhostElement;
import mods.eln.ghost.GhostObserver;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmOverloads;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u0012J6\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00192\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\b\b\u0002\u0010#\u001a\u00020\u0019H\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007J\u0006\u0010&\u001a\u00020\u0012J\b\u0010'\u001a\u00020\u0015H\u0016J\u0010\u0010(\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010,\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007J\u000e\u0010-\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0007J\u0010\u0010.\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0007J\u0018\u0010.\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010/\u001a\u00020\u0019J\u0018\u00100\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010/\u001a\u00020\u0019J\u0010\u00101\u001a\u00020\u00122\b\u00102\u001a\u0004\u0018\u00010\u0007J\u0010\u00103\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007J\u0016\u00104\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\u0006\u00105\u001a\u00020\u0019J\u000e\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u0019J\u0010\u00108\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0016R(\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u000e0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\f\u00a8\u00069"}, d2={"Lmods/eln/ghost/GhostManager;", "Lnet/minecraft/world/WorldSavedData;", "par1Str", "", "(Ljava/lang/String;)V", "ghostTable", "", "Lmods/eln/misc/Coordinate;", "Lmods/eln/ghost/GhostElement;", "getGhostTable", "()Ljava/util/Map;", "setGhostTable", "(Ljava/util/Map;)V", "observerTable", "Lmods/eln/ghost/GhostObserver;", "getObserverTable", "setObserverTable", "addObserver", "", "observer", "canCreateGhostAt", "", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "clear", "createGhost", "coordinate", "observerCoordinate", "UUID", "block", "Lnet/minecraft/block/Block;", "meta", "getGhost", "getObserver", "init", "isDirty", "loadFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromNBT", "removeGhost", "removeGhostAndBlock", "removeGhostAndBlockWithObserver", "uuid", "removeGhostAndBlockWithObserverAndNotUuid", "removeGhostNode", "c", "removeObserver", "saveToNBT", "dim", "unload", "dimensionId", "writeToNBT", "Eln"})
public final class GhostManager
extends WorldSavedData {
    @NotNull
    private Map<Coordinate, GhostElement> ghostTable = new Hashtable();
    @NotNull
    private Map<Coordinate, GhostObserver> observerTable = new Hashtable();

    public GhostManager(@Nullable String par1Str) {
        super(par1Str);
    }

    @NotNull
    public final Map<Coordinate, GhostElement> getGhostTable() {
        return this.ghostTable;
    }

    public final void setGhostTable(@NotNull Map<Coordinate, GhostElement> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.ghostTable = map;
    }

    @NotNull
    public final Map<Coordinate, GhostObserver> getObserverTable() {
        return this.observerTable;
    }

    public final void setObserverTable(@NotNull Map<Coordinate, GhostObserver> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.observerTable = map;
    }

    public final void clear() {
        this.ghostTable.clear();
        this.observerTable.clear();
    }

    public final void init() {
    }

    public boolean func_76188_b() {
        return true;
    }

    @Nullable
    public final GhostElement getGhost(@Nullable Coordinate coordinate) {
        return this.ghostTable.get(coordinate);
    }

    public final void removeGhost(@Nullable Coordinate coordinate) {
        this.removeGhostNode(coordinate);
        this.ghostTable.remove(coordinate);
    }

    public final void addObserver(@NotNull GhostObserver observer) {
        Intrinsics.checkNotNullParameter(observer, "observer");
        this.observerTable.put(observer.getGhostObserverCoordonate(), observer);
    }

    @Nullable
    public final GhostObserver getObserver(@Nullable Coordinate coordinate) {
        return this.observerTable.get(coordinate);
    }

    public final void removeObserver(@Nullable Coordinate coordinate) {
        this.observerTable.remove(coordinate);
    }

    public final void removeGhostAndBlockWithObserver(@Nullable Coordinate observerCoordinate) {
        Iterator<Map.Entry<Coordinate, GhostElement>> iterator2 = this.ghostTable.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Coordinate, GhostElement> entry = iterator2.next();
            GhostElement element = entry.getValue();
            Coordinate coordinate = element.getObservatorCoordonate();
            Intrinsics.checkNotNull(coordinate);
            if (!coordinate.equals(observerCoordinate)) continue;
            iterator2.remove();
            this.removeGhostNode(element.elementCoordinate);
            Coordinate coordinate2 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate2);
            World world = coordinate2.world();
            Coordinate coordinate3 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate3);
            int n = coordinate3.x;
            Coordinate coordinate4 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate4);
            int n2 = coordinate4.y;
            Coordinate coordinate5 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate5);
            world.func_147468_f(n, n2, coordinate5.z);
        }
    }

    public final void removeGhostAndBlockWithObserver(@Nullable Coordinate observerCoordinate, int uuid) {
        Iterator<Map.Entry<Coordinate, GhostElement>> iterator2 = this.ghostTable.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Coordinate, GhostElement> entry = iterator2.next();
            GhostElement element = entry.getValue();
            Coordinate coordinate = element.getObservatorCoordonate();
            Intrinsics.checkNotNull(coordinate);
            if (!coordinate.equals(observerCoordinate) || element.getUUID() != uuid) continue;
            iterator2.remove();
            this.removeGhostNode(element.elementCoordinate);
            Coordinate coordinate2 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate2);
            World world = coordinate2.world();
            Coordinate coordinate3 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate3);
            int n = coordinate3.x;
            Coordinate coordinate4 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate4);
            int n2 = coordinate4.y;
            Coordinate coordinate5 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate5);
            world.func_147468_f(n, n2, coordinate5.z);
        }
    }

    public final void removeGhostAndBlockWithObserverAndNotUuid(@Nullable Coordinate observerCoordinate, int uuid) {
        Iterator<Map.Entry<Coordinate, GhostElement>> iterator2 = this.ghostTable.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Coordinate, GhostElement> entry = iterator2.next();
            GhostElement element = entry.getValue();
            Coordinate coordinate = element.getObservatorCoordonate();
            Intrinsics.checkNotNull(coordinate);
            if (!coordinate.equals(observerCoordinate) || element.getUUID() == uuid) continue;
            iterator2.remove();
            this.removeGhostNode(element.elementCoordinate);
            Coordinate coordinate2 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate2);
            World world = coordinate2.world();
            Coordinate coordinate3 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate3);
            int n = coordinate3.x;
            Coordinate coordinate4 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate4);
            int n2 = coordinate4.y;
            Coordinate coordinate5 = element.elementCoordinate;
            Intrinsics.checkNotNull(coordinate5);
            world.func_147468_f(n, n2, coordinate5.z);
        }
    }

    public final void removeGhostNode(@Nullable Coordinate c) {
        NodeManager nodeManager = NodeManager.instance;
        Intrinsics.checkNotNull((Object)nodeManager);
        NodeBase nodeBase = nodeManager.getNodeFromCoordonate(c);
        if (nodeBase == null) {
            return;
        }
        NodeBase node = nodeBase;
        node.onBreakBlock();
    }

    public final void removeGhostAndBlock(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter(coordinate, "coordinate");
        this.removeGhost(coordinate);
        coordinate.world().func_147468_f(coordinate.x, coordinate.y, coordinate.z);
    }

    public void func_76184_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
    }

    public void func_76187_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
    }

    public final void loadFromNBT(@Nullable NBTTagCompound nbt) {
        NBTTagCompound nBTTagCompound = nbt;
        Intrinsics.checkNotNull(nBTTagCompound);
        for (NBTTagCompound o : Utils.getTags(nBTTagCompound)) {
            GhostElement ghost = new GhostElement();
            ghost.readFromNBT(o, "");
            this.ghostTable.put(ghost.elementCoordinate, ghost);
        }
    }

    public final void saveToNBT(@NotNull NBTTagCompound nbt, int dim) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        int nodeCounter = 0;
        for (GhostElement ghost : this.ghostTable.values()) {
            if (dim != Integer.MIN_VALUE) {
                Coordinate coordinate = ghost.elementCoordinate;
                Intrinsics.checkNotNull(coordinate);
                if (coordinate.dimension != dim) continue;
            }
            NBTTagCompound nbtGhost = new NBTTagCompound();
            ghost.writeToNBT(nbtGhost, "");
            nbt.func_74782_a("" + 'n' + nodeCounter++, (NBTBase)nbtGhost);
        }
    }

    public final void unload(int dimensionId) {
        Iterator<GhostElement> i = this.ghostTable.values().iterator();
        while (i.hasNext()) {
            GhostElement n = i.next();
            Coordinate coordinate = n.elementCoordinate;
            Intrinsics.checkNotNull(coordinate);
            if (coordinate.dimension != dimensionId) continue;
            i.remove();
        }
    }

    public final boolean canCreateGhostAt(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter(world, "world");
        return !world.func_72863_F().func_73149_a(x >> 4, z >> 4) ? false : world.func_147439_a(x, y, z) == Blocks.field_150350_a || world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    @JvmOverloads
    public final void createGhost(@NotNull Coordinate coordinate, @NotNull Coordinate observerCoordinate, int UUID2, @Nullable Block block, int meta) {
        Intrinsics.checkNotNullParameter(coordinate, "coordinate");
        Intrinsics.checkNotNullParameter(observerCoordinate, "observerCoordinate");
        Coordinate coordinate2 = coordinate;
        coordinate2.world().func_147468_f(coordinate2.x, coordinate2.y, coordinate2.z);
        if (coordinate2.world().func_147465_d(coordinate2.x, coordinate2.y, coordinate2.z, block, meta, 3)) {
            coordinate2 = new Coordinate(coordinate2);
            GhostElement element = new GhostElement(coordinate2, observerCoordinate, UUID2);
            this.ghostTable.put(element.elementCoordinate, element);
        }
    }

    public static /* synthetic */ void createGhost$default(GhostManager ghostManager, Coordinate coordinate, Coordinate coordinate2, int n, Block block, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            block = Eln.ghostBlock;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        ghostManager.createGhost(coordinate, coordinate2, n, block, n2);
    }

    @JvmOverloads
    public final void createGhost(@NotNull Coordinate coordinate, @NotNull Coordinate observerCoordinate, int UUID2, @Nullable Block block) {
        Intrinsics.checkNotNullParameter(coordinate, "coordinate");
        Intrinsics.checkNotNullParameter(observerCoordinate, "observerCoordinate");
        GhostManager.createGhost$default(this, coordinate, observerCoordinate, UUID2, block, 0, 16, null);
    }

    @JvmOverloads
    public final void createGhost(@NotNull Coordinate coordinate, @NotNull Coordinate observerCoordinate, int UUID2) {
        Intrinsics.checkNotNullParameter(coordinate, "coordinate");
        Intrinsics.checkNotNullParameter(observerCoordinate, "observerCoordinate");
        GhostManager.createGhost$default(this, coordinate, observerCoordinate, UUID2, null, 0, 24, null);
    }
}

