/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.gridnode.GridDescriptor;
import mods.eln.gridnode.GridLink;
import mods.eln.misc.BoundingBox;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.PlayerKt;
import mods.eln.misc.UserError;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin._Assertions;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import org.apache.commons.lang3.tuple.Pair;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 F2\u00020\u0001:\u0001FB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000H\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0014J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010#\u001a\u00020$H&J\u0018\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0014J\b\u0010)\u001a\u00020\u001fH\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0016J0\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020$2\u0006\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u001aH\u0016J\b\u00105\u001a\u00020\u001fH\u0016J(\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u0002012\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010<\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\u001fH\u0016J\u0010\u0010@\u001a\u00020+2\u0006\u0010#\u001a\u00020$H\u0016J\u0006\u0010A\u001a\u00020\u001fJ\u0010\u0010B\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000H\u0002J\u0010\u0010C\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010D\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.2\u0006\u0010E\u001a\u00020\"H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lmods/eln/gridnode/GridElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "transparentNode", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "connectRange", "", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;I)V", "getConnectRange$Eln", "()I", "setConnectRange$Eln", "(I)V", "desc", "Lmods/eln/gridnode/GridDescriptor;", "gridLinkList", "Ljava/util/HashSet;", "Lmods/eln/gridnode/GridLink;", "getGridLinkList", "()Ljava/util/HashSet;", "setGridLinkList", "(Ljava/util/HashSet;)V", "gridLinksBooting", "getGridLinksBooting", "setGridLinksBooting", "idealRenderingAngle", "", "canConnect", "", "other", "connectJob", "", "disconnectJob", "getCablePoint", "Lnet/minecraft/util/Vec3;", "side", "Lmods/eln/misc/Direction;", "i", "getGridElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getRenderCablePoint", "initialize", "multiMeterString", "", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "vy", "vz", "onBreakElement", "onTryGridConnect", "entityPlayer", "stack", "Lnet/minecraft/item/ItemStack;", "cable", "Lmods/eln/sixnode/electricalcable/ElectricalCableDescriptor;", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "selfDestroy", "thermoMeterString", "updateIdealRenderAngle", "validLOS", "writeToNBT", "writeVec", "sp", "Companion", "Eln"})
@SourceDebugExtension(value={"SMAP\nGridElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridElement.kt\nmods/eln/gridnode/GridElement\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n11395#2:290\n11730#2,3:291\n1#3:294\n766#4:295\n857#4,2:296\n*S KotlinDebug\n*F\n+ 1 GridElement.kt\nmods/eln/gridnode/GridElement\n*L\n205#1:290\n205#1:291,3\n223#1:295\n223#1:296,2\n*E\n"})
public abstract class GridElement
extends TransparentNodeElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int connectRange;
    @NotNull
    private HashSet<GridLink> gridLinkList;
    @NotNull
    private HashSet<GridLink> gridLinksBooting;
    @NotNull
    private final GridDescriptor desc;
    private float idealRenderingAngle;
    @NotNull
    private static final HashMap<UUID, Pair<Coordinate, Direction>> pending = new HashMap();

    public GridElement(@NotNull TransparentNode transparentNode, @NotNull TransparentNodeDescriptor descriptor, int connectRange) {
        Intrinsics.checkNotNullParameter(transparentNode, "transparentNode");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(transparentNode, descriptor);
        this.connectRange = connectRange;
        this.gridLinkList = new HashSet();
        this.gridLinksBooting = new HashSet();
        this.desc = (GridDescriptor)descriptor;
    }

    public final int getConnectRange$Eln() {
        return this.connectRange;
    }

    public final void setConnectRange$Eln(int n) {
        this.connectRange = n;
    }

    @NotNull
    public final HashSet<GridLink> getGridLinkList() {
        return this.gridLinkList;
    }

    public final void setGridLinkList(@NotNull HashSet<GridLink> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.gridLinkList = hashSet;
    }

    @NotNull
    public final HashSet<GridLink> getGridLinksBooting() {
        return this.gridLinksBooting;
    }

    public final void setGridLinksBooting(@NotNull HashSet<GridLink> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.gridLinksBooting = hashSet;
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        ItemStack stack = player.func_71045_bC();
        GenericItemBlockUsingDamageDescriptor itemDesc = GenericItemBlockUsingDamageDescriptor.getDescriptor(stack);
        if (itemDesc instanceof ElectricalCableDescriptor) {
            Intrinsics.checkNotNullExpressionValue(stack, "stack");
            return this.onTryGridConnect(player, stack, (ElectricalCableDescriptor)itemDesc, side);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean onTryGridConnect(EntityPlayer entityPlayer, ItemStack stack, ElectricalCableDescriptor cable, Direction side) {
        block14: {
            block13: {
                uuid = entityPlayer.getPersistentID();
                p = GridElement.pending.get(uuid);
                other = null;
                if (p != null) {
                    other = GridLink.Companion.getElementFromCoordinate((Coordinate)p.getLeft());
                }
                if (!Intrinsics.areEqual(cable, this.desc.getCableDescriptor())) {
                    Utils.addChatMessage(entityPlayer, "Wrong cable, you need " + this.desc.getCableDescriptor().name);
                    return true;
                }
                if (Intrinsics.areEqual(other, this)) {
                    Utils.addChatMessage(entityPlayer, "Cancelled connection");
                    GridElement.pending.remove(uuid);
                    return true;
                }
                if (other != null) break block13;
                Utils.addChatMessage(entityPlayer, "Setting starting point");
                GridElement.pending.put(uuid, (Pair<Coordinate, Direction>)Pair.of((Object)this.coordinate(), (Object)side));
                break block14;
            }
            distance = other.coordinate().trueDistanceTo(this.coordinate());
            cableLength = (int)Math.ceil(distance);
            range = Math.min(this.connectRange, other.connectRange);
            stackSize = PlayerKt.totalItemsCarried(entityPlayer, stack);
            if (!((double)stackSize < distance)) ** GOTO lbl-1000
            Intrinsics.checkNotNull(entityPlayer, "null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            if (!Utils.isCreative((EntityPlayerMP)entityPlayer)) {
                Utils.addChatMessage(entityPlayer, "You need " + cableLength + " units of cable");
            } else if (distance > (double)range) {
                Utils.addChatMessage(entityPlayer, "Cannot connect, range " + Math.ceil(distance) + " and limit " + range + " blocks");
            } else if (!this.canConnect(other)) {
                Utils.addChatMessage(entityPlayer, "Cannot connect these two objects");
            } else if (!this.validLOS(other)) {
                Utils.addChatMessage(entityPlayer, "Cannot connect, no line of sight");
            } else {
                try {
                    v0 = p;
                    Intrinsics.checkNotNull(v0);
                    v1 = v0.getRight();
                    Intrinsics.checkNotNullExpressionValue(v1, "p!!.right");
                    GridLink.Companion.addLink(this, other, side, (Direction)v1, cable, cableLength);
                    Utils.addChatMessage(entityPlayer, "Added connection");
                    PlayerKt.removeMultipleItems(entityPlayer, stack, cableLength);
                }
                catch (UserError e) {
                    Utils.addChatMessage(entityPlayer, e.getMessage());
                }
            }
            GridElement.pending.remove(uuid);
        }
        return true;
    }

    @Override
    public void initialize() {
        this.connect();
        for (GridLink link : this.gridLinksBooting) {
            link.connect();
        }
        this.gridLinksBooting.clear();
        this.updateIdealRenderAngle();
    }

    @Override
    public void connectJob() {
        super.connectJob();
        for (GridLink link : this.gridLinkList) {
            link.connect();
        }
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        for (GridLink link : this.gridLinkList) {
            link.disconnect();
        }
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
        HashSet copy = new HashSet(this.gridLinkList);
        for (GridLink link : copy) {
            TransparentNode transparentNode = this.node;
            if (transparentNode == null) continue;
            transparentNode.dropItem(link.onBreakElement());
        }
    }

    @Override
    public void selfDestroy() {
        super.selfDestroy();
        HashSet copy = new HashSet(this.gridLinkList);
        for (GridLink link : copy) {
            link.selfDestroy();
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        NBTTagCompound gridLinks = Utils.newNbtTagCompund(nbt, "gridLinks");
        Iterator<GridLink> iterator2 = this.gridLinkList.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            GridLink link = iterator2.next();
            link.writeToNBT(Utils.newNbtTagCompund(gridLinks, String.valueOf(i)), "");
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        NBTTagCompound linkTag;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        boolean bl = this.gridLinkList.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        NBTTagCompound gridLinks = nbt.func_74775_l("gridLinks");
        int i = 0;
        while (!(linkTag = gridLinks.func_74775_l(String.valueOf(i))).func_82582_d()) {
            Intrinsics.checkNotNullExpressionValue(linkTag, "linkTag");
            this.gridLinksBooting.add(new GridLink(linkTag, ""));
            int n = i;
            i = n + 1;
        }
    }

    @Nullable
    public abstract ElectricalLoad getGridElectricalLoad(@NotNull Direction var1);

    private final boolean validLOS(GridElement other) {
        return true;
    }

    protected final boolean canConnect(@NotNull GridElement other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateIdealRenderAngle() {
        if (this.desc.rotationIsFixed()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.front.ordinal()]) {
                case 1: {
                    this.idealRenderingAngle = 0.0f;
                    break;
                }
                case 2: {
                    this.idealRenderingAngle = 180.0f;
                    break;
                }
                case 3: {
                    this.idealRenderingAngle = 90.0f;
                    break;
                }
                case 4: {
                    this.idealRenderingAngle = 90.0f;
                    break;
                }
                case 5: {
                    this.idealRenderingAngle = 270.0f;
                    break;
                }
                case 6: {
                    this.idealRenderingAngle = 90.0f;
                }
            }
        } else if (this.gridLinkList.size() == 0) {
            this.idealRenderingAngle = 0.0f;
        } else {
            double[] angles = new double[this.gridLinkList.size()];
            int i = 0;
            for (GridLink link : this.gridLinkList) {
                Coordinate vec = link.getA$Eln().subtract(link.getB$Eln());
                if (vec.z < 0) {
                    vec = vec.negate();
                }
                double h = Math.sqrt(vec.x * vec.x + vec.z * vec.z);
                angles[i++] = Math.acos((double)vec.x / h);
            }
            double optAngle = 0.0;
            double optErr = Double.POSITIVE_INFINITY;
            for (i = 0; i < 128; ++i) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                double angle = Math.PI * (double)i / 128.0;
                Object object = angles;
                boolean $i$f$map = false;
                void var13_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var20_23 = item$iv$iv = $this$mapTo$iv$iv[j];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Math.abs(Math.sin(angle - it)));
                }
                object = (List)destination$iv$iv;
                double d = 0.0;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object t = iterator2.next();
                    double d2 = ((Number)t).doubleValue();
                    double d3 = d;
                    boolean bl = false;
                    void var25_27 = it * it * it;
                    d = d3 + var25_27;
                }
                double error = d;
                if (!(error < optErr)) continue;
                optAngle = angle;
                optErr = error;
            }
            this.idealRenderingAngle = (float)Math.toDegrees(-optAngle);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            void $this$filterTo$iv$iv;
            stream.writeFloat(this.idealRenderingAngle);
            Iterable $this$filter$iv = this.gridLinkList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GridLink it = (GridLink)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getA$Eln(), this.coordinate())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List ourLinks = (List)destination$iv$iv;
            stream.writeInt(ourLinks.size());
            for (GridLink link : ourLinks) {
                GridElement target = link.getOtherElement(this);
                Direction ourSide = link.getSide(this);
                Direction theirSide = link.getSide(target);
                Coordinate offset = link.getB$Eln().subtract(link.getA$Eln());
                for (int i = 0; i < 2; ++i) {
                    Vec3 start = this.getRenderCablePoint(ourSide, i);
                    start.func_72442_b((float)Math.toRadians(this.idealRenderingAngle));
                    Vec3 end = target.getRenderCablePoint(theirSide, i);
                    end.func_72442_b((float)Math.toRadians(target.idealRenderingAngle));
                    Vec3 vec3 = end.func_72441_c((double)offset.x, (double)offset.y, (double)offset.z);
                    Intrinsics.checkNotNullExpressionValue(vec3, "end.addVector(offset.x.t\u2026e(), offset.z.toDouble())");
                    end = vec3;
                    this.writeVec(stream, start);
                    this.writeVec(stream, end);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    protected Vec3 getCablePoint(@NotNull Direction side, int i) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (i >= 2) {
            throw new AssertionError((Object)"Invalid cable point index");
        }
        Obj3D.Obj3DPart obj3DPart = (i == 0 ? this.desc.getPlus() : this.desc.getGnd()).get(0);
        Intrinsics.checkNotNullExpressionValue(obj3DPart, "(if (i == 0) desc.plus else desc.gnd)[0]");
        Obj3D.Obj3DPart part = obj3DPart;
        BoundingBox bb = part.boundingBox();
        return bb.centre();
    }

    @NotNull
    protected Vec3 getRenderCablePoint(@NotNull Direction side, int i) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Vec3 vec3 = this.getCablePoint(side, i).func_72441_c(this.desc.getRenderOffset().field_72450_a, this.desc.getRenderOffset().field_72448_b, this.desc.getRenderOffset().field_72449_c);
        Intrinsics.checkNotNullExpressionValue(vec3, "getCablePoint(side, i).a\u2026erOffset.zCoord\n        )");
        return vec3;
    }

    private final void writeVec(DataOutputStream stream, Vec3 sp) throws IOException {
        stream.writeFloat((float)sp.field_72450_a);
        stream.writeFloat((float)sp.field_72448_b);
        stream.writeFloat((float)sp.field_72449_c);
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        ElectricalLoad electricalLoad;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        ElectricalLoad electricalLoad2 = electricalLoad = this.getGridElectricalLoad(side);
        ElectricalLoad electricalLoad3 = electricalLoad;
        return Utils.plotUIP(electricalLoad2 != null ? electricalLoad2.getVoltage() : 0.0, electricalLoad3 != null ? electricalLoad3.getCurrent() : 0.0);
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        ThermalLoad thermalLoad;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        ThermalLoad thermalLoad2 = thermalLoad = this.getThermalLoad(side, LRDU.Up);
        Intrinsics.checkNotNull(thermalLoad2);
        return Utils.plotCelsius("T", thermalLoad2.temperatureCelsius);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.XN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.XP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.YN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.YP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ZN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ZP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmods/eln/gridnode/GridElement$Companion;", "", "()V", "pending", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lorg/apache/commons/lang3/tuple/Pair;", "Lmods/eln/misc/Coordinate;", "Lmods/eln/misc/Direction;", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

