/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mods.eln.Eln;
import mods.eln.gridnode.GridElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.UserError;
import mods.eln.node.NodeManager;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin._Assertions;
import mods.eln.shadow.kotlin.collections.SetsKt;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 72\u00020\u0001:\u00017B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010(\u001a\u00020#J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u001aJ\u0006\u0010,\u001a\u00020\u001aJ\u000e\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001aJ\u000e\u0010/\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u001aJ\u0018\u00100\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u001aH\u0002J\u0006\u00101\u001a\u00020\tJ\u0018\u00102\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u00103\u001a\u00020*J\u0010\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020\u001aH\u0002J\u0018\u00106\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u0015R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lmods/eln/gridnode/GridLink;", "Lmods/eln/misc/INBTTReady;", "a", "Lmods/eln/misc/Coordinate;", "b", "as", "Lmods/eln/misc/Direction;", "bs", "cable", "Lnet/minecraft/item/ItemStack;", "rs", "", "(Lmods/eln/misc/Coordinate;Lmods/eln/misc/Coordinate;Lmods/eln/misc/Direction;Lmods/eln/misc/Direction;Lnet/minecraft/item/ItemStack;D)V", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "(Lnet/minecraft/nbt/NBTTagCompound;Ljava/lang/String;)V", "getA$Eln", "()Lmods/eln/misc/Coordinate;", "setA$Eln", "(Lmods/eln/misc/Coordinate;)V", "ab", "Lmods/eln/sim/ElectricalConnection;", "ae", "Ljava/util/Optional;", "Lmods/eln/gridnode/GridElement;", "getB$Eln", "setB$Eln", "be", "getCable$Eln", "()Lnet/minecraft/item/ItemStack;", "setCable$Eln", "(Lnet/minecraft/item/ItemStack;)V", "connected", "", "getConnected$Eln", "()Z", "setConnected$Eln", "(Z)V", "connect", "disconnect", "", "elementA", "elementB", "getOtherElement", "gridElement", "getSide", "links", "onBreakElement", "readFromNBT", "selfDestroy", "updateElement", "e", "writeToNBT", "Companion", "Eln"})
@SourceDebugExtension(value={"SMAP\nGridLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridLink.kt\nmods/eln/gridnode/GridLink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1#2:206\n*E\n"})
public final class GridLink
implements INBTTReady {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Coordinate a;
    @NotNull
    private Coordinate b;
    private boolean connected;
    public ItemStack cable;
    private Direction as;
    private Direction bs;
    @NotNull
    private Optional<GridElement> ae;
    @NotNull
    private Optional<GridElement> be;
    @Nullable
    private ElectricalConnection ab;
    private double rs;

    @NotNull
    public final Coordinate getA$Eln() {
        return this.a;
    }

    public final void setA$Eln(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter(coordinate, "<set-?>");
        this.a = coordinate;
    }

    @NotNull
    public final Coordinate getB$Eln() {
        return this.b;
    }

    public final void setB$Eln(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter(coordinate, "<set-?>");
        this.b = coordinate;
    }

    public final boolean getConnected$Eln() {
        return this.connected;
    }

    public final void setConnected$Eln(boolean bl) {
        this.connected = bl;
    }

    @NotNull
    public final ItemStack getCable$Eln() {
        ItemStack itemStack = this.cable;
        if (itemStack != null) {
            return itemStack;
        }
        Intrinsics.throwUninitializedPropertyAccessException("cable");
        return null;
    }

    public final void setCable$Eln(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "<set-?>");
        this.cable = itemStack;
    }

    public GridLink(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Direction as, @NotNull Direction bs, @NotNull ItemStack cable, double rs) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter((Object)as, "as");
        Intrinsics.checkNotNullParameter((Object)bs, "bs");
        Intrinsics.checkNotNullParameter(cable, "cable");
        this.a = new Coordinate();
        this.b = new Coordinate();
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, "empty<GridElement>()");
        this.ae = optional;
        Optional optional2 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional2, "empty<GridElement>()");
        this.be = optional2;
        this.rs = 1.0E9;
        this.rs = rs;
        this.a = a;
        this.b = b;
        this.as = as;
        this.bs = bs;
        this.setCable$Eln(cable);
    }

    public GridLink(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.a = new Coordinate();
        this.b = new Coordinate();
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, "empty<GridElement>()");
        this.ae = optional;
        Optional optional2 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional2, "empty<GridElement>()");
        this.be = optional2;
        this.rs = 1.0E9;
        this.readFromNBT(nbt, str);
    }

    @NotNull
    public final GridElement elementA() {
        if (!this.ae.isPresent()) {
            GridElement gridElement = Companion.getElementFromCoordinate(this.a);
            Intrinsics.checkNotNull(gridElement);
            Optional<GridElement> optional = Optional.of(gridElement);
            Intrinsics.checkNotNullExpressionValue(optional, "of(getElementFromCoordinate(a)!!)");
            this.ae = optional;
        }
        GridElement gridElement = this.ae.get();
        Intrinsics.checkNotNullExpressionValue(gridElement, "ae.get()");
        return gridElement;
    }

    @NotNull
    public final GridElement elementB() {
        if (!this.be.isPresent()) {
            GridElement gridElement = Companion.getElementFromCoordinate(this.b);
            Intrinsics.checkNotNull(gridElement);
            Optional<GridElement> optional = Optional.of(gridElement);
            Intrinsics.checkNotNullExpressionValue(optional, "of(getElementFromCoordinate(b)!!)");
            this.be = optional;
        }
        GridElement gridElement = this.be.get();
        Intrinsics.checkNotNullExpressionValue(gridElement, "be.get()");
        return gridElement;
    }

    public final boolean connect() {
        boolean bl;
        GridElement a = Companion.getElementFromCoordinate(this.a);
        GridElement b = Companion.getElementFromCoordinate(this.b);
        if (a == null || b == null || this.connected) {
            return false;
        }
        Direction direction = this.as;
        if (direction == null) {
            Intrinsics.throwUninitializedPropertyAccessException("as");
            direction = null;
        }
        ElectricalLoad aLoad = a.getGridElectricalLoad(direction);
        Direction direction2 = this.bs;
        if (direction2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("bs");
            direction2 = null;
        }
        ElectricalLoad bLoad = b.getGridElectricalLoad(direction2);
        if (aLoad == null || bLoad == null) {
            throw new UserError("Invalid connection side");
        }
        boolean bl2 = bl = this.ab == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.ab = new ElectricalConnection(aLoad, bLoad);
        Eln.simulator.addElectricalComponent(this.ab);
        ElectricalConnection electricalConnection = this.ab;
        Intrinsics.checkNotNull(electricalConnection);
        electricalConnection.setResistance(this.rs);
        a.getGridLinkList().add(this);
        b.getGridLinkList().add(this);
        this.updateElement(a);
        this.updateElement(b);
        this.connected = true;
        return true;
    }

    private final void updateElement(GridElement e) {
        e.updateIdealRenderAngle();
        HashSet<GridElement> s = new HashSet<GridElement>();
        s.add(e);
        for (GridLink link : e.getGridLinkList()) {
            s.add(link.elementA());
            s.add(link.elementB());
        }
        for (GridElement element : s) {
            element.needPublish();
        }
    }

    public final void disconnect() {
        GridElement it;
        if (!this.connected) {
            return;
        }
        GridElement a = Companion.getElementFromCoordinate(this.a);
        GridElement b = Companion.getElementFromCoordinate(this.b);
        Eln.simulator.removeElectricalComponent(this.ab);
        this.ab = null;
        GridElement gridElement = a;
        if (gridElement != null) {
            it = gridElement;
            boolean bl = false;
            this.updateElement(it);
        }
        GridElement gridElement2 = b;
        if (gridElement2 != null) {
            it = gridElement2;
            boolean bl = false;
            this.updateElement(it);
        }
        this.connected = false;
    }

    private final boolean links(GridElement a, GridElement b) {
        if (Intrinsics.areEqual(this.a, a.coordinate())) {
            return Intrinsics.areEqual(this.b, b.coordinate());
        }
        if (Intrinsics.areEqual(this.a, b.coordinate())) {
            return Intrinsics.areEqual(this.b, a.coordinate());
        }
        return false;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.a.readFromNBT(nbt, str + 'a');
        this.b.readFromNBT(nbt, str + 'b');
        Direction direction = Direction.Companion.readFromNBT(nbt, str + "as");
        Intrinsics.checkNotNull((Object)direction);
        this.as = direction;
        Direction direction2 = Direction.Companion.readFromNBT(nbt, str + "bs");
        Intrinsics.checkNotNull((Object)direction2);
        this.bs = direction2;
        this.rs = nbt.func_74769_h(str + "rs");
        ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nbt);
        Intrinsics.checkNotNullExpressionValue(itemStack, "loadItemStackFromNBT(nbt)");
        this.setCable$Eln(itemStack);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.a.writeToNBT(nbt, str + 'a');
        this.b.writeToNBT(nbt, str + 'b');
        Direction direction = this.as;
        if (direction == null) {
            Intrinsics.throwUninitializedPropertyAccessException("as");
            direction = null;
        }
        direction.writeToNBT(nbt, str + "as");
        Direction direction2 = this.bs;
        if (direction2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("bs");
            direction2 = null;
        }
        direction2.writeToNBT(nbt, str + "bs");
        nbt.func_74780_a(str + "rs", this.rs);
        this.getCable$Eln().func_77955_b(nbt);
    }

    public final void selfDestroy() {
        this.onBreakElement();
    }

    @NotNull
    public final ItemStack onBreakElement() {
        GridElement a = Companion.getElementFromCoordinate(this.a);
        GridElement b = Companion.getElementFromCoordinate(this.b);
        GridElement gridElement = a;
        Intrinsics.checkNotNull(gridElement);
        gridElement.getGridLinkList().remove(this);
        GridElement gridElement2 = b;
        Intrinsics.checkNotNull(gridElement2);
        gridElement2.getGridLinkList().remove(this);
        this.disconnect();
        return this.getCable$Eln();
    }

    @NotNull
    public final Direction getSide(@NotNull GridElement gridElement) {
        Intrinsics.checkNotNullParameter(gridElement, "gridElement");
        if (gridElement == this.elementA()) {
            Direction direction = this.as;
            if (direction == null) {
                Intrinsics.throwUninitializedPropertyAccessException("as");
                direction = null;
            }
            return direction;
        }
        Direction direction = this.bs;
        if (direction == null) {
            Intrinsics.throwUninitializedPropertyAccessException("bs");
            direction = null;
        }
        return direction;
    }

    @NotNull
    public final GridElement getOtherElement(@NotNull GridElement gridElement) {
        Intrinsics.checkNotNullParameter(gridElement, "gridElement");
        if (gridElement == this.elementA()) {
            return this.elementB();
        }
        return this.elementA();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a8\u0006\u0012"}, d2={"Lmods/eln/gridnode/GridLink$Companion;", "", "()V", "addLink", "", "a", "Lmods/eln/gridnode/GridElement;", "b", "as", "Lmods/eln/misc/Direction;", "bs", "cable", "Lmods/eln/sixnode/electricalcable/ElectricalCableDescriptor;", "cableLength", "", "getElementFromCoordinate", "coord", "Lmods/eln/misc/Coordinate;", "Eln"})
    @SourceDebugExtension(value={"SMAP\nGridLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridLink.kt\nmods/eln/gridnode/GridLink$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n766#2:206\n857#2,2:207\n1855#2,2:209\n*S KotlinDebug\n*F\n+ 1 GridLink.kt\nmods/eln/gridnode/GridLink$Companion\n*L\n194#1:206\n194#1:207,2\n195#1:209,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GridElement getElementFromCoordinate(@Nullable Coordinate coord) {
            if (coord == null) {
                return null;
            }
            NodeManager nodeManager = NodeManager.instance;
            Intrinsics.checkNotNull((Object)nodeManager);
            TransparentNodeElement element = nodeManager.getTransparentNodeFromCoordinate(coord);
            if (element instanceof GridElement) {
                return (GridElement)element;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void addLink(@NotNull GridElement a, @NotNull GridElement b, @NotNull Direction as, @NotNull Direction bs, @NotNull ElectricalCableDescriptor cable, int cableLength) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter((Object)as, "as");
            Intrinsics.checkNotNullParameter((Object)bs, "bs");
            Intrinsics.checkNotNullParameter(cable, "cable");
            Iterable iterable = SetsKt.plus((Set)a.getGridLinkList(), (Iterable)b.getGridLinkList());
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GridLink it = (GridLink)element$iv$iv;
                boolean bl = false;
                if (!it.links(a, b)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            if (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                GridLink it = (GridLink)element$iv;
                boolean bl = false;
                throw new UserError("Already Connected");
            }
            Coordinate coordinate = a.coordinate();
            Coordinate coordinate2 = b.coordinate();
            ItemStack itemStack = cable.newItemStack(cableLength);
            Intrinsics.checkNotNullExpressionValue(itemStack, "cable.newItemStack(cableLength)");
            GridLink link = new GridLink(coordinate, coordinate2, as, bs, itemStack, cable.electricalRs * (double)cableLength);
            link.connect();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

