/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mods.eln.gridnode.GridDescriptor;
import mods.eln.misc.UtilsClient;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.collections.IntIterator;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.ranges.IntRange;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bR\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lmods/eln/gridnode/GridRender;", "Lmods/eln/node/transparent/TransparentNodeElementRender;", "tileEntity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "cableTexture", "Lnet/minecraft/util/ResourceLocation;", "catenaries", "Ljava/util/ArrayList;", "Lmods/eln/gridnode/GridRender$Catenary;", "Lmods/eln/gridnode/GridDescriptor;", "idealRenderingAngle", "", "cameraDrawOptimisation", "", "draw", "", "drawCables", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "readVec", "Lnet/minecraft/util/Vec3;", "Catenary", "Eln"})
public abstract class GridRender
extends TransparentNodeElementRender {
    @NotNull
    private final GridDescriptor descriptor;
    @NotNull
    private final ResourceLocation cableTexture;
    @NotNull
    private final ArrayList<Catenary> catenaries;
    private float idealRenderingAngle;

    public GridRender(@NotNull TransparentNodeEntity tileEntity, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(tileEntity, descriptor);
        this.catenaries = new ArrayList();
        this.descriptor = (GridDescriptor)descriptor;
        this.cableTexture = new ResourceLocation("eln", this.descriptor.getCableTexture());
    }

    @Override
    public void draw() {
        this.descriptor.draw(this.idealRenderingAngle);
        this.drawCables();
    }

    public void drawCables() {
        UtilsClient.bindTexture(this.cableTexture);
        GL11.glDisable((int)2884);
        for (Catenary catenary : this.catenaries) {
            catenary.draw();
        }
        GL11.glEnable((int)2884);
    }

    private final Vec3 readVec(DataInputStream stream) throws IOException {
        Vec3 vec3 = Vec3.func_72443_a((double)stream.readFloat(), (double)stream.readFloat(), (double)stream.readFloat());
        Intrinsics.checkNotNullExpressionValue(vec3, "createVectorHelper(strea\u2026m.readFloat().toDouble())");
        return vec3;
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        try {
            for (Catenary catenary : this.catenaries) {
                catenary.destroy();
            }
            this.catenaries.clear();
            this.idealRenderingAngle = stream.readFloat();
            int linkCount = stream.readInt();
            int i = 0;
            int n = linkCount - 1;
            if (i <= n) {
                while (true) {
                    Vec3 splus = this.readVec(stream);
                    Vec3 tplus = this.readVec(stream);
                    Vec3 sgnd = this.readVec(stream);
                    Vec3 tgnd = this.readVec(stream);
                    Vec3 dplus = splus.func_72444_a(tplus).func_72432_b();
                    Vec3 dgnd = sgnd.func_72444_a(tgnd).func_72432_b();
                    double straightV = dplus.func_72430_b(dgnd);
                    dplus = splus.func_72444_a(tgnd).func_72432_b();
                    double crossV = dplus.func_72430_b(dgnd = sgnd.func_72444_a(tplus).func_72432_b());
                    if (crossV < straightV) {
                        this.catenaries.add(new Catenary(splus, tplus));
                        this.catenaries.add(new Catenary(sgnd, tgnd));
                    } else {
                        this.catenaries.add(new Catenary(splus, tgnd));
                        this.catenaries.add(new Catenary(sgnd, tplus));
                    }
                    if (i != n) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J)\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001fJ)\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010(\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010)R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lmods/eln/gridnode/GridRender$Catenary;", "", "start", "Lnet/minecraft/util/Vec3;", "end", "(Lmods/eln/gridnode/GridRender;Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;)V", "box", "", "getBox$Eln", "()[I", "boxTex", "getBoxTex$Eln", "cableWidth", "", "list", "", "getList$Eln", "()I", "origin", "mods.eln.shadow.kotlin.jvm.PlatformType", "getOrigin$Eln", "()Lnet/minecraft/util/Vec3;", "destroy", "", "draw", "drawBox", "from", "", "to", "([Lnet/minecraft/util/Vec3;[Lnet/minecraft/util/Vec3;)V", "getConnectionCatenary", "(Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;)[Lnet/minecraft/util/Vec3;", "multiply", "a", "b", "multiply$Eln", "negate", "v", "spread", "translate", "delta", "([Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;)[Lnet/minecraft/util/Vec3;", "Eln"})
    @SourceDebugExtension(value={"SMAP\nGridRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridRender.kt\nmods/eln/gridnode/GridRender$Catenary\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n11425#2:234\n11536#2,4:235\n37#3,2:239\n37#3,2:245\n1549#4:241\n1620#4,3:242\n*S KotlinDebug\n*F\n+ 1 GridRender.kt\nmods/eln/gridnode/GridRender$Catenary\n*L\n157#1:234\n157#1:235,4\n157#1:239,2\n221#1:245,2\n215#1:241\n215#1:242,3\n*E\n"})
    private final class Catenary {
        private final int list;
        private final Vec3 origin;
        @NotNull
        private final int[] box;
        @NotNull
        private final int[] boxTex;
        private final double cableWidth;

        public Catenary(@NotNull Vec3 start, Vec3 end) {
            Intrinsics.checkNotNullParameter(start, "start");
            Intrinsics.checkNotNullParameter(end, "end");
            this.list = GL11.glGenLists((int)1);
            this.origin = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            int[] nArray = new int[]{3, 7, 5, 3, 5, 1, 4, 8, 6, 4, 6, 2, 1, 6, 5, 1, 2, 6, 3, 8, 7, 3, 4, 8};
            this.box = nArray;
            nArray = new int[]{0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0};
            this.boxTex = nArray;
            this.cableWidth = 0.05;
            Vec3[] catenary = this.getConnectionCatenary(start, end);
            GL11.glNewList((int)this.list, (int)4864);
            GL11.glBegin((int)4);
            if (start.field_72450_a == end.field_72450_a && start.field_72449_c == end.field_72449_c) {
                this.drawBox(this.spread(start, end), this.spread(end, start));
            } else {
                Vec3[] previous = this.spread(start, catenary[0]);
                int i = 0;
                int n = catenary.length - 1 - 1;
                if (i <= n) {
                    while (true) {
                        Vec3[] next = this.spread(catenary[i], catenary[i + 1]);
                        this.drawBox(previous, next);
                        previous = next;
                        if (i == n) break;
                        ++i;
                    }
                }
                Vec3 vec3 = catenary[catenary.length - 2].func_72444_a(catenary[catenary.length - 1]);
                Intrinsics.checkNotNullExpressionValue(vec3, "catenary[catenary.size -\u2026enary[catenary.size - 1])");
                Vec3[] last = this.translate(previous, vec3);
                this.drawBox(previous, last);
            }
            GL11.glEnd();
            GL11.glEndList();
        }

        public final int getList$Eln() {
            return this.list;
        }

        public final Vec3 getOrigin$Eln() {
            return this.origin;
        }

        @NotNull
        public final int[] getBox$Eln() {
            return this.box;
        }

        @NotNull
        public final int[] getBoxTex$Eln() {
            return this.boxTex;
        }

        private final void drawBox(Vec3[] from, Vec3[] to) {
            Vec3[] vec3Array = new Vec3[]{from[0], from[1], from[2], from[3], to[0], to[1], to[2], to[3]};
            Vec3[] v = vec3Array;
            int n = this.box.length;
            for (int i = 0; i < n; ++i) {
                int bc = this.box[i] - 1;
                GL11.glTexCoord2f((float)this.boxTex[bc * 2], (float)this.boxTex[bc * 2 + 1]);
                GL11.glVertex3f((float)((float)v[bc].field_72450_a), (float)((float)v[bc].field_72448_b), (float)((float)v[bc].field_72449_c));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Vec3[] translate(Vec3[] start, Vec3 delta) {
            void $this$mapIndexedTo$iv$iv;
            Vec3[] $this$mapIndexed$iv = start;
            boolean $i$f$mapIndexed = false;
            Vec3[] vec3Array = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void vec3;
                ++index$iv$iv;
                void var12_12 = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(vec3.func_72441_c(delta.field_72450_a, delta.field_72448_b, delta.field_72449_c));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Vec3[0]);
        }

        private final Vec3[] spread(Vec3 a, Vec3 b) {
            Vec3 delta = b.func_72444_a(a);
            Vec3 r = delta.func_72432_b();
            r.func_72442_b(1.0f);
            r.func_72440_a(1.0f);
            Vec3 vec3 = delta.func_72431_c(r).func_72432_b();
            Intrinsics.checkNotNullExpressionValue(vec3, "delta.crossProduct(r).normalize()");
            Vec3 x1 = this.multiply$Eln(vec3, this.cableWidth);
            Vec3 vec32 = delta.func_72431_c(x1).func_72432_b();
            Intrinsics.checkNotNullExpressionValue(vec32, "delta.crossProduct(x1).normalize()");
            Vec3 y1 = this.multiply$Eln(vec32, this.cableWidth);
            Vec3 x2 = this.negate(x1);
            Vec3 y2 = this.negate(y1);
            Vec3[] vec3Array = new Vec3[]{x1, y1, y2, x2};
            return this.translate(vec3Array, a);
        }

        private final Vec3 negate(Vec3 v) {
            Vec3 vec3 = v.func_72444_a(this.origin);
            Intrinsics.checkNotNullExpressionValue(vec3, "v.subtract(origin)");
            return vec3;
        }

        @NotNull
        public final Vec3 multiply$Eln(@NotNull Vec3 a, double b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Vec3 vec3 = Vec3.func_72443_a((double)(a.field_72450_a * b), (double)(a.field_72448_b * b), (double)(a.field_72449_c * b));
            Intrinsics.checkNotNullExpressionValue(vec3, "createVectorHelper(\n    \u2026.zCoord * b\n            )");
            return vec3;
        }

        /*
         * WARNING - void declaration
         */
        private final Vec3[] getConnectionCatenary(Vec3 start, Vec3 end) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            double slack = 1.005;
            int vertices = 16;
            double dx = end.field_72450_a - start.field_72450_a;
            double dy = end.field_72448_b - start.field_72448_b;
            double dz = end.field_72449_c - start.field_72449_c;
            double dw = Math.sqrt(dx * dx + dz * dz);
            double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * slack;
            double l = 0.0;
            for (int limiter = 0; limiter < 300; ++limiter) {
                if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
            }
            double a = dw / 2.0 / l;
            double p = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
            double q = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
            Iterable $this$map$iv = new IntRange(0, vertices - 1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                float n1 = (float)(it + true) / (float)vertices;
                double x1 = 0.0 + dx * (double)n1;
                double z1 = 0.0 + dz * (double)n1;
                double y1 = a * Math.cosh((Math.sqrt(x1 * x1 + z1 * z1) - p) / a) + q;
                collection.add(Vec3.func_72443_a((double)(start.field_72450_a + x1), (double)(start.field_72448_b + y1), (double)(start.field_72449_c + z1)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Vec3[0]);
        }

        public final void draw() {
            GL11.glCallList((int)this.list);
        }

        public final void destroy() {
            GL11.glDeleteLists((int)this.list, (int)1);
        }
    }
}

