/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode;

import java.io.DataOutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.gridnode.GridElement;
import mods.eln.gridnode.GridSwitchDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.GhostPowerNode;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin._Assertions;
import mods.eln.shadow.kotlin.collections.ArraysKt;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import net.minecraft.util.Vec3;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u001a\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0012\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010K\u001a\u00020LH\u0016J\u0018\u0010S\u001a\u00020T2\u0006\u0010K\u001a\u00020L2\u0006\u0010U\u001a\u00020JH\u0014J\u001a\u0010V\u001a\u0004\u0018\u00010P2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0014\u0010W\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Y0XH\u0016J\b\u0010Z\u001a\u00020\bH\u0016J\b\u0010[\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020Y2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010^\u001a\u00020\\2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020Y2\u0006\u0010K\u001a\u00020LH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010%R\u0011\u0010,\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107R\u0011\u0010;\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010%R\u0011\u0010=\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010A\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010)R\u0015\u0010C\u001a\u00060DR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010@\u00a8\u0006c"}, d2={"Lmods/eln/gridnode/GridSwitchElement;", "Lmods/eln/gridnode/GridElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "control", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "getControl", "()Lmods/eln/sim/nbt/NbtElectricalGateInput;", "desc", "Lmods/eln/gridnode/GridSwitchDescriptor;", "getDesc", "()Lmods/eln/gridnode/GridSwitchDescriptor;", "explosion", "Lmods/eln/sim/process/destruct/WorldExplosion;", "getExplosion", "()Lmods/eln/sim/process/destruct/WorldExplosion;", "ghostControl", "Lmods/eln/misc/GhostPowerNode;", "getGhostControl", "()Lmods/eln/misc/GhostPowerNode;", "setGhostControl", "(Lmods/eln/misc/GhostPowerNode;)V", "ghostPower", "getGhostPower", "setGhostPower", "grida", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getGrida", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "gridaWatchdog", "Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "getGridaWatchdog", "()Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "gridb", "getGridb", "gridbWatchdog", "getGridbWatchdog", "interp", "Lmods/eln/misc/PhysicalInterpolator;", "getInterp", "()Lmods/eln/misc/PhysicalInterpolator;", "lastPos", "", "getLastPos", "()F", "setLastPos", "(F)V", "lastTarget", "getLastTarget", "setLastTarget", "power", "getPower", "powerSink", "Lmods/eln/sim/mna/component/Resistor;", "getPowerSink", "()Lmods/eln/sim/mna/component/Resistor;", "powerWatchdog", "getPowerWatchdog", "slowProcess", "Lmods/eln/gridnode/GridSwitchElement$SlowProcess;", "getSlowProcess", "()Lmods/eln/gridnode/GridSwitchElement$SlowProcess;", "transfer", "getTransfer", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "", "getGridElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getRenderCablePoint", "Lnet/minecraft/util/Vec3;", "i", "getThermalLoad", "getWaila", "", "", "hasGui", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "thermoMeterString", "SlowProcess", "Eln"})
@SourceDebugExtension(value={"SMAP\nGridSwitch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridSwitch.kt\nmods/eln/gridnode/GridSwitchElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1#2:352\n*E\n"})
public final class GridSwitchElement
extends GridElement {
    @NotNull
    private final GridSwitchDescriptor desc;
    @NotNull
    private final PhysicalInterpolator interp;
    @NotNull
    private final NbtElectricalGateInput control;
    @NotNull
    private final NbtElectricalLoad power;
    @NotNull
    private final Resistor powerSink;
    @NotNull
    private final NbtElectricalLoad grida;
    @NotNull
    private final NbtElectricalLoad gridb;
    @NotNull
    private final Resistor transfer;
    @NotNull
    private final WorldExplosion explosion;
    @NotNull
    private final VoltageStateWatchDog powerWatchdog;
    @NotNull
    private final VoltageStateWatchDog gridaWatchdog;
    @NotNull
    private final VoltageStateWatchDog gridbWatchdog;
    private float lastPos;
    private float lastTarget;
    private boolean closed;
    @NotNull
    private final SlowProcess slowProcess;
    @Nullable
    private GhostPowerNode ghostPower;
    @Nullable
    private GhostPowerNode ghostControl;

    /*
     * WARNING - void declaration
     */
    public GridSwitchElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor descriptor) {
        void $this$gridbWatchdog_u24lambda_u245;
        NbtElectricalLoad[] $this$gridaWatchdog_u24lambda_u244;
        NbtElectricalLoad[] $this$powerWatchdog_u24lambda_u243;
        NbtElectricalLoad[] $this$transfer_u24lambda_u242;
        NbtElectricalLoad[] $this$powerSink_u24lambda_u241;
        NbtElectricalLoad[] $this$power_u24lambda_u240;
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(node, descriptor, 12);
        this.desc = (GridSwitchDescriptor)descriptor;
        this.interp = new PhysicalInterpolator((float)(1.0 / this.desc.getNominalAccel()), (float)this.desc.getDamping(), (float)this.desc.getDrag(), (float)this.desc.getRebound());
        this.control = new NbtElectricalGateInput("control");
        Object[] objectArray = new NbtElectricalLoad("power");
        NbtElectricalLoad nbtElectricalLoad = objectArray;
        GridSwitchElement gridSwitchElement = this;
        boolean bl = false;
        Eln.instance.meduimVoltageCableDescriptor.applyTo((ElectricalLoad)$this$power_u24lambda_u240);
        gridSwitchElement.power = objectArray;
        objectArray = new Resistor(this.power, null);
        $this$power_u24lambda_u240 = objectArray;
        gridSwitchElement = this;
        boolean bl2 = false;
        $this$powerSink_u24lambda_u241.setResistance(this.desc.getSinkMax());
        gridSwitchElement.powerSink = objectArray;
        this.grida = new NbtElectricalLoad("grida");
        this.gridb = new NbtElectricalLoad("gridb");
        objectArray = new Resistor(this.grida, this.gridb);
        $this$powerSink_u24lambda_u241 = objectArray;
        gridSwitchElement = this;
        boolean bl3 = false;
        $this$transfer_u24lambda_u242.setResistance(this.desc.getResistance());
        gridSwitchElement.transfer = objectArray;
        this.explosion = new WorldExplosion(this).machineExplosion();
        objectArray = new VoltageStateWatchDog(this.power);
        $this$transfer_u24lambda_u242 = objectArray;
        gridSwitchElement = this;
        boolean bl4 = false;
        $this$powerWatchdog_u24lambda_u243.setNominalVoltage(this.desc.getNominalU());
        $this$powerWatchdog_u24lambda_u243.setDestroys(this.explosion);
        this.slowProcessList.add($this$powerWatchdog_u24lambda_u243);
        gridSwitchElement.powerWatchdog = objectArray;
        objectArray = new VoltageStateWatchDog(this.grida);
        $this$powerWatchdog_u24lambda_u243 = objectArray;
        gridSwitchElement = this;
        boolean bl5 = false;
        $this$gridaWatchdog_u24lambda_u244.setNominalVoltage(51200.0);
        $this$gridaWatchdog_u24lambda_u244.setDestroys(this.explosion);
        this.slowProcessList.add($this$gridaWatchdog_u24lambda_u244);
        gridSwitchElement.gridaWatchdog = objectArray;
        objectArray = new VoltageStateWatchDog(this.gridb);
        $this$gridaWatchdog_u24lambda_u244 = objectArray;
        gridSwitchElement = this;
        boolean bl6 = false;
        $this$gridbWatchdog_u24lambda_u245.setNominalVoltage(51200.0);
        $this$gridbWatchdog_u24lambda_u245.setDestroys(this.explosion);
        this.slowProcessList.add($this$gridbWatchdog_u24lambda_u245);
        gridSwitchElement.gridbWatchdog = objectArray;
        this.lastPos = this.interp.get();
        this.lastTarget = this.interp.getTarget();
        this.closed = true;
        this.slowProcess = new SlowProcess();
        objectArray = new NbtElectricalLoad[]{this.power, this.control, this.grida, this.gridb};
        this.electricalLoadList.addAll((Collection)CollectionsKt.listOf(objectArray));
        objectArray = new Resistor[]{this.powerSink, this.transfer};
        this.electricalComponentList.addAll((Collection)CollectionsKt.listOf(objectArray));
        this.slowProcessList.add(this.slowProcess);
    }

    @NotNull
    public final GridSwitchDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final PhysicalInterpolator getInterp() {
        return this.interp;
    }

    @NotNull
    public final NbtElectricalGateInput getControl() {
        return this.control;
    }

    @NotNull
    public final NbtElectricalLoad getPower() {
        return this.power;
    }

    @NotNull
    public final Resistor getPowerSink() {
        return this.powerSink;
    }

    @NotNull
    public final NbtElectricalLoad getGrida() {
        return this.grida;
    }

    @NotNull
    public final NbtElectricalLoad getGridb() {
        return this.gridb;
    }

    @NotNull
    public final Resistor getTransfer() {
        return this.transfer;
    }

    @NotNull
    public final WorldExplosion getExplosion() {
        return this.explosion;
    }

    @NotNull
    public final VoltageStateWatchDog getPowerWatchdog() {
        return this.powerWatchdog;
    }

    @NotNull
    public final VoltageStateWatchDog getGridaWatchdog() {
        return this.gridaWatchdog;
    }

    @NotNull
    public final VoltageStateWatchDog getGridbWatchdog() {
        return this.gridbWatchdog;
    }

    public final float getLastPos() {
        return this.lastPos;
    }

    public final void setLastPos(float f) {
        this.lastPos = f;
    }

    public final float getLastTarget() {
        return this.lastTarget;
    }

    public final void setLastTarget(float f) {
        this.lastTarget = f;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @NotNull
    public final SlowProcess getSlowProcess() {
        return this.slowProcess;
    }

    @Nullable
    public final GhostPowerNode getGhostPower() {
        return this.ghostPower;
    }

    public final void setGhostPower(@Nullable GhostPowerNode ghostPowerNode) {
        this.ghostPower = ghostPowerNode;
    }

    @Nullable
    public final GhostPowerNode getGhostControl() {
        return this.ghostControl;
    }

    public final void setGhostControl(@Nullable GhostPowerNode ghostPowerNode) {
        this.ghostControl = ghostPowerNode;
    }

    @Nullable
    public Void getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Nullable
    public Void getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return 0;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "";
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotUIP(this.grida.getVoltage(), this.grida.getCurrent()) + " / " + Utils.plotUIP(this.gridb.getVoltage(), this.gridb.getCurrent()) + " @" + this.interp.get() + '/' + this.control.getNormalized() + ' ' + Utils.plotUIP(this.power.getVoltage(), this.power.getCurrent());
    }

    @Override
    public void initialize() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        GhostPowerNode ghostPowerNode = this.ghostPower = new GhostPowerNode(transparentNode.coordinate, this.front, new Coordinate(-1, 0, -1, 0), this.power, 1);
        Intrinsics.checkNotNull(ghostPowerNode);
        ghostPowerNode.initialize();
        TransparentNode transparentNode2 = this.node;
        Intrinsics.checkNotNull(transparentNode2);
        GhostPowerNode ghostPowerNode2 = this.ghostControl = new GhostPowerNode(transparentNode2.coordinate, this.front, new Coordinate(-1, 0, 0, 0), this.control, 4);
        Intrinsics.checkNotNull(ghostPowerNode2);
        ghostPowerNode2.initialize();
        StringBuilder stringBuilder = new StringBuilder().append("GS.i: ghost power at ");
        GhostPowerNode ghostPowerNode3 = this.ghostPower;
        Intrinsics.checkNotNull(ghostPowerNode3);
        StringBuilder stringBuilder2 = stringBuilder.append(ghostPowerNode3.getCoord()).append(", control at ");
        GhostPowerNode ghostPowerNode4 = this.ghostControl;
        Intrinsics.checkNotNull(ghostPowerNode4);
        Utils.println(stringBuilder2.append(ghostPowerNode4.getCoord()).toString());
        super.initialize();
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    @Nullable
    public ElectricalLoad getGridElectricalLoad(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Direction direction = side;
        return direction == this.front.left() ? (ElectricalLoad)this.grida : (direction == this.front.right() ? (ElectricalLoad)this.gridb : null);
    }

    @Override
    @NotNull
    protected Vec3 getRenderCablePoint(@NotNull Direction side, int i) {
        int n;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        boolean bl2 = 0 <= i ? i < 2 : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GridSwitchElement$getRenderCablePoint$22 = false;
            String $i$a$-assert-GridSwitchElement$getRenderCablePoint$22 = "Index out of bounds";
            throw new AssertionError((Object)$i$a$-assert-GridSwitchElement$getRenderCablePoint$22);
        }
        Direction $i$a$-assert-GridSwitchElement$getRenderCablePoint$22 = side;
        if ($i$a$-assert-GridSwitchElement$getRenderCablePoint$22 == this.front.left()) {
            n = 0;
        } else if ($i$a$-assert-GridSwitchElement$getRenderCablePoint$22 == this.front.right()) {
            n = 1;
        } else {
            throw new IllegalStateException("Invalid side".toString());
        }
        int idx = n;
        Obj3D.Obj3DPart obj3DPart = (i == 0 ? this.desc.getPlus() : this.desc.getGnd()).get(idx);
        Intrinsics.checkNotNullExpressionValue(obj3DPart, "(if(i == 0) { desc.plus } else { desc.gnd })[idx]");
        Obj3D.Obj3DPart part = obj3DPart;
        Vec3 ro = this.desc.getRenderOffset();
        Vec3 pt = part.boundingBox().centre().func_72441_c(ro.field_72450_a, ro.field_72448_b, ro.field_72449_c);
        Vec3 vec3 = Vec3.func_72443_a((double)pt.field_72449_c, (double)pt.field_72448_b, (double)(-pt.field_72450_a));
        Intrinsics.checkNotNullExpressionValue(vec3, "createVectorHelper(\n    \u2026ord, -pt.xCoord\n        )");
        return vec3;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeFloat(this.interp.getFf());
        stream.writeFloat(this.interp.getTarget());
        stream.writeFloat(this.interp.getFactorFiltered());
        stream.writeFloat(this.interp.getFactorPos());
        stream.writeFloat(this.interp.getFactorSpeed());
        Double[] doubleArray = new Double[]{Math.abs(this.grida.getVoltage() * this.grida.getCurrent()), Math.abs(this.gridb.getVoltage() * this.gridb.getCurrent())};
        stream.writeDouble(ArraysKt.maxOrThrow(doubleArray));
        stream.writeBoolean(this.closed);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info = new LinkedHashMap();
        if (Eln.wailaEasyMode) {
            info.put("Left", Utils.plotUIP(this.grida.getVoltage(), this.grida.getCurrent()));
            info.put("Right", Utils.plotUIP(this.gridb.getVoltage(), this.gridb.getCurrent()));
            info.put("Transfer", Utils.plotPower(this.transfer.getPower()));
        }
        info.put("Drive", Utils.plotUIP(this.power.getVoltage(), this.power.getCurrent(), this.powerSink.getResistance()) + ' ' + Utils.plotOhm(this.powerSink.getResistance()));
        info.put("Signal", Utils.plotSignal(this.control.getVoltage()));
        info.put("Closed?", this.closed ? "Yes" : "No");
        return info;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lmods/eln/gridnode/GridSwitchElement$SlowProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/gridnode/GridSwitchElement;)V", "process", "", "time", "", "Eln"})
    public final class SlowProcess
    implements IProcess {
        @Override
        public void process(double time) {
            GridSwitchElement.this.getInterp().setFf((float)(GridSwitchElement.this.getPower().getVoltage() / GridSwitchElement.this.getDesc().getNominalU() * GridSwitchElement.this.getDesc().getNominalAccel()));
            GridSwitchElement.this.getInterp().setTarget((float)GridSwitchElement.this.getControl().getNormalized());
            GridSwitchElement.this.getInterp().step((float)time);
            GridSwitchElement.this.getPowerSink().setResistance((double)GridSwitchElement.this.getDesc().getSinkMin() + (double)(GridSwitchElement.this.getDesc().getSinkMax() - GridSwitchElement.this.getDesc().getSinkMin()) * (1.0 - (double)Math.abs(GridSwitchElement.this.getInterp().get() - GridSwitchElement.this.getInterp().getTarget())));
            if ((double)Math.abs(GridSwitchElement.this.getLastPos() - GridSwitchElement.this.getInterp().get()) > 0.1 || (double)Math.abs(GridSwitchElement.this.getLastTarget() - GridSwitchElement.this.getInterp().getTarget()) > 0.001) {
                GridSwitchElement.this.setLastPos(GridSwitchElement.this.getInterp().get());
                GridSwitchElement.this.setLastTarget(GridSwitchElement.this.getInterp().getTarget());
                GridSwitchElement.this.needPublish();
            }
            Double[] doubleArray = new Double[]{GridSwitchElement.this.getGrida().getVoltage(), GridSwitchElement.this.getGridb().getVoltage()};
            double maxU = ArraysKt.maxOrThrow(doubleArray);
            if (GridSwitchElement.this.getClosed()) {
                if ((double)GridSwitchElement.this.getInterp().get() > GridSwitchElement.this.getDesc().getSeparationHigh() * (maxU / (double)GridSwitchElement.this.getDesc().getNominalGridU())) {
                    GridSwitchElement.this.setClosed(false);
                    GridSwitchElement.this.getTransfer().ultraImpedance();
                }
            } else if ((double)GridSwitchElement.this.getInterp().get() < GridSwitchElement.this.getDesc().getSeparationLow() * (maxU / (double)GridSwitchElement.this.getDesc().getNominalGridU())) {
                GridSwitchElement.this.setClosed(true);
                GridSwitchElement.this.getTransfer().setResistance(GridSwitchElement.this.getDesc().getResistance());
            }
        }
    }
}

