/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode;

import java.io.DataInputStream;
import mods.eln.gridnode.GridRender;
import mods.eln.gridnode.GridSwitchDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.collections.ArraysKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sound.LoopedSound;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lmods/eln/gridnode/GridSwitchRender;", "Lmods/eln/gridnode/GridRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "desc", "Lmods/eln/gridnode/GridSwitchDescriptor;", "getDesc", "()Lmods/eln/gridnode/GridSwitchDescriptor;", "interp", "Lmods/eln/misc/PhysicalInterpolator;", "getInterp", "()Lmods/eln/misc/PhysicalInterpolator;", "power", "", "getPower", "()D", "setPower", "(D)V", "draw", "", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "refresh", "deltaT", "", "ArcSound", "Eln"})
@SourceDebugExtension(value={"SMAP\nGridSwitch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridSwitch.kt\nmods/eln/gridnode/GridSwitchRender\n+ 2 GLUtil.kt\nmods/eln/misc/GLUtilKt\n*L\n1#1,351:1\n12#2,7:352\n*S KotlinDebug\n*F\n+ 1 GridSwitch.kt\nmods/eln/gridnode/GridSwitchRender\n*L\n344#1:352,7\n*E\n"})
public final class GridSwitchRender
extends GridRender {
    @NotNull
    private final GridSwitchDescriptor desc;
    @NotNull
    private final PhysicalInterpolator interp;
    private double power;
    private boolean closed;

    public GridSwitchRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(entity, descriptor);
        this.setTransparentNodedescriptor((GridSwitchDescriptor)descriptor);
        this.desc = (GridSwitchDescriptor)descriptor;
        this.interp = new PhysicalInterpolator((float)(1.0 / this.desc.getNominalAccel()), (float)this.desc.getDamping(), (float)this.desc.getDrag(), (float)this.desc.getRebound());
        this.closed = true;
        this.addLoopedSound(new ArcSound(this.desc.getArcSound(), this.coordinate()));
    }

    @NotNull
    public final GridSwitchDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final PhysicalInterpolator getInterp() {
        return this.interp;
    }

    public final double getPower() {
        return this.power;
    }

    public final void setPower(double d) {
        this.power = d;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        this.interp.setFf(stream.readFloat());
        this.interp.setTarget(stream.readFloat());
        this.interp.setFactorFiltered(stream.readFloat());
        this.interp.setFactorPos(stream.readFloat());
        this.interp.setFactorSpeed(stream.readFloat());
        this.power = stream.readDouble();
        this.closed = stream.readBoolean();
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.interp.step(deltaT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw() {
        boolean $i$f$preserveMatrix = false;
        Unit ret$iv = null;
        try {
            GL11.glPushMatrix();
            boolean bl = false;
            Direction direction = this.front;
            if (direction != null) {
                direction.glRotateXnRef();
            }
            GridSwitchDescriptor.draw$default(this.desc, (double)this.interp.get() * GridSwitchDescriptor.Companion.getQUARTER_TURN(), false, 2, null);
            ret$iv = Unit.INSTANCE;
        }
        finally {
            GL11.glPopMatrix();
        }
        this.drawCables();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lmods/eln/gridnode/GridSwitchRender$ArcSound;", "Lmods/eln/sound/LoopedSound;", "samp", "", "coord", "Lmods/eln/misc/Coordinate;", "(Lmods/eln/gridnode/GridSwitchRender;Ljava/lang/String;Lmods/eln/misc/Coordinate;)V", "getVolume", "", "Eln"})
    public final class ArcSound
    extends LoopedSound {
        public ArcSound(@NotNull String samp, Coordinate coord) {
            Intrinsics.checkNotNullParameter(samp, "samp");
            Intrinsics.checkNotNullParameter(coord, "coord");
            super(samp, coord, null, 4, null);
        }

        @Override
        public float func_147653_e() {
            float f;
            if (GridSwitchRender.this.getClosed() && (double)GridSwitchRender.this.getInterp().get() > GridSwitchRender.this.getDesc().getSeparationMin() && GridSwitchRender.this.getPower() > 0.0) {
                Float[] floatArray = new Float[]{Float.valueOf((float)GridSwitchRender.this.getDesc().getMaxVolume()), Float.valueOf((float)((0.5 + (double)GridSwitchRender.this.getInterp().get()) * GridSwitchRender.this.getPower() / (double)GridSwitchRender.this.getDesc().getNominalGridP()))};
                f = ArraysKt.minOrThrow(floatArray);
            } else {
                f = 0.0f;
            }
            return f;
        }
    }
}

