/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode.electricalpole;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.gridnode.GridDescriptor;
import mods.eln.gridnode.GridElement;
import mods.eln.gridnode.electricalpole.ElectricalPoleDescriptor;
import mods.eln.gridnode.electricalpole.Kind;
import mods.eln.gridnode.electricalpole.Transformer;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.NoWhenBranchMatchedException;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.process.TransformerInterSystemProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000202H\u0016J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010:2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010;\u001a\u00020:2\u0006\u00106\u001a\u000207H\u0016J\u0018\u0010\u001d\u001a\u00020<2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\b\u0010=\u001a\u000202H\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020BH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006C"}, d2={"Lmods/eln/gridnode/electricalpole/ElectricalPoleElement;", "Lmods/eln/gridnode/GridElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/gridnode/electricalpole/ElectricalPoleDescriptor;", "electricalLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getElectricalLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setElectricalLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "heater", "Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "getHeater$Eln", "()Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "setHeater$Eln", "(Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;)V", "secondaryMaxCurrent", "", "getSecondaryMaxCurrent$Eln", "()F", "setSecondaryMaxCurrent$Eln", "(F)V", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoad", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "setThermalLoad", "(Lmods/eln/sim/nbt/NbtThermalLoad;)V", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalWatchdog$Eln", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "setThermalWatchdog$Eln", "(Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;)V", "trafo", "Lmods/eln/gridnode/electricalpole/Transformer;", "getTrafo", "()Lmods/eln/gridnode/electricalpole/Transformer;", "voltageWatchdog", "Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "getVoltageWatchdog$Eln", "()Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "setVoltageWatchdog$Eln", "(Lmods/eln/sim/process/destruct/VoltageStateWatchDog;)V", "connectJob", "", "disconnectJob", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "Lmods/eln/sim/ElectricalLoad;", "getGridElectricalLoad", "Lmods/eln/sim/ThermalLoad;", "initialize", "multiMeterString", "", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "Eln"})
public final class ElectricalPoleElement
extends GridElement {
    @NotNull
    private final ElectricalPoleDescriptor desc;
    @NotNull
    private NbtElectricalLoad electricalLoad;
    @NotNull
    private NbtThermalLoad thermalLoad;
    @NotNull
    private ElectricalLoadHeatThermalLoad heater;
    @NotNull
    private ThermalLoadWatchDog thermalWatchdog;
    @NotNull
    private VoltageStateWatchDog voltageWatchdog;
    private float secondaryMaxCurrent;
    @Nullable
    private final Transformer trafo;

    public ElectricalPoleElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(node, descriptor, ((GridDescriptor)descriptor).getConnectRange());
        this.desc = (ElectricalPoleDescriptor)descriptor;
        this.electricalLoad = new NbtElectricalLoad("electricalLoad");
        this.thermalLoad = new NbtThermalLoad("thermalLoad");
        this.heater = new ElectricalLoadHeatThermalLoad(this.electricalLoad, this.thermalLoad);
        this.thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
        this.voltageWatchdog = new VoltageStateWatchDog(this.electricalLoad);
        this.electricalLoad.setCanBeSimplifiedByLine(true);
        this.desc.getCableDescriptor().applyTo(this.electricalLoad);
        this.desc.getCableDescriptor().applyTo(this.thermalLoad);
        this.electricalLoadList.add(this.electricalLoad);
        this.thermalLoadList.add(this.thermalLoad);
        this.slowProcessList.add(this.heater);
        this.thermalLoad.setAsSlow();
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setTemperatureLimits(this.desc.getCableDescriptor().thermalWarmLimit, this.desc.getCableDescriptor().thermalCoolLimit).setDestroys(new WorldExplosion(this).cableExplosion());
        this.slowProcessList.add(this.voltageWatchdog);
        WorldExplosion exp = this.desc.getIncludeTransformer() ? new WorldExplosion(this).machineExplosion() : new WorldExplosion(this).cableExplosion();
        this.voltageWatchdog.setNominalVoltage(this.desc.getVoltageLimit()).setDestroys(exp);
        if (this.desc.getIncludeTransformer()) {
            NbtElectricalLoad secondaryLoad = new NbtElectricalLoad("secondaryLoad");
            VoltageSource primaryVoltageSource = new VoltageSource("primaryVoltageSource", this.electricalLoad, null);
            VoltageSource secondaryVoltageSource = new VoltageSource("secondaryVoltageSource", secondaryLoad, null);
            TransformerInterSystemProcess interSystemProcess = new TransformerInterSystemProcess(this.electricalLoad, secondaryLoad, primaryVoltageSource, secondaryVoltageSource);
            VoltageStateWatchDog voltageSecondaryWatchdog = new VoltageStateWatchDog(secondaryLoad);
            this.trafo = new Transformer(secondaryLoad, primaryVoltageSource, secondaryVoltageSource, interSystemProcess, voltageSecondaryWatchdog);
            this.desc.getCableDescriptor().applyTo(secondaryLoad, 4.0);
            this.electricalLoadList.add(secondaryLoad);
            this.electricalComponentList.add(primaryVoltageSource);
            this.electricalComponentList.add(secondaryVoltageSource);
            this.slowProcessList.add(voltageSecondaryWatchdog.setDestroys(exp));
            this.slowProcessList.add(new NodePeriodicPublishProcess(node, 1.0, 0.5));
        } else {
            this.trafo = null;
        }
    }

    @NotNull
    public final NbtElectricalLoad getElectricalLoad() {
        return this.electricalLoad;
    }

    public final void setElectricalLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.electricalLoad = nbtElectricalLoad;
    }

    @NotNull
    public final NbtThermalLoad getThermalLoad() {
        return this.thermalLoad;
    }

    public final void setThermalLoad(@NotNull NbtThermalLoad nbtThermalLoad) {
        Intrinsics.checkNotNullParameter(nbtThermalLoad, "<set-?>");
        this.thermalLoad = nbtThermalLoad;
    }

    @NotNull
    public final ElectricalLoadHeatThermalLoad getHeater$Eln() {
        return this.heater;
    }

    public final void setHeater$Eln(@NotNull ElectricalLoadHeatThermalLoad electricalLoadHeatThermalLoad) {
        Intrinsics.checkNotNullParameter(electricalLoadHeatThermalLoad, "<set-?>");
        this.heater = electricalLoadHeatThermalLoad;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalWatchdog$Eln() {
        return this.thermalWatchdog;
    }

    public final void setThermalWatchdog$Eln(@NotNull ThermalLoadWatchDog thermalLoadWatchDog) {
        Intrinsics.checkNotNullParameter(thermalLoadWatchDog, "<set-?>");
        this.thermalWatchdog = thermalLoadWatchDog;
    }

    @NotNull
    public final VoltageStateWatchDog getVoltageWatchdog$Eln() {
        return this.voltageWatchdog;
    }

    public final void setVoltageWatchdog$Eln(@NotNull VoltageStateWatchDog voltageStateWatchDog) {
        Intrinsics.checkNotNullParameter(voltageStateWatchDog, "<set-?>");
        this.voltageWatchdog = voltageStateWatchDog;
    }

    public final float getSecondaryMaxCurrent$Eln() {
        return this.secondaryMaxCurrent;
    }

    public final void setSecondaryMaxCurrent$Eln(float f) {
        this.secondaryMaxCurrent = f;
    }

    @Nullable
    public final Transformer getTrafo() {
        return this.trafo;
    }

    @Override
    public void disconnectJob() {
        block0: {
            Transformer transformer;
            super.disconnectJob();
            Transformer transformer2 = this.trafo;
            if (transformer2 == null) break block0;
            Transformer $this$disconnectJob_u24lambda_u240 = transformer = transformer2;
            boolean bl = false;
            Eln.simulator.mna.removeProcess($this$disconnectJob_u24lambda_u240.getInterSystemProcess());
        }
    }

    @Override
    public void connectJob() {
        Transformer transformer = this.trafo;
        if (transformer != null) {
            Transformer transformer2;
            Transformer $this$connectJob_u24lambda_u241 = transformer2 = transformer;
            boolean bl = false;
            Eln.simulator.mna.addProcess($this$connectJob_u24lambda_u241.getInterSystemProcess());
        }
        super.connectJob();
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return this.trafo != null ? Utils.plotVolt("GridU:", this.electricalLoad.getVoltage()) + Utils.plotAmpere("GridP:", this.electricalLoad.getCurrent()) + Utils.plotVolt("  GroundU:", this.trafo.getSecondaryLoad().getVoltage()) + Utils.plotAmpere("GroundP:", this.trafo.getSecondaryLoad().getCurrent()) : super.multiMeterString(side);
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        ElectricalLoad electricalLoad;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        switch (WhenMappings.$EnumSwitchMapping$0[this.desc.getKind().ordinal()]) {
            case 1: {
                electricalLoad = null;
                break;
            }
            case 2: {
                Transformer transformer = this.trafo;
                electricalLoad = transformer != null ? transformer.getSecondaryLoad() : null;
                break;
            }
            case 3: {
                electricalLoad = this.electricalLoad;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return electricalLoad;
    }

    @Override
    @NotNull
    public ElectricalLoad getGridElectricalLoad(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return this.electricalLoad;
    }

    @Override
    @NotNull
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.desc.getKind() == Kind.OVERHEAD ? 0 : 1;
    }

    @Override
    public void initialize() {
        Transformer transformer = this.trafo;
        if (transformer != null) {
            Transformer transformer2;
            Transformer $this$initialize_u24lambda_u242 = transformer2 = transformer;
            boolean bl = false;
            $this$initialize_u24lambda_u242.getVoltageSecondaryWatchdog().setNominalVoltage(Eln.instance.veryHighVoltageCableDescriptor.electricalNominalVoltage);
            this.secondaryMaxCurrent = (float)this.desc.getCableDescriptor().electricalMaximalCurrent;
            $this$initialize_u24lambda_u242.getInterSystemProcess().setRatio(0.25);
        }
        super.initialize();
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
        try {
            if (this.trafo != null && !(this.secondaryMaxCurrent == 0.0f)) {
                stream.writeFloat((float)(this.trafo.getSecondaryLoad().getCurrent() / (double)this.secondaryMaxCurrent));
            } else {
                stream.writeFloat(0.0f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Kind.values().length];
            try {
                nArray[Kind.OVERHEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.TRANSFORMER_TO_GROUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.SHUNT_TO_GROUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

