/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode.electricalpole;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderType;
import mods.eln.gridnode.GridRender;
import mods.eln.gridnode.electricalpole.ElectricalPoleDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.SlewLimiter;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sound.LoopedSound;
import net.minecraft.client.audio.ISound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lmods/eln/gridnode/electricalpole/ElectricalPoleRender;", "Lmods/eln/gridnode/GridRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "cableRenderType", "Lmods/eln/cable/CableRenderType;", "getCableRenderType$Eln", "()Lmods/eln/cable/CableRenderType;", "setCableRenderType$Eln", "(Lmods/eln/cable/CableRenderType;)V", "Lmods/eln/gridnode/electricalpole/ElectricalPoleDescriptor;", "eConn", "Lmods/eln/misc/LRDUMask;", "getEConn$Eln", "()Lmods/eln/misc/LRDUMask;", "setEConn$Eln", "(Lmods/eln/misc/LRDUMask;)V", "load", "Lmods/eln/misc/SlewLimiter;", "draw", "", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "refresh", "deltaT", "", "Eln"})
public final class ElectricalPoleRender
extends GridRender {
    @Nullable
    private CableRenderType cableRenderType;
    @NotNull
    private LRDUMask eConn;
    @NotNull
    private final ElectricalPoleDescriptor descriptor;
    @NotNull
    private final SlewLimiter load;

    public ElectricalPoleRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(entity, descriptor);
        this.eConn = new LRDUMask();
        this.load = new SlewLimiter(0.5f);
        this.descriptor = (ElectricalPoleDescriptor)descriptor;
        if (this.descriptor.getIncludeTransformer()) {
            Coordinate coordinate = this.coordinate();
            ISound.AttenuationType attenuationType = ISound.AttenuationType.LINEAR;
            this.addLoopedSound(new LoopedSound(coordinate, attenuationType){

                @Override
                public float func_147653_e() {
                    if (load.getPosition() > descriptor.getMinimalLoadToHum()) {
                        return 0.05f * (load.getPosition() - descriptor.getMinimalLoadToHum()) / (1.0f - descriptor.getMinimalLoadToHum());
                    }
                    return 0.0f;
                }
            });
        }
    }

    @Nullable
    public final CableRenderType getCableRenderType$Eln() {
        return this.cableRenderType;
    }

    public final void setCableRenderType$Eln(@Nullable CableRenderType cableRenderType) {
        this.cableRenderType = cableRenderType;
    }

    @NotNull
    public final LRDUMask getEConn$Eln() {
        return this.eConn;
    }

    public final void setEConn$Eln(@NotNull LRDUMask lRDUMask) {
        Intrinsics.checkNotNullParameter(lRDUMask, "<set-?>");
        this.eConn = lRDUMask;
    }

    @Override
    public void draw() {
        super.draw();
        Direction direction = this.front;
        Intrinsics.checkNotNull((Object)direction);
        this.cableRenderType = this.drawCable(direction.down(), Eln.instance.stdCableRender3200V, this.eConn, this.cableRenderType);
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        this.eConn.deserialize(stream);
        this.cableRenderType = null;
        try {
            this.load.setTarget(stream.readFloat());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.load.step(deltaT);
    }
}

