/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode.transformer;

import java.io.DataOutputStream;
import mods.eln.Eln;
import mods.eln.gridnode.GridElement;
import mods.eln.gridnode.transformer.GridTransformerDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.process.TransformerInterSystemProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.ValueWatchdog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import net.minecraft.util.Vec3;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020GH\u0016J\u0018\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0018\u0010O\u001a\u00020N2\u0006\u0010K\u001a\u00020L2\u0006\u0010P\u001a\u00020QH\u0016J\u001a\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010K\u001a\u00020L2\u0006\u0010P\u001a\u00020QH\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010S2\u0006\u0010K\u001a\u00020LH\u0016J\u0018\u0010U\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010V\u001a\u00020W2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010X\u001a\u00020G2\u0006\u0010Y\u001a\u00020ZH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010 \"\u0004\b/\u0010\"R\u0014\u00100\u001a\u00020$X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010&R\u001a\u00102\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010*\"\u0004\b4\u0010,R\u0014\u00105\u001a\u000206X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020:X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020>X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010@\"\u0004\bE\u0010B\u00a8\u0006["}, d2={"Lmods/eln/gridnode/transformer/GridTransformerElement;", "Lmods/eln/gridnode/GridElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/gridnode/transformer/GridTransformerDescriptor;", "getDesc$Eln", "()Lmods/eln/gridnode/transformer/GridTransformerDescriptor;", "setDesc$Eln", "(Lmods/eln/gridnode/transformer/GridTransformerDescriptor;)V", "explosion", "Lmods/eln/sim/process/destruct/WorldExplosion;", "getExplosion$Eln", "()Lmods/eln/sim/process/destruct/WorldExplosion;", "interSystemProcess", "Lmods/eln/sim/mna/process/TransformerInterSystemProcess;", "getInterSystemProcess", "()Lmods/eln/sim/mna/process/TransformerInterSystemProcess;", "setInterSystemProcess", "(Lmods/eln/sim/mna/process/TransformerInterSystemProcess;)V", "maxCurrent", "", "getMaxCurrent$Eln", "()F", "setMaxCurrent$Eln", "(F)V", "primaryLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getPrimaryLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setPrimaryLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "primaryVoltage", "", "getPrimaryVoltage$Eln", "()D", "primaryVoltageSource", "Lmods/eln/sim/mna/component/VoltageSource;", "getPrimaryVoltageSource", "()Lmods/eln/sim/mna/component/VoltageSource;", "setPrimaryVoltageSource", "(Lmods/eln/sim/mna/component/VoltageSource;)V", "secondaryLoad", "getSecondaryLoad", "setSecondaryLoad", "secondaryVoltage", "getSecondaryVoltage$Eln", "secondaryVoltageSource", "getSecondaryVoltageSource", "setSecondaryVoltageSource", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoad$Eln", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalWatchdog$Eln", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "voltagePrimaryWatchdog", "Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "getVoltagePrimaryWatchdog$Eln", "()Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "setVoltagePrimaryWatchdog$Eln", "(Lmods/eln/sim/process/destruct/VoltageStateWatchDog;)V", "voltageSecondaryWatchdog", "getVoltageSecondaryWatchdog$Eln", "setVoltageSecondaryWatchdog$Eln", "connectJob", "", "disconnectJob", "getCablePoint", "Lnet/minecraft/util/Vec3;", "side", "Lmods/eln/misc/Direction;", "i", "", "getConnectionMask", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getGridElectricalLoad", "getThermalLoad", "multiMeterString", "", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "Eln"})
public final class GridTransformerElement
extends GridElement {
    @NotNull
    private NbtElectricalLoad primaryLoad;
    @NotNull
    private NbtElectricalLoad secondaryLoad;
    @NotNull
    private VoltageSource primaryVoltageSource;
    @NotNull
    private VoltageSource secondaryVoltageSource;
    @NotNull
    private TransformerInterSystemProcess interSystemProcess;
    @NotNull
    private GridTransformerDescriptor desc;
    private float maxCurrent;
    private final double primaryVoltage;
    private final double secondaryVoltage;
    @NotNull
    private final WorldExplosion explosion;
    @NotNull
    private VoltageStateWatchDog voltagePrimaryWatchdog;
    @NotNull
    private VoltageStateWatchDog voltageSecondaryWatchdog;
    @NotNull
    private final NbtThermalLoad thermalLoad;
    @NotNull
    private final ThermalLoadWatchDog thermalWatchdog;

    /*
     * WARNING - void declaration
     */
    public GridTransformerElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor descriptor) {
        void $this$thermalWatchdog_u24lambda_u243;
        Object $this$thermalLoad_u24lambda_u242;
        Object $this$voltageSecondaryWatchdog_u24lambda_u241;
        VoltageStateWatchDog $this$voltagePrimaryWatchdog_u24lambda_u240;
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(node, descriptor, 8);
        this.primaryLoad = new NbtElectricalLoad("primaryLoad");
        this.secondaryLoad = new NbtElectricalLoad("secondaryLoad");
        this.primaryVoltageSource = new VoltageSource("primaryVoltageSource", this.primaryLoad, null);
        this.secondaryVoltageSource = new VoltageSource("secondaryVoltageSource", this.secondaryLoad, null);
        this.interSystemProcess = new TransformerInterSystemProcess(this.primaryLoad, this.secondaryLoad, this.primaryVoltageSource, this.secondaryVoltageSource);
        this.desc = (GridTransformerDescriptor)descriptor;
        this.maxCurrent = (float)this.desc.getCableDescriptor().electricalMaximalCurrent;
        this.primaryVoltage = 120000.0;
        this.secondaryVoltage = this.primaryVoltage / (double)4;
        this.explosion = new WorldExplosion(this).machineExplosion();
        Object object = new VoltageStateWatchDog(this.primaryLoad);
        VoltageStateWatchDog voltageStateWatchDog = object;
        GridTransformerElement gridTransformerElement = this;
        boolean bl = false;
        $this$voltagePrimaryWatchdog_u24lambda_u240.setNominalVoltage(this.primaryVoltage);
        $this$voltagePrimaryWatchdog_u24lambda_u240.setDestroys(this.explosion);
        this.slowProcessList.add($this$voltagePrimaryWatchdog_u24lambda_u240);
        gridTransformerElement.voltagePrimaryWatchdog = object;
        object = new VoltageStateWatchDog(this.secondaryLoad);
        $this$voltagePrimaryWatchdog_u24lambda_u240 = object;
        gridTransformerElement = this;
        boolean bl2 = false;
        ((VoltageStateWatchDog)$this$voltageSecondaryWatchdog_u24lambda_u241).setNominalVoltage(this.secondaryVoltage);
        ((ValueWatchdog)$this$voltageSecondaryWatchdog_u24lambda_u241).setDestroys(this.explosion);
        this.slowProcessList.add($this$voltageSecondaryWatchdog_u24lambda_u241);
        gridTransformerElement.voltageSecondaryWatchdog = object;
        $this$voltageSecondaryWatchdog_u24lambda_u241 = object = new NbtThermalLoad("thermal");
        gridTransformerElement = this;
        boolean bl3 = false;
        this.desc.getCableDescriptor().applyTo((ThermalLoad)$this$thermalLoad_u24lambda_u242);
        ((ThermalLoad)$this$thermalLoad_u24lambda_u242).setAsSlow();
        this.slowProcessList.add(new ElectricalLoadHeatThermalLoad(this.secondaryLoad, (ThermalLoad)$this$thermalLoad_u24lambda_u242));
        this.thermalLoadList.add($this$thermalLoad_u24lambda_u242);
        gridTransformerElement.thermalLoad = object;
        $this$thermalLoad_u24lambda_u242 = object = new ThermalLoadWatchDog(this.thermalLoad);
        gridTransformerElement = this;
        boolean bl4 = false;
        $this$thermalWatchdog_u24lambda_u243.setTemperatureLimits(this.desc.getCableDescriptor().thermalWarmLimit, this.desc.getCableDescriptor().thermalCoolLimit);
        $this$thermalWatchdog_u24lambda_u243.setDestroys(this.explosion);
        this.slowProcessList.add($this$thermalWatchdog_u24lambda_u243);
        gridTransformerElement.thermalWatchdog = object;
        this.electricalLoadList.add(this.primaryLoad);
        this.electricalLoadList.add(this.secondaryLoad);
        this.electricalComponentList.add(this.primaryVoltageSource);
        this.electricalComponentList.add(this.secondaryVoltageSource);
        this.desc.getCableDescriptor().applyTo(this.primaryLoad, 4.0);
        this.desc.getCableDescriptor().applyTo(this.secondaryLoad);
        this.interSystemProcess.setRatio(0.25);
        this.slowProcessList.add(new NodePeriodicPublishProcess(node, 1.0, 0.5));
    }

    @NotNull
    public final NbtElectricalLoad getPrimaryLoad() {
        return this.primaryLoad;
    }

    public final void setPrimaryLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.primaryLoad = nbtElectricalLoad;
    }

    @NotNull
    public final NbtElectricalLoad getSecondaryLoad() {
        return this.secondaryLoad;
    }

    public final void setSecondaryLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.secondaryLoad = nbtElectricalLoad;
    }

    @NotNull
    public final VoltageSource getPrimaryVoltageSource() {
        return this.primaryVoltageSource;
    }

    public final void setPrimaryVoltageSource(@NotNull VoltageSource voltageSource) {
        Intrinsics.checkNotNullParameter(voltageSource, "<set-?>");
        this.primaryVoltageSource = voltageSource;
    }

    @NotNull
    public final VoltageSource getSecondaryVoltageSource() {
        return this.secondaryVoltageSource;
    }

    public final void setSecondaryVoltageSource(@NotNull VoltageSource voltageSource) {
        Intrinsics.checkNotNullParameter(voltageSource, "<set-?>");
        this.secondaryVoltageSource = voltageSource;
    }

    @NotNull
    public final TransformerInterSystemProcess getInterSystemProcess() {
        return this.interSystemProcess;
    }

    public final void setInterSystemProcess(@NotNull TransformerInterSystemProcess transformerInterSystemProcess) {
        Intrinsics.checkNotNullParameter(transformerInterSystemProcess, "<set-?>");
        this.interSystemProcess = transformerInterSystemProcess;
    }

    @NotNull
    public final GridTransformerDescriptor getDesc$Eln() {
        return this.desc;
    }

    public final void setDesc$Eln(@NotNull GridTransformerDescriptor gridTransformerDescriptor) {
        Intrinsics.checkNotNullParameter(gridTransformerDescriptor, "<set-?>");
        this.desc = gridTransformerDescriptor;
    }

    public final float getMaxCurrent$Eln() {
        return this.maxCurrent;
    }

    public final void setMaxCurrent$Eln(float f) {
        this.maxCurrent = f;
    }

    public final double getPrimaryVoltage$Eln() {
        return this.primaryVoltage;
    }

    public final double getSecondaryVoltage$Eln() {
        return this.secondaryVoltage;
    }

    @NotNull
    public final WorldExplosion getExplosion$Eln() {
        return this.explosion;
    }

    @NotNull
    public final VoltageStateWatchDog getVoltagePrimaryWatchdog$Eln() {
        return this.voltagePrimaryWatchdog;
    }

    public final void setVoltagePrimaryWatchdog$Eln(@NotNull VoltageStateWatchDog voltageStateWatchDog) {
        Intrinsics.checkNotNullParameter(voltageStateWatchDog, "<set-?>");
        this.voltagePrimaryWatchdog = voltageStateWatchDog;
    }

    @NotNull
    public final VoltageStateWatchDog getVoltageSecondaryWatchdog$Eln() {
        return this.voltageSecondaryWatchdog;
    }

    public final void setVoltageSecondaryWatchdog$Eln(@NotNull VoltageStateWatchDog voltageStateWatchDog) {
        Intrinsics.checkNotNullParameter(voltageStateWatchDog, "<set-?>");
        this.voltageSecondaryWatchdog = voltageStateWatchDog;
    }

    @NotNull
    public final NbtThermalLoad getThermalLoad$Eln() {
        return this.thermalLoad;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalWatchdog$Eln() {
        return this.thermalWatchdog;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return 0;
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.interSystemProcess);
    }

    @Override
    public void connectJob() {
        Eln.simulator.mna.addProcess(this.interSystemProcess);
        super.connectJob();
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        Direction direction = side;
        return direction == this.front.left() ? (ElectricalLoad)this.primaryLoad : (direction == this.front.right() ? (ElectricalLoad)this.secondaryLoad : null);
    }

    @Override
    @NotNull
    public Vec3 getCablePoint(@NotNull Direction side, int i) {
        int n;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (i >= 2) {
            throw new AssertionError((Object)"Invalid cable point index");
        }
        Direction direction = side;
        if (direction == this.front.left()) {
            n = 1;
        } else if (direction == this.front.right()) {
            n = 0;
        } else {
            throw new AssertionError((Object)"Invalid connection side");
        }
        int idx = n;
        Obj3D.Obj3DPart obj3DPart = (i == 0 ? this.desc.getPlus() : this.desc.getGnd()).get(idx);
        Intrinsics.checkNotNullExpressionValue(obj3DPart, "(if (i == 0) desc.plus else desc.gnd)[idx]");
        Obj3D.Obj3DPart part = obj3DPart;
        return part.boundingBox().centre();
    }

    @Override
    @Nullable
    public ElectricalLoad getGridElectricalLoad(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return this.getElectricalLoad(side, LRDU.Down);
    }

    @Override
    @NotNull
    public NbtThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.thermalLoad;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (side == this.front.up()) {
            return Utils.plotVolt("UP+:", this.primaryLoad.getVoltage()) + Utils.plotAmpere("IP+:", this.primaryLoad.getCurrent());
        }
        if (side == this.front.left()) {
            return Utils.plotVolt("US+:", this.secondaryLoad.getVoltage()) + Utils.plotAmpere("IS+:", this.secondaryLoad.getCurrent());
        }
        return Utils.plotVolt("UP+:", this.primaryLoad.getVoltage()) + Utils.plotAmpere("IP+:", this.primaryLoad.getCurrent()) + Utils.plotVolt("  US+:", this.secondaryLoad.getVoltage()) + Utils.plotAmpere("IS+:", this.secondaryLoad.getCurrent());
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeFloat((float)(this.secondaryLoad.getCurrent() / (double)this.maxCurrent));
    }
}

