/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode.transformer;

import java.io.DataInputStream;
import mods.eln.gridnode.GridRender;
import mods.eln.gridnode.transformer.GridTransformerDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.SlewLimiter;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sound.LoopedSound;
import net.minecraft.client.audio.ISound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lmods/eln/gridnode/transformer/GridTransformerRender;", "Lmods/eln/gridnode/GridRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/gridnode/transformer/GridTransformerDescriptor;", "getDesc", "()Lmods/eln/gridnode/transformer/GridTransformerDescriptor;", "load", "Lmods/eln/misc/SlewLimiter;", "networkUnserialize", "", "stream", "Ljava/io/DataInputStream;", "refresh", "deltaT", "", "Eln"})
public final class GridTransformerRender
extends GridRender {
    @NotNull
    private final GridTransformerDescriptor desc;
    @NotNull
    private SlewLimiter load;

    public GridTransformerRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(entity, descriptor);
        this.desc = (GridTransformerDescriptor)descriptor;
        this.load = new SlewLimiter(0.5f);
        Coordinate coordinate = this.coordinate();
        ISound.AttenuationType attenuationType = ISound.AttenuationType.LINEAR;
        this.addLoopedSound(new LoopedSound(coordinate, attenuationType){

            @Override
            public float func_147653_e() {
                return Math.max(0.0f, (load.getPosition() - this.getDesc().getMinimalLoadToHum()) / (1.0f - this.getDesc().getMinimalLoadToHum()));
            }
        });
    }

    @NotNull
    public final GridTransformerDescriptor getDesc() {
        return this.desc;
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        this.load.setTarget(stream.readFloat());
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.load.step(deltaT);
    }
}

