/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gui;

import java.util.ArrayList;
import mods.eln.gui.GuiHelper;
import mods.eln.gui.IGuiObject;
import mods.eln.misc.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class GuiVerticalTrackBar
extends Gui
implements IGuiObject {
    public boolean sliderDrawEnable = true;
    public int width;
    public int height;
    public int xPosition;
    public int yPosition;
    public boolean enable = false;
    public boolean visible = true;
    boolean drag = false;
    public float min = 0.0f;
    public float max = 1.0f;
    int stepId = 0;
    int stepIdMax = 10;
    IGuiObject.IGuiObjectObserver observer;
    GuiHelper helper;
    ArrayList<String> comment = new ArrayList();

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (!visible) {
            this.drag = false;
        }
    }

    @Override
    public int getYMax() {
        return this.yPosition + this.height;
    }

    public void setObserver(IGuiObject.IGuiObjectObserver observer) {
        this.observer = observer;
    }

    public GuiVerticalTrackBar(int xPosition, int yPosition, int width, int height, GuiHelper helper) {
        this.width = width;
        this.height = height;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.enable = true;
        this.helper = helper;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
        if (!enable || !this.visible) {
            this.drag = false;
        }
    }

    void stepLimit() {
        if (this.stepId < 0) {
            this.stepId = 0;
        }
        if (this.stepId > this.stepIdMax) {
            this.stepId = this.stepIdMax;
        }
    }

    public void setStepIdMax(int stepIdMax) {
        this.stepIdMax = stepIdMax;
        this.stepLimit();
    }

    public void setStepId(int stepId) {
        this.stepId = stepId;
        this.stepLimit();
    }

    public void setValue(float value) {
        if (!this.drag) {
            this.stepId = (int)((double)((value - this.min) / (this.max - this.min) * (float)this.stepIdMax) + 0.5);
            this.stepLimit();
        }
    }

    public float getValue() {
        return this.min + (this.max - this.min) * (float)this.stepId / (float)this.stepIdMax;
    }

    public boolean mouseClicked(int x, int y, int which) {
        if (this.enable && this.visible && which == 0 && x > this.xPosition && y > this.yPosition && x < this.xPosition + this.width && y < this.yPosition + this.height) {
            this.drag = true;
            return true;
        }
        return false;
    }

    public boolean mouseMovedOrUp(int x, int y, int which) {
        if (this.enable && this.visible && this.drag && which == 0) {
            this.mouseMove(x, y);
            if (this.observer != null) {
                this.observer.guiObjectEvent(this);
            }
            Utils.println("New Value : " + this.getValue());
            this.drag = false;
            return true;
        }
        return false;
    }

    public void setRange(float min, float max) {
        this.min = min;
        this.max = max;
        this.stepLimit();
    }

    public void mouseMove(int x, int y) {
        if (this.drag) {
            this.stepId = (int)((1.0 - (double)(y - this.yPosition) / (double)this.height + 1.0 / (double)this.stepIdMax / 2.0) * (double)this.stepIdMax);
            this.stepLimit();
        }
    }

    @Override
    public void imouseMove(int x, int y) {
        this.mouseMove(x, y);
    }

    public int getCursorPosition() {
        return (int)((double)(this.yPosition + this.height) - 1.0 * (double)this.stepId / (double)this.stepIdMax * (double)this.height);
    }

    public int getCursorPositionForValue(float value) {
        int yCalc = (int)((float)(this.yPosition + this.height) - (value -= this.min) / (this.max - this.min) * (float)this.height);
        if (yCalc < this.yPosition) {
            yCalc = this.yPosition;
        }
        if (yCalc > this.yPosition + this.height) {
            yCalc = this.yPosition + this.height;
        }
        return yCalc;
    }

    public void drawBase(float par1, int x, int y) {
        if (!this.visible) {
            return;
        }
        GuiVerticalTrackBar.func_73734_a((int)this.xPosition, (int)(this.yPosition - 2), (int)(this.xPosition + this.width), (int)(this.yPosition + this.height + 2), (int)-12566464);
        GuiVerticalTrackBar.func_73734_a((int)(this.xPosition + 1), (int)(this.yPosition - 1), (int)(this.xPosition + this.width - 1), (int)(this.yPosition + this.height + 1), (int)-10461088);
        GuiVerticalTrackBar.func_73734_a((int)(this.xPosition + 2), (int)this.yPosition, (int)(this.xPosition + this.width - 2), (int)(this.yPosition + this.height), (int)-8355712);
    }

    public void drawBare(float par1, int x, int y) {
        if (!this.visible) {
            return;
        }
        if (!this.sliderDrawEnable) {
            return;
        }
        GuiVerticalTrackBar.func_73734_a((int)(this.xPosition - 2), (int)(this.getCursorPosition() - 2), (int)(this.xPosition + this.width + 2), (int)(this.getCursorPosition() + 2), (int)-14671840);
        GuiVerticalTrackBar.func_73734_a((int)(this.xPosition - 1), (int)(this.getCursorPosition() - 1), (int)(this.xPosition + this.width + 1), (int)(this.getCursorPosition() + 1), (int)-10461088);
    }

    public void setComment(String[] comment) {
        this.comment.clear();
        for (String str : comment) {
            this.comment.add(str);
        }
    }

    public void setComment(int line, String comment) {
        if (this.comment.size() < line + 1) {
            this.comment.add(line, comment);
        } else {
            this.comment.set(line, comment);
        }
    }

    @Override
    public void idraw(int x, int y, float f) {
        this.drawBase(f, x, y);
        this.drawBare(f, x, y);
    }

    @Override
    public boolean ikeyTyped(char key, int code) {
        return false;
    }

    @Override
    public void imouseClicked(int x, int y, int code) {
        if (this.mouseClicked(x, y, code)) {
            // empty if block
        }
    }

    @Override
    public void imouseMovedOrUp(int x, int y, int witch) {
        this.mouseMovedOrUp(x, y, witch);
    }

    @Override
    public void idraw2(int x, int y) {
        if (this.visible && x >= this.xPosition && y >= this.yPosition && x < this.xPosition + this.width && y < this.yPosition + this.height || this.drag) {
            int px = this.xPosition - this.helper.getHoveringTextWidth(this.comment, Minecraft.func_71410_x().field_71466_p) / 2;
            int py = this.yPosition + this.height + 20;
            this.helper.drawHoveringText(this.comment, px, py, Minecraft.func_71410_x().field_71466_p);
        }
    }

    @Override
    public void translate(int x, int y) {
        this.xPosition += x;
        this.yPosition += y;
    }

    public float getStepId() {
        return this.stepId;
    }
}

