/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.hardware;

import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0005J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lmods/eln/hardware/Packet;", "", "opcode", "", "data", "", "(CLjava/lang/String;)V", "getData", "()Ljava/lang/String;", "getOpcode", "()C", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "serialize", "toString", "Eln"})
public final class Packet {
    private final char opcode;
    @NotNull
    private final String data;

    public Packet(char opcode, @NotNull String data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.opcode = opcode;
        this.data = data;
    }

    public final char getOpcode() {
        return this.opcode;
    }

    @NotNull
    public final String getData() {
        return this.data;
    }

    @NotNull
    public final String serialize() {
        if (this.data.length() > 9) {
            System.out.println((Object)"Error! Packet data is malformed, data payload was over 9 characters long!");
            System.out.println((Object)("Data payload: {" + this.data + '}'));
            return "";
        }
        return "" + this.opcode + this.data.length() + this.data;
    }

    public final char component1() {
        return this.opcode;
    }

    @NotNull
    public final String component2() {
        return this.data;
    }

    @NotNull
    public final Packet copy(char opcode, @NotNull String data) {
        Intrinsics.checkNotNullParameter(data, "data");
        return new Packet(opcode, data);
    }

    public static /* synthetic */ Packet copy$default(Packet packet, char c, String string, int n, Object object) {
        if ((n & 1) != 0) {
            c = packet.opcode;
        }
        if ((n & 2) != 0) {
            string = packet.data;
        }
        return packet.copy(c, string);
    }

    @NotNull
    public String toString() {
        return "Packet(opcode=" + this.opcode + ", data=" + this.data + ')';
    }

    public int hashCode() {
        int result = Character.hashCode(this.opcode);
        result = result * 31 + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Packet)) {
            return false;
        }
        Packet packet = (Packet)other;
        if (this.opcode != packet.opcode) {
            return false;
        }
        return Intrinsics.areEqual(this.data, packet.data);
    }
}

