/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.hardware;

import com.fazecast.jSerialComm.SerialPort;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mods.eln.hardware.ISerial;
import mods.eln.hardware.Packet;
import mods.eln.hardware.PacketSerialKt;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.text.Charsets;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\u000e\u001a\u00020\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lmods/eln/hardware/PacketSerial;", "", "()V", "availablePorts", "", "", "getAvailablePorts", "()Ljava/util/List;", "openSerialPort", "", "instance", "Lmods/eln/hardware/ISerial;", "releaseSerialPort", "setUpSerial", "tick", "Eln"})
@SourceDebugExtension(value={"SMAP\nPacketSerial.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketSerial.kt\nmods/eln/hardware/PacketSerial\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n11335#2:146\n11670#2,3:147\n215#3,2:150\n215#3,2:152\n1855#4,2:154\n*S KotlinDebug\n*F\n+ 1 PacketSerial.kt\nmods/eln/hardware/PacketSerial\n*L\n21#1:146\n21#1:147,3\n68#1:150,2\n74#1:152,2\n117#1:154,2\n*E\n"})
public final class PacketSerial {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAvailablePorts() {
        void $this$mapTo$iv$iv;
        SerialPort[] serialPortArray = SerialPort.getCommPorts();
        Intrinsics.checkNotNullExpressionValue(serialPortArray, "getCommPorts()");
        Object[] $this$map$iv = serialPortArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerialPort serialPort = (SerialPort)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSystemPortName());
        }
        return (List)destination$iv$iv;
    }

    public final synchronized void openSerialPort(@NotNull ISerial instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        if (this.getAvailablePorts().contains(instance.getPortName()) && !((ConcurrentHashMap.KeySetView)PacketSerialKt.access$getAllocationsList$p().keySet()).contains(instance.getPortName())) {
            ((Map)PacketSerialKt.access$getAllocationsList$p()).put(instance.getPortName(), instance);
            this.setUpSerial(instance);
        }
    }

    private final void setUpSerial(ISerial instance) {
        SerialPort port = SerialPort.getCommPort((String)instance.getPortName());
        port.setBaudRate(instance.getBaudRate());
        Map map = PacketSerialKt.access$getPortList$p();
        Intrinsics.checkNotNullExpressionValue(port, "port");
        map.put(instance, port);
        Map map2 = PacketSerialKt.access$getReaderList$p();
        InputStream inputStream = port.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "port.inputStream");
        Closeable closeable = inputStream;
        map2.put(instance, closeable);
        map2 = PacketSerialKt.access$getWriterList$p();
        OutputStream outputStream = port.getOutputStream();
        Intrinsics.checkNotNullExpressionValue(outputStream, "port.outputStream");
        closeable = outputStream;
        Charset charset = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, charset);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        map2.put(instance, closeable);
    }

    public final void releaseSerialPort(@NotNull ISerial instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        PacketSerialKt.access$getAllocationsList$p().remove(instance.getPortName());
    }

    public final void tick() {
        Map.Entry it;
        Map.Entry element$iv;
        Map $this$forEach$iv = PacketSerialKt.access$getAllocationsList$p();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            Object v = PacketSerialKt.access$getPortList$p().get(it.getValue());
            Intrinsics.checkNotNull(v);
            if (((SerialPort)v).isOpen()) continue;
            this.releaseSerialPort((ISerial)it.getValue());
        }
        $this$forEach$iv = PacketSerialKt.access$getAllocationsList$p();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            Thread t = new Thread(() -> PacketSerial.tick$lambda$4$lambda$3(it));
            t.start();
        }
    }

    private static final void tick$lambda$4$lambda$3(Map.Entry $it) {
        Intrinsics.checkNotNullParameter($it, "$it");
        long start = System.currentTimeMillis();
        ISerial instance = (ISerial)$it.getValue();
        InputStream reader = (InputStream)PacketSerialKt.access$getReaderList$p().get(instance);
        BufferedWriter writer = (BufferedWriter)PacketSerialKt.access$getWriterList$p().get(instance);
        try {
            if (reader != null) {
                boolean run = false;
                String packetData = "";
                if (reader.available() > 0) {
                    char c = (char)reader.read();
                    packetData = c != '\n' ? packetData + c : "";
                } else {
                    run = false;
                }
                if (packetData.length() >= 2) {
                    char opcode = packetData.charAt(0);
                    char length = packetData.charAt(1);
                    if (length == packetData.length() - 2) {
                        String string = packetData.substring(2);
                        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                        Packet p = new Packet(opcode, string);
                        instance.getFromDevice().add(p);
                        if (System.currentTimeMillis() - start > 5L) {
                            run = false;
                        }
                    }
                }
            }
        }
        catch (Exception run) {
            // empty catch block
        }
        try {
            Iterable $this$forEach$iv = instance.getToDevice();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Packet it = (Packet)element$iv;
                boolean bl = false;
                BufferedWriter bufferedWriter = writer;
                if (bufferedWriter == null) continue;
                bufferedWriter.write(it.serialize());
            }
            BufferedWriter bufferedWriter = writer;
            if (bufferedWriter != null) {
                bufferedWriter.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

