/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.i18n;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;

public class I18N {
    private static final LanguageRegistry languageRegistry = LanguageRegistry.instance();

    public static String getCurrentLanguage() {
        return FMLCommonHandler.instance().getCurrentLanguage();
    }

    static String encodeLangKey(String key) {
        return I18N.encodeLangKey(key, true);
    }

    static String encodeLangKey(String key, boolean replaceWhitspaces) {
        if (key != null) {
            if (replaceWhitspaces) {
                key = key.replace(' ', '_');
            }
            return key.replace("=", "\\=").replace(":", "\\:").replace("\n", "\\n").replace("/", "_");
        }
        return null;
    }

    public static String tr(String text, Object ... objects) {
        String translation = languageRegistry.getStringLocalization(I18N.encodeLangKey(text));
        translation = translation == null || "".equals(translation) ? text : translation.replace("\\n", "\n").replace("\\:", ":");
        for (int i = 0; i < objects.length; ++i) {
            translation = translation.replace("%" + (i + 1) + "$", String.valueOf(objects[i]));
        }
        return translation;
    }

    public static String TR(String text) {
        return I18N.encodeLangKey(text);
    }

    public static String TR_NAME(Type type, String text) {
        if (type.isEncodedAtRuntime()) {
            return type.getPrefix() + I18N.encodeLangKey(text) + ".name";
        }
        return text;
    }

    public static String TR_DESC(Type type, String text) {
        if (type.isEncodedAtRuntime()) {
            return type.getPrefix() + I18N.encodeLangKey(text) + ".desc";
        }
        return text;
    }

    public static enum Type {
        NONE("", false, true),
        ITEM("item.", false, false),
        TILE("tile.", false, false),
        ACHIEVEMENT("achievement.", true, true),
        ENTITY("entity.", false, false),
        DEATH_ATTACK("death.attack.", false, false),
        ITEM_GROUP("itemGroup.", false, false),
        CONTAINER("container.", false, false),
        BLOCK("block.", false, false),
        SIX_NODE("eln.sixnode.", false, true),
        NODE("eln.node.", false, true);

        private final String prefix;
        private final boolean encodeAtRuntime;
        private final boolean replaceWhitespacesInFile;

        private Type(String prefix, boolean encodeAtRuntime, boolean replaceWhitespacesInFile) {
            this.prefix = prefix;
            this.encodeAtRuntime = encodeAtRuntime;
            this.replaceWhitespacesInFile = replaceWhitespacesInFile;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean isEncodedAtRuntime() {
            return this.encodeAtRuntime;
        }

        public boolean isWhitespacesInFileReplaced() {
            return this.replaceWhitespacesInFile;
        }
    }
}

