/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.i18n;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import mods.eln.i18n.TranslationItem;

class LanguageFileGenerator {
    private static final String FILE_HEADER = "#<ELN_LANGFILE_V1_1>\n";

    private LanguageFileGenerator() {
    }

    public static void updateFile(File file, Map<String, Set<TranslationItem>> strings, Properties existingTranslations) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.append(FILE_HEADER);
        for (String sourceFile : strings.keySet()) {
            String sourcePath = sourceFile.replace("\\", "/");
            writer.append("\n# ").append(sourcePath).append("\n");
            for (TranslationItem text2Translate : strings.get(sourceFile)) {
                text2Translate.applyExistingTranslationIfPresent(existingTranslations);
                writer.append(text2Translate.toString());
            }
        }
        writer.close();
    }
}

