/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import mods.eln.i18n.LanguageFileGenerator;
import mods.eln.i18n.SourceCodeParser;
import mods.eln.i18n.TranslationItem;

class LanguageFileUpdater {
    private LanguageFileUpdater() {
    }

    private static void updateFile(File languageFile, Map<String, Set<TranslationItem>> stringsToTranslate) throws IOException {
        Properties existingTranslations = new Properties();
        existingTranslations.load(new FileInputStream(languageFile));
        LanguageFileGenerator.updateFile(languageFile, stringsToTranslate, existingTranslations);
    }

    public static void main(String ... args2) {
        try {
            if (args2.length != 2) {
                System.exit(1);
            }
            File srcFolder = new File(args2[0]);
            File languageFileOrFolder = new File(args2[1]);
            if (!srcFolder.isDirectory()) {
                System.exit(1);
            }
            Map<String, Set<TranslationItem>> stringsToTranslate = SourceCodeParser.parseSourceFolder(srcFolder);
            TreeSet<TranslationItem> item = new TreeSet<TranslationItem>();
            item.add(new TranslationItem("Grid_DC-DC_Converter.name", "Grid Transformer"));
            item.add(new TranslationItem("Transmission_Tower.name", "T2 Transmission Tower"));
            item.add(new TranslationItem("Utility_Pole.name", "T1 Utility Pole"));
            item.add(new TranslationItem("Utility_Pole_w/DC-DC_Converter.name", "T1 Utility Pole with Transformer"));
            stringsToTranslate.putIfAbsent("FIXME", item);
            if (languageFileOrFolder.isFile()) {
                LanguageFileUpdater.updateFile(languageFileOrFolder, stringsToTranslate);
            } else if (languageFileOrFolder.isDirectory()) {
                for (File file : languageFileOrFolder.listFiles()) {
                    if (!file.getName().endsWith(".lang") || file.getName().startsWith("_")) continue;
                    LanguageFileUpdater.updateFile(file, stringsToTranslate);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
    }
}

