/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.integration.waila;

import com.google.common.cache.CacheLoader;
import cpw.mods.fml.common.Optional;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mods.eln.integration.waila.GhostNodeWailaData;
import mods.eln.integration.waila.SixNodeWailaProvider;
import mods.eln.integration.waila.TransparentNodeWailaProvider;
import mods.eln.integration.waila.WailaCache;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.packets.GhostNodeWailaResponsePacket;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="mcp.mobius.waila.api.IWailaDataProvider", modid="Waila")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002JJ\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J:\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J8\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001c\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J8\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lmods/eln/integration/waila/GhostNodeWailaProvider;", "Lmcp/mobius/waila/api/IWailaDataProvider;", "transparentNodeProvider", "Lmods/eln/integration/waila/TransparentNodeWailaProvider;", "sixNodeProvider", "Lmods/eln/integration/waila/SixNodeWailaProvider;", "(Lmods/eln/integration/waila/TransparentNodeWailaProvider;Lmods/eln/integration/waila/SixNodeWailaProvider;)V", "getGhostData", "Lmods/eln/integration/waila/GhostNodeWailaData;", "accessor", "Lmcp/mobius/waila/api/IWailaDataAccessor;", "getNBTData", "Lnet/minecraft/nbt/NBTTagCompound;", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "te", "Lnet/minecraft/tileentity/TileEntity;", "tag", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "getWailaBody", "", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "currenttip", "config", "Lmcp/mobius/waila/api/IWailaConfigHandler;", "getWailaHead", "getWailaStack", "getWailaTail", "WailaDataAccessorProxy", "Eln"})
public final class GhostNodeWailaProvider
implements IWailaDataProvider {
    @NotNull
    private final TransparentNodeWailaProvider transparentNodeProvider;
    @NotNull
    private final SixNodeWailaProvider sixNodeProvider;

    public GhostNodeWailaProvider(@NotNull TransparentNodeWailaProvider transparentNodeProvider, @NotNull SixNodeWailaProvider sixNodeProvider) {
        Intrinsics.checkNotNullParameter(transparentNodeProvider, "transparentNodeProvider");
        Intrinsics.checkNotNullParameter(sixNodeProvider, "sixNodeProvider");
        this.transparentNodeProvider = transparentNodeProvider;
        this.sixNodeProvider = sixNodeProvider;
    }

    private final GhostNodeWailaData getGhostData(IWailaDataAccessor accessor) {
        int n = accessor.getPosition().field_72311_b;
        int n2 = accessor.getPosition().field_72312_c;
        int n3 = accessor.getPosition().field_72309_d;
        World world = accessor.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "accessor.world");
        Coordinate coord = new Coordinate(n, n2, n3, world);
        GhostNodeWailaData ghostData = null;
        try {
            ghostData = (GhostNodeWailaData)WailaCache.ghostNodes.get((Object)coord);
        }
        catch (CacheLoader.InvalidCacheLoadException invalidCacheLoadException) {
            // empty catch block
        }
        return ghostData;
    }

    @Nullable
    public List<String> getWailaBody(@Nullable ItemStack itemStack, @NotNull List<String> currenttip, @NotNull IWailaDataAccessor accessor, @Nullable IWailaConfigHandler config) {
        Coordinate realCoord;
        GhostNodeWailaData ghostData;
        Intrinsics.checkNotNullParameter(currenttip, "currenttip");
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        GhostNodeWailaData ghostNodeWailaData = ghostData = this.getGhostData(accessor);
        Coordinate coordinate = realCoord = ghostNodeWailaData != null ? ghostNodeWailaData.getRealCoord() : null;
        if (ghostData != null && realCoord != null) {
            byte by = ghostData.getRealType();
            return by == GhostNodeWailaResponsePacket.Companion.getTRANSPARENT_BLOCK_TYPE() ? this.transparentNodeProvider.getWailaBody(itemStack, currenttip, new WailaDataAccessorProxy(accessor, realCoord, null, 4, null), config) : (by == GhostNodeWailaResponsePacket.Companion.getSIXNODE_TYPE() ? this.sixNodeProvider.getWailaBody(itemStack, currenttip, new WailaDataAccessorProxy(accessor, realCoord, ghostData.getRealSide()), config) : currenttip);
        }
        return currenttip;
    }

    @Nullable
    public ItemStack getWailaStack(@NotNull IWailaDataAccessor accessor, @Nullable IWailaConfigHandler config) {
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        GhostNodeWailaData ghostNodeWailaData = this.getGhostData(accessor);
        return ghostNodeWailaData != null ? ghostNodeWailaData.getItemStack() : null;
    }

    @NotNull
    public List<String> getWailaTail(@Nullable ItemStack itemStack, @NotNull List<String> currenttip, @NotNull IWailaDataAccessor accessor, @Nullable IWailaConfigHandler config) {
        Intrinsics.checkNotNullParameter(currenttip, "currenttip");
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        return currenttip;
    }

    @Nullable
    public NBTTagCompound getNBTData(@Nullable EntityPlayerMP player, @Nullable TileEntity te, @Nullable NBTTagCompound tag, @Nullable World world, int x, int y, int z) {
        return null;
    }

    @NotNull
    public List<String> getWailaHead(@Nullable ItemStack itemStack, @NotNull List<String> currenttip, @NotNull IWailaDataAccessor accessor, @Nullable IWailaConfigHandler config) {
        List<String> list;
        Intrinsics.checkNotNullParameter(currenttip, "currenttip");
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        if (itemStack != null) {
            String[] stringArray = new String[]{SpecialChars.WHITE + itemStack.func_82833_r()};
            list = CollectionsKt.mutableListOf(stringArray);
        } else {
            list = currenttip;
        }
        return list;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u00140\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\n \u0010*\u0004\u0018\u00010\u00170\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\n \u0010*\u0004\u0018\u00010\u001e0\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\n \u0010*\u0004\u0018\u00010\"0\"H\u0016J\u0010\u0010\f\u001a\n \u0010*\u0004\u0018\u00010#0#H\u0016J\u0010\u0010$\u001a\n \u0010*\u0004\u0018\u00010%0%H\u0016J\u0010\u0010&\u001a\n \u0010*\u0004\u0018\u00010'0'H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lmods/eln/integration/waila/GhostNodeWailaProvider$WailaDataAccessorProxy;", "Lmcp/mobius/waila/api/IWailaDataAccessor;", "accessor", "coord", "Lmods/eln/misc/Coordinate;", "side", "Lmods/eln/misc/Direction;", "(Lmcp/mobius/waila/api/IWailaDataAccessor;Lmods/eln/misc/Coordinate;Lmods/eln/misc/Direction;)V", "getAccessor", "()Lmcp/mobius/waila/api/IWailaDataAccessor;", "getCoord", "()Lmods/eln/misc/Coordinate;", "getSide", "()Lmods/eln/misc/Direction;", "getBlock", "Lnet/minecraft/block/Block;", "mods.eln.shadow.kotlin.jvm.PlatformType", "getBlockID", "", "getBlockQualifiedName", "", "getMetadata", "getNBTData", "Lnet/minecraft/nbt/NBTTagCompound;", "getNBTInteger", "tag", "keyname", "getPartialFrame", "", "getPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "getPosition", "Lnet/minecraft/util/MovingObjectPosition;", "getRenderingPosition", "Lnet/minecraft/util/Vec3;", "Lnet/minecraftforge/common/util/ForgeDirection;", "getStack", "Lnet/minecraft/item/ItemStack;", "getTileEntity", "Lnet/minecraft/tileentity/TileEntity;", "getWorld", "Lnet/minecraft/world/World;", "Eln"})
    private static final class WailaDataAccessorProxy
    implements IWailaDataAccessor {
        @NotNull
        private final IWailaDataAccessor accessor;
        @NotNull
        private final Coordinate coord;
        @Nullable
        private final Direction side;

        public WailaDataAccessorProxy(@NotNull IWailaDataAccessor accessor, @NotNull Coordinate coord, @Nullable Direction side) {
            Intrinsics.checkNotNullParameter(accessor, "accessor");
            Intrinsics.checkNotNullParameter(coord, "coord");
            this.accessor = accessor;
            this.coord = coord;
            this.side = side;
        }

        public /* synthetic */ WailaDataAccessorProxy(IWailaDataAccessor iWailaDataAccessor, Coordinate coordinate, Direction direction, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                direction = null;
            }
            this(iWailaDataAccessor, coordinate, direction);
        }

        @NotNull
        public final IWailaDataAccessor getAccessor() {
            return this.accessor;
        }

        @NotNull
        public final Coordinate getCoord() {
            return this.coord;
        }

        @Nullable
        public final Direction getSide() {
            return this.side;
        }

        public EntityPlayer getPlayer() {
            return this.accessor.getPlayer();
        }

        public ItemStack getStack() {
            return this.accessor.getStack();
        }

        @NotNull
        public MovingObjectPosition getPosition() {
            return new MovingObjectPosition(this.coord.x, this.coord.y, this.coord.z, this.accessor.getPosition().field_72310_e, this.accessor.getPosition().field_72307_f);
        }

        public ForgeDirection getSide() {
            return this.side != null ? this.side.toForge() : this.accessor.getSide();
        }

        public int getBlockID() {
            return this.accessor.getBlockID();
        }

        public double getPartialFrame() {
            return this.accessor.getPartialFrame();
        }

        public int getMetadata() {
            return this.accessor.getMetadata();
        }

        public String getBlockQualifiedName() {
            return this.accessor.getBlockQualifiedName();
        }

        public Vec3 getRenderingPosition() {
            return this.accessor.getRenderingPosition();
        }

        public NBTTagCompound getNBTData() {
            return this.accessor.getNBTData();
        }

        public TileEntity getTileEntity() {
            return this.accessor.getTileEntity();
        }

        @NotNull
        public World getWorld() {
            Utils.println("Debugging WAILA, getWorld: " + this.coord + ' ' + this.coord.x + ' ' + this.coord.y + ' ' + this.coord.z + ' ' + this.coord.dimension + ' ' + this.coord.world());
            return this.coord.world();
        }

        public Block getBlock() {
            return this.accessor.getBlock();
        }

        public int getNBTInteger(@Nullable NBTTagCompound tag, @Nullable String keyname) {
            return this.accessor.getNBTInteger(tag, keyname);
        }
    }
}

