/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.integration.waila;

import com.google.common.cache.CacheLoader;
import cpw.mods.fml.common.Optional;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mods.eln.integration.waila.SixNodeCoordonate;
import mods.eln.integration.waila.SixNodeWailaData;
import mods.eln.integration.waila.WailaCache;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@Optional.Interface(iface="mcp.mobius.waila.api.IWailaDataProvider", modid="Waila")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J8\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J8\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J:\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a8\u0006\u001f"}, d2={"Lmods/eln/integration/waila/SixNodeWailaProvider;", "Lmcp/mobius/waila/api/IWailaDataProvider;", "()V", "getNBTData", "Lnet/minecraft/nbt/NBTTagCompound;", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "te", "Lnet/minecraft/tileentity/TileEntity;", "tag", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "getSixData", "Lmods/eln/integration/waila/SixNodeWailaData;", "accessor", "Lmcp/mobius/waila/api/IWailaDataAccessor;", "getWailaBody", "", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "currenttip", "config", "Lmcp/mobius/waila/api/IWailaConfigHandler;", "getWailaHead", "getWailaStack", "getWailaTail", "Eln"})
@SourceDebugExtension(value={"SMAP\nSixNodeWailaProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SixNodeWailaProvider.kt\nmods/eln/integration/waila/SixNodeWailaProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,57:1\n215#2,2:58\n*S KotlinDebug\n*F\n+ 1 SixNodeWailaProvider.kt\nmods/eln/integration/waila/SixNodeWailaProvider\n*L\n34#1:58,2\n*E\n"})
public final class SixNodeWailaProvider
implements IWailaDataProvider {
    private final SixNodeWailaData getSixData(IWailaDataAccessor accessor) {
        int n = accessor.getPosition().field_72311_b;
        int n2 = accessor.getPosition().field_72312_c;
        int n3 = accessor.getPosition().field_72309_d;
        World world = accessor.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "accessor.world");
        Coordinate coord = new Coordinate(n, n2, n3, world);
        Direction side = Direction.Companion.from(accessor.getSide());
        SixNodeWailaData sixData = null;
        try {
            sixData = (SixNodeWailaData)WailaCache.sixNodes.get((Object)new SixNodeCoordonate(coord, side));
        }
        catch (CacheLoader.InvalidCacheLoadException invalidCacheLoadException) {
            // empty catch block
        }
        return sixData;
    }

    @NotNull
    public List<String> getWailaBody(@Nullable ItemStack itemStack, @NotNull List<String> currenttip, @NotNull IWailaDataAccessor accessor, @Nullable IWailaConfigHandler config) {
        block1: {
            Intrinsics.checkNotNullParameter(currenttip, "currenttip");
            Intrinsics.checkNotNullParameter(accessor, "accessor");
            Object object = this.getSixData(accessor);
            if (object == null || (object = ((SixNodeWailaData)object).getData()) == null) break block1;
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl = false;
                currenttip.add((String)it.getKey() + ": " + SpecialChars.WHITE + (String)it.getValue());
            }
        }
        return currenttip;
    }

    @Nullable
    public ItemStack getWailaStack(@NotNull IWailaDataAccessor accessor, @Nullable IWailaConfigHandler config) {
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        SixNodeWailaData sixNodeWailaData = this.getSixData(accessor);
        return sixNodeWailaData != null ? sixNodeWailaData.getItemStack() : null;
    }

    @NotNull
    public List<String> getWailaTail(@Nullable ItemStack itemStack, @NotNull List<String> currenttip, @Nullable IWailaDataAccessor accessor, @Nullable IWailaConfigHandler config) {
        Intrinsics.checkNotNullParameter(currenttip, "currenttip");
        return currenttip;
    }

    @Nullable
    public NBTTagCompound getNBTData(@Nullable EntityPlayerMP player, @Nullable TileEntity te, @Nullable NBTTagCompound tag, @Nullable World world, int x, int y, int z) {
        return null;
    }

    @NotNull
    public List<String> getWailaHead(@Nullable ItemStack itemStack, @NotNull List<String> currenttip, @NotNull IWailaDataAccessor accessor, @Nullable IWailaConfigHandler config) {
        List<String> list;
        Intrinsics.checkNotNullParameter(currenttip, "currenttip");
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        if (itemStack != null) {
            String[] stringArray = new String[]{SpecialChars.WHITE + itemStack.func_82833_r()};
            list = CollectionsKt.mutableListOf(stringArray);
        } else {
            list = currenttip;
        }
        return list;
    }
}

