/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.integration.waila;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mods.eln.Eln;
import mods.eln.integration.waila.GhostNodeWailaData;
import mods.eln.integration.waila.SixNodeCoordonate;
import mods.eln.integration.waila.SixNodeWailaData;
import mods.eln.misc.Coordinate;
import mods.eln.packets.GhostNodeWailaRequestPacket;
import mods.eln.packets.SixNodeWailaRequestPacket;
import mods.eln.packets.TransparentNodeRequestPacket;

public class WailaCache {
    public static LoadingCache<Coordinate, Map<String, String>> nodes = CacheBuilder.newBuilder().maximumSize(20L).refreshAfterWrite(2L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Coordinate, Map<String, String>>(){

        public Map<String, String> load(Coordinate key) throws Exception {
            Eln.elnNetwork.sendToServer((IMessage)new TransparentNodeRequestPacket(key));
            return null;
        }

        public ListenableFuture<Map<String, String>> reload(Coordinate key, Map<String, String> oldValue) throws Exception {
            this.load(key);
            return Futures.immediateFuture(oldValue);
        }
    });
    public static LoadingCache<SixNodeCoordonate, SixNodeWailaData> sixNodes = CacheBuilder.newBuilder().maximumSize(20L).refreshAfterWrite(2L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<SixNodeCoordonate, SixNodeWailaData>(){

        public SixNodeWailaData load(SixNodeCoordonate key) throws Exception {
            Eln.elnNetwork.sendToServer((IMessage)new SixNodeWailaRequestPacket(key.getCoord(), key.getSide()));
            return null;
        }

        public ListenableFuture<SixNodeWailaData> reload(SixNodeCoordonate key, SixNodeWailaData oldValue) throws Exception {
            this.load(key);
            return Futures.immediateFuture((Object)oldValue);
        }
    });
    public static LoadingCache<Coordinate, GhostNodeWailaData> ghostNodes = CacheBuilder.newBuilder().maximumSize(20L).refreshAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Coordinate, GhostNodeWailaData>(){

        public GhostNodeWailaData load(Coordinate key) throws Exception {
            Eln.elnNetwork.sendToServer((IMessage)new GhostNodeWailaRequestPacket(key));
            return null;
        }

        public ListenableFuture<GhostNodeWailaData> reload(Coordinate key, GhostNodeWailaData oldValue) throws Exception {
            this.load(key);
            return Futures.immediateFuture((Object)oldValue);
        }
    });
}

