/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.text.StringsKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.wiki.Data;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u001c\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J9\u0010\u001c\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f0\u001e\"\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0012J\u001a\u0010#\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0012H\u0016J&\u0010&\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0016\u0010)\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lmods/eln/item/BrushDescriptor;", "Lmods/eln/generic/GenericItemUsingDamageDescriptor;", "name", "", "(Ljava/lang/String;)V", "ricon", "Lnet/minecraft/util/ResourceLocation;", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "getColor", "", "stack", "getDefaultNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "getLife", "getName", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setLife", "life", "setParent", "Lnet/minecraft/item/Item;", "damage", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "use", "Companion", "Eln"})
public final class BrushDescriptor
extends GenericItemUsingDamageDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation ricon;
    @NotNull
    private static final ResourceLocation dryOverlay = new ResourceLocation("eln", "textures/items/brushdryoverlay.png");

    public BrushDescriptor(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name, null, 2, null);
        StringBuilder stringBuilder = new StringBuilder().append("textures/items/");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.ricon = new ResourceLocation("eln", stringBuilder.append(StringsKt.replace$default(string, " ", "", false, 4, null)).append(".png").toString());
    }

    @Override
    @NotNull
    public String getName(@NotNull ItemStack stack) {
        String string;
        Intrinsics.checkNotNullParameter(stack, "stack");
        boolean creative = Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d;
        int color = this.getColor(stack);
        int life = this.getLife(stack);
        if (!creative && color == 15 && life == 0) {
            string = "Empty " + super.getName(stack);
        } else {
            string = super.getName(stack);
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void setParent(@Nullable Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    public final int getColor(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return stack.func_77960_j() & 0xF;
    }

    private final int getLife(ItemStack stack) {
        return stack == null || stack.func_77978_p() == null ? 32 : stack.func_77978_p().func_74762_e("life");
    }

    public final void setLife(@NotNull ItemStack stack, int life) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        stack.func_77978_p().func_74768_a("life", life);
    }

    @Override
    @Nullable
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("life", 32);
        return nbt;
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (itemStack != null) {
            boolean creative = Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d;
            Object[] objectArray = new Object[]{creative ? "infinite" : Integer.valueOf(itemStack.func_77978_p().func_74762_e("life"))};
            String string = I18N.tr("Can paint %1$ blocks", objectArray);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Can paint %1$ blocks\u2026pound.getInteger(\"life\"))");
            list.add(string);
        }
    }

    public final boolean use(@NotNull ItemStack stack, @NotNull EntityPlayer entityPlayer) {
        boolean bl;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        boolean creative = entityPlayer.field_71075_bZ.field_75098_d;
        int life = stack.func_77978_p().func_74762_e("life");
        if (creative || life != 0) {
            if (!creative) {
                stack.func_77978_p().func_74768_a("life", --life);
            }
            bl = true;
        } else {
            Utils.addChatMessage(entityPlayer, I18N.tr("Brush is dry", new Object[0]));
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean handleRenderType(@Nullable ItemStack item, @Nullable IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelper(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, @Nullable IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            boolean creative = Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d;
            UtilsClient.drawIcon(type, this.ricon);
            if (!creative) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f - 0.75f * (float)this.getLife(item) / 32.0f));
                UtilsClient.drawIcon(type, dryOverlay);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else {
            super.renderItem(type, item, Arrays.copyOf(data, data.length));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmods/eln/item/BrushDescriptor$Companion;", "", "()V", "dryOverlay", "Lnet/minecraft/util/ResourceLocation;", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

