/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item;

import mods.eln.Eln;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.ItemMovingHelper;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeBlock;
import mods.eln.node.NodeManager;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ConfigCopyToolDescriptor
extends GenericItemUsingDamageDescriptor {
    public ConfigCopyToolDescriptor(String name) {
        super(name);
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float vx, float vy, float vz) {
        if (world.field_72995_K) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof NodeBlock) {
            NodeBase node = NodeManager.instance.getNodeFromCoordonate(new Coordinate(x, y, z, world));
            if (node != null) {
                node.onBlockActivated(player, Direction.fromIntMinecraftSide(side), vx, vy, vz);
            }
            return true;
        }
        return false;
    }

    public static boolean readCableType(NBTTagCompound compound, IInventory inv, int slot, EntityPlayer invoker) {
        return ConfigCopyToolDescriptor.readCableType(compound, "cable", inv, slot, invoker);
    }

    public static boolean readCableType(NBTTagCompound compound, String name, IInventory inv, int slot, EntityPlayer invoker) {
        if (compound.func_74764_b(name + "Type")) {
            GenericItemBlockUsingDamageDescriptor thisCableDesc;
            int amt = 1;
            if (compound.func_74764_b(name + "Amt")) {
                amt = compound.func_74762_e(name + "Amt");
            }
            int type = compound.func_74762_e(name + "Type");
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot != null && (thisCableDesc = GenericItemBlockUsingDamageDescriptor.getDescriptor(stackInSlot, ElectricalCableDescriptor.class)) != null) {
                new ItemMovingHelper(){

                    @Override
                    public boolean acceptsStack(ItemStack stack) {
                        return thisCableDesc.checkSameItemStack(stack);
                    }

                    @Override
                    public ItemStack newStackOfSize(int items) {
                        return thisCableDesc.newItemStack(items);
                    }
                }.move(invoker.field_71071_by, inv, slot, 0);
            }
            if (type != -1) {
                Object cableDesc = Eln.sixNodeItem.getDescriptor(type);
                new ItemMovingHelper((GenericItemBlockUsingDamageDescriptor)cableDesc){
                    final /* synthetic */ GenericItemBlockUsingDamageDescriptor val$cableDesc;
                    {
                        this.val$cableDesc = genericItemBlockUsingDamageDescriptor;
                    }

                    @Override
                    public boolean acceptsStack(ItemStack stack) {
                        return this.val$cableDesc.checkSameItemStack(stack);
                    }

                    @Override
                    public ItemStack newStackOfSize(int items) {
                        return this.val$cableDesc.newItemStack(items);
                    }
                }.move(invoker.field_71071_by, inv, slot, amt);
            }
            return true;
        }
        return false;
    }

    public static void writeCableType(NBTTagCompound compound, ItemStack stack) {
        ConfigCopyToolDescriptor.writeCableType(compound, "cable", stack);
    }

    public static void writeCableType(NBTTagCompound compound, String name, ItemStack stack) {
        GenericItemBlockUsingDamageDescriptor desc;
        if (stack != null) {
            Eln.logger.info("CCT Copy: " + name + "Amt: " + stack.field_77994_a);
            compound.func_74768_a(name + "Amt", stack.field_77994_a);
        }
        if ((desc = GenericItemBlockUsingDamageDescriptor.getDescriptor(stack)) != null) {
            Eln.logger.info("CCT Copy: " + name + "Type: " + desc.parentItemDamage);
            compound.func_74768_a(name + "Type", desc.parentItemDamage);
        } else {
            Eln.logger.info("CCT Copy: " + name + "Type: -1");
            compound.func_74768_a(name + "Type", -1);
        }
    }

    public static boolean readGenDescriptor(NBTTagCompound compound, String name, IInventory inv, int slot, EntityPlayer invoker) {
        if (compound.func_74764_b(name)) {
            int amt = 1;
            if (compound.func_74764_b(name + "Amt")) {
                amt = compound.func_74762_e(name + "Amt");
            }
            String type = compound.func_74779_i(name);
            final GenericItemUsingDamageDescriptor desc = GenericItemUsingDamageDescriptor.getDescriptor(inv.func_70301_a(slot));
            if (desc != null) {
                new ItemMovingHelper(){

                    @Override
                    public boolean acceptsStack(ItemStack stack) {
                        return desc.checkSameItemStack(stack);
                    }

                    @Override
                    public ItemStack newStackOfSize(int items) {
                        return desc.newItemStack(items);
                    }
                }.move(invoker.field_71071_by, inv, slot, 0);
            }
            if (!type.equals(GenericItemUsingDamageDescriptor.INVALID_NAME)) {
                final GenericItemUsingDamageDescriptor newDesc = GenericItemUsingDamageDescriptor.getByName(type);
                new ItemMovingHelper(){

                    @Override
                    public boolean acceptsStack(ItemStack stack) {
                        return newDesc.checkSameItemStack(stack);
                    }

                    @Override
                    public ItemStack newStackOfSize(int items) {
                        return newDesc.newItemStack(items);
                    }
                }.move(invoker.field_71071_by, inv, slot, amt);
            }
            return true;
        }
        return false;
    }

    public static void writeGenDescriptor(NBTTagCompound compound, String name, ItemStack stack) {
        GenericItemUsingDamageDescriptor desc;
        if (stack != null) {
            Eln.logger.info("CCT Copy: " + name + "Amt: " + stack.field_77994_a);
            compound.func_74768_a(name + "Amt", stack.field_77994_a);
        }
        if ((desc = GenericItemUsingDamageDescriptor.getDescriptor(stack)) != null) {
            Eln.logger.info("CCT Copy: " + name + " " + desc.name);
            compound.func_74778_a(name, desc.name);
        } else {
            Eln.logger.info("CCT Copy: " + name + " Invalid Descriptor");
            compound.func_74778_a(name, GenericItemUsingDamageDescriptor.INVALID_NAME);
        }
    }

    public static boolean readVanillaStack(NBTTagCompound compound, String name, IInventory inv, int slot, EntityPlayer invoker) {
        if (compound.func_74764_b(name)) {
            int amt = 1;
            if (compound.func_74764_b(name + "Amt")) {
                amt = compound.func_74762_e(name + "Amt");
            }
            final int itemId = compound.func_74762_e(name);
            final ItemStack current = inv.func_70301_a(slot);
            if (current != null) {
                new ItemMovingHelper(){

                    @Override
                    public boolean acceptsStack(ItemStack stack) {
                        return current.func_77973_b() == stack.func_77973_b();
                    }

                    @Override
                    public ItemStack newStackOfSize(int items) {
                        return new ItemStack(current.func_77973_b(), items);
                    }
                }.move(invoker.field_71071_by, inv, slot, 0);
            }
            if (itemId >= 0) {
                new ItemMovingHelper(){

                    @Override
                    public boolean acceptsStack(ItemStack stack) {
                        return Item.func_150891_b((Item)stack.func_77973_b()) == itemId;
                    }

                    @Override
                    public ItemStack newStackOfSize(int items) {
                        return new ItemStack(Item.func_150899_d((int)itemId), items);
                    }
                }.move(invoker.field_71071_by, inv, slot, amt);
            }
            return true;
        }
        return false;
    }

    public static void writeVanillaStack(NBTTagCompound compound, String name, ItemStack stack) {
        if (stack == null) {
            Eln.logger.info("CCT Copy: " + name + "Amt: 0");
            compound.func_74768_a(name, -1);
            compound.func_74768_a(name + "Amt", 0);
        } else {
            Eln.logger.info("CCT Copy: " + name + " " + Item.func_150891_b((Item)stack.func_77973_b()));
            Eln.logger.info("CCT Copy: " + name + "Amt: " + stack.field_77994_a);
            compound.func_74768_a(name, Item.func_150891_b((Item)stack.func_77973_b()));
            compound.func_74768_a(name + "Amt", stack.field_77994_a);
        }
    }
}

