/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item;

import mods.eln.misc.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;

public abstract class ItemMovingHelper {
    public abstract boolean acceptsStack(ItemStack var1);

    public abstract ItemStack newStackOfSize(int var1);

    public void move(InventoryPlayer src, IInventory dst, int dstSlot, int desired) {
        if (Utils.isCreative((EntityPlayerMP)src.field_70458_d)) {
            if (desired == 0) {
                dst.func_70299_a(dstSlot, null);
            } else {
                dst.func_70299_a(dstSlot, this.newStackOfSize(desired));
            }
            return;
        }
        int now = 0;
        ItemStack stack = dst.func_70301_a(dstSlot);
        if (stack != null) {
            now = stack.field_77994_a;
        }
        Utils.println(String.format("IMH.m: now %d, desired %d", now, desired));
        if (now < desired) {
            int diff = desired - now;
            for (int idx = 0; idx < src.func_70302_i_(); ++idx) {
                ItemStack invStack = src.func_70301_a(idx);
                if (invStack == null || !this.acceptsStack(invStack)) continue;
                int move = Math.min(invStack.field_77994_a, diff);
                diff -= move;
                invStack.field_77994_a -= move;
                if (invStack.field_77994_a == 0) {
                    invStack = null;
                }
                src.func_70299_a(idx, invStack);
                ItemMovingHelper.syncItemInSlot(src, idx);
                if (diff <= 0) break;
            }
            int moved = desired - now - diff;
            Utils.println(String.format("IMH.m: moved %d into node", moved));
            if (moved > 0) {
                dst.func_70299_a(dstSlot, this.newStackOfSize(now + moved));
            }
        } else {
            int diff = now - desired;
            Utils.println(String.format("IMH.m: moving %d items", diff));
            if (diff > 0) {
                if (src.func_70441_a(this.newStackOfSize(diff))) {
                    if (desired == 0) {
                        dst.func_70299_a(dstSlot, null);
                    } else {
                        dst.func_70299_a(dstSlot, this.newStackOfSize(desired));
                    }
                    Utils.println("IMH.m: move succeeded");
                } else {
                    Utils.println("IMH.m: move failed!");
                }
            }
            ItemMovingHelper.syncEntireInventory(src.field_70458_d);
        }
    }

    public static void syncItemInSlot(InventoryPlayer inv, int slot) {
        EntityPlayerMP playerMP = (EntityPlayerMP)inv.field_70458_d;
        Container container = playerMP.field_71070_bA;
        playerMP.field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(container.field_75152_c, container.func_75147_a((IInventory)inv, (int)slot).field_75222_d, inv.func_70301_a(slot)));
        inv.func_70296_d();
    }

    public static void syncEntireInventory(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        for (int idx = 0; idx < inv.func_70302_i_(); ++idx) {
            Container container = playerMP.field_71070_bA;
            playerMP.field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(container.field_75152_c, container.func_75147_a((IInventory)inv, (int)idx).field_75222_d, inv.func_70301_a(idx)));
        }
        inv.func_70296_d();
    }
}

