/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalinterface;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mods.eln.Eln;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class ItemEnergyInventoryProcess
implements IProcess {
    private static final double energyUpdatePeriod = 0.5;
    private double energyUpdateTimout = 0.5;
    LinkedList<Exclusion> exclude = new LinkedList();

    public void addExclusion(Object o, double timeout) {
        Exclusion exclusion = null;
        for (Exclusion e : this.exclude) {
            if (e.o != o) continue;
            exclusion = e;
        }
        if (exclusion == null) {
            exclusion = new Exclusion(timeout, o);
            this.exclude.add(exclusion);
        }
        exclusion.timeout = timeout;
    }

    boolean isExcluded(Object o) {
        for (Exclusion e : this.exclude) {
            if (e.o != o) continue;
            Utils.println("Exclude");
            return true;
        }
        return false;
    }

    @Override
    public void process(double time) {
        Iterator ie = this.exclude.iterator();
        while (ie.hasNext()) {
            Exclusion e = (Exclusion)ie.next();
            e.timeout -= 0.05;
            if (!(e.timeout < 0.0)) continue;
            ie.remove();
        }
        this.energyUpdateTimout -= time;
        if (this.energyUpdateTimout > 0.0) {
            return;
        }
        this.energyUpdateTimout += 0.5;
        time = 0.5;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ArrayList<Element> list = new ArrayList<Element>();
        block1: for (Object obj : server.func_71203_ab().field_72404_b) {
            Element src;
            Object o;
            EntityPlayerMP player = (EntityPlayerMP)obj;
            list.clear();
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                o = Utils.getItemObject(stack);
                if (!(o instanceof IItemEnergyBattery) || this.isExcluded(o)) continue;
                list.add(new Element(stack, (IItemEnergyBattery)o));
            }
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                o = Utils.getItemObject(stack);
                if (!(o instanceof IItemEnergyBattery) || this.isExcluded(o)) continue;
                list.add(new Element(stack, (IItemEnergyBattery)o));
            }
            for (Element e : list) {
                e.i.electricalItemUpdate(e.stack, 0.5);
            }
            if (Eln.saveConfig.infinitePortableBattery) {
                for (Element e : list) {
                    double chargePower = e.i.getChargePower(e.stack);
                    double energy = Math.min(e.i.getEnergyMax(e.stack), e.i.getEnergy(e.stack) + e.i.getChargePower(e.stack) * time);
                    e.i.setEnergy(e.stack, energy);
                }
                continue;
            }
            boolean rememberDst = false;
            double rememberDstEToDstMax = 0.0;
            while ((src = this.getMax(list)) != null) {
                double eFromSrc;
                double eStart = eFromSrc = Math.min(src.i.getEnergy(src.stack), src.i.getDischagePower(src.stack) * time);
                boolean done = false;
                while (eFromSrc != 0.0) {
                    double eToDstMax;
                    Element dst = this.getMin(list);
                    if (dst.p == src.p) {
                        done = true;
                        break;
                    }
                    if (rememberDst) {
                        eToDstMax = rememberDstEToDstMax;
                        rememberDst = false;
                    } else {
                        eToDstMax = Math.min(dst.i.getEnergyMax(dst.stack) - dst.i.getEnergy(dst.stack), dst.i.getChargePower(dst.stack) * time);
                    }
                    double eToDst = Math.min(eFromSrc, eToDstMax);
                    eFromSrc -= eToDst;
                    dst.i.setEnergy(dst.stack, dst.i.getEnergy(dst.stack) + eToDst);
                    if ((eToDstMax -= eToDst) == 0.0) {
                        list.remove(dst);
                        continue;
                    }
                    rememberDst = true;
                    rememberDstEToDstMax = eToDstMax;
                }
                src.i.setEnergy(src.stack, src.i.getEnergy(src.stack) - (eStart - eFromSrc));
                if (done) continue block1;
                list.remove(src);
                if (list.size() >= 2) continue;
                continue block1;
            }
        }
    }

    Element getElement(List<Element> list, int priority) {
        for (Element e : list) {
            if (priority != e.p) continue;
            return e;
        }
        return null;
    }

    Element getMin(List<Element> list) {
        Element find = null;
        for (Element e : list) {
            if (find != null && find.p <= e.p) continue;
            find = e;
        }
        return find;
    }

    Element getMax(List<Element> list) {
        Element find = null;
        for (Element e : list) {
            if (find != null && find.p >= e.p) continue;
            find = e;
        }
        return find;
    }

    static class Exclusion {
        public double timeout;
        public Object o;

        public Exclusion(double timeout, Object o) {
            this.timeout = timeout;
            this.o = o;
            Utils.println("new");
        }
    }

    class Element {
        public ItemStack stack;
        public IItemEnergyBattery i;
        public int p;

        public Element(ItemStack stack, IItemEnergyBattery i) {
            this.stack = stack;
            this.i = i;
            this.p = i.getPriority(stack);
        }
    }
}

