/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.Arrays;
import java.util.List;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ2\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u001c\u0010'\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u00172\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J9\u0010+\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010(\u001a\u0004\u0018\u00010\u00172\u0016\u0010,\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010.0-\"\u0004\u0018\u00010.H\u0016\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0006H\u0016J\u001a\u00102\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\nH\u0016J&\u00105\u001a\u00020\u001d2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010(\u001a\u0004\u0018\u00010\u00172\b\u00106\u001a\u0004\u0018\u000107H\u0016R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lmods/eln/item/electricalitem/BatteryItem;", "Lmods/eln/generic/GenericItemUsingDamageDescriptor;", "Lmods/eln/item/electricalinterface/IItemEnergyBattery;", "name", "", "energyStorage", "", "chargePower", "dischargePower", "priority", "", "(Ljava/lang/String;DDDI)V", "getChargePower", "()D", "setChargePower", "(D)V", "getDischargePower", "setDischargePower", "getEnergyStorage", "setEnergyStorage", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "electricalItemUpdate", "stack", "time", "getDefaultNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "getDischagePower", "getEnergy", "getEnergyMax", "getPriority", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setEnergy", "value", "setParent", "Lnet/minecraft/item/Item;", "damage", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "Eln"})
public final class BatteryItem
extends GenericItemUsingDamageDescriptor
implements IItemEnergyBattery {
    private double energyStorage;
    private double chargePower;
    private double dischargePower;
    private final int priority;

    public BatteryItem(@NotNull String name, double energyStorage, double chargePower, double dischargePower, int priority) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name, null, 2, null);
        this.energyStorage = energyStorage;
        this.chargePower = chargePower;
        this.dischargePower = dischargePower;
        this.priority = priority;
    }

    public final double getEnergyStorage() {
        return this.energyStorage;
    }

    public final void setEnergyStorage(double d) {
        this.energyStorage = d;
    }

    public final double getChargePower() {
        return this.chargePower;
    }

    public final void setChargePower(double d) {
        this.chargePower = d;
    }

    public final double getDischargePower() {
        return this.dischargePower;
    }

    public final void setDischargePower(double d) {
        this.dischargePower = d;
    }

    @Override
    public void setParent(@Nullable Item item, int damage) {
        super.setParent(item, damage);
        Data.addPortable(this.newItemStack());
    }

    @Override
    @Nullable
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", 0.0);
        return nbt;
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        Object[] objectArray = new Object[]{Utils.plotValue(this.chargePower)};
        String string = I18N.tr("Charge power: %1$W", objectArray);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Charge power: %1\\$W\"\u2026s.plotValue(chargePower))");
        list.add(string);
        objectArray = new Object[]{Utils.plotValue(this.dischargePower)};
        String string2 = I18N.tr("Discharge power: %1$W", objectArray);
        Intrinsics.checkNotNullExpressionValue(string2, "tr(\"Discharge power: %1\\\u2026lotValue(dischargePower))");
        list.add(string2);
        if (itemStack != null) {
            objectArray = new Object[]{Utils.plotValue(this.getEnergy(itemStack)), (int)(this.getEnergy(itemStack) / this.energyStorage * (double)100)};
            String string3 = I18N.tr("Stored energy: %1$J (%2$%)", objectArray);
            Intrinsics.checkNotNullExpressionValue(string3, "tr(\"Stored energy: %1\\$J\u2026gyStorage * 100).toInt())");
            list.add(string3);
        }
    }

    @Override
    public double getEnergy(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getNbt(stack).func_74769_h("energy");
    }

    @Override
    public void setEnergy(@NotNull ItemStack stack, double value) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        this.getNbt(stack).func_74780_a("energy", Math.max(0.0, value));
    }

    @Override
    public double getEnergyMax(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.energyStorage;
    }

    @Override
    public double getChargePower(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.chargePower;
    }

    @Override
    public double getDischagePower(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.dischargePower;
    }

    @Override
    public int getPriority(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.priority;
    }

    @Override
    public boolean shouldUseRenderHelper(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, @Nullable IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(@Nullable ItemStack item, @Nullable IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(data, "data");
        super.renderItem(type, item, Arrays.copyOf(data, data.length));
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            ItemStack itemStack = item;
            Intrinsics.checkNotNull(itemStack);
            UtilsClient.INSTANCE.drawEnergyBare(type, (float)(this.getEnergy(itemStack) / this.getEnergyMax(item)));
        }
    }

    @Override
    public void electricalItemUpdate(@NotNull ItemStack stack, double time) {
        Intrinsics.checkNotNullParameter(stack, "stack");
    }
}

