/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalitem.ElectricalTool;
import mods.eln.item.electricalitem.TreeCapitation;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.wiki.Data;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ2\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u001a\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J@\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0011H\u0016J\"\u0010'\u001a\u00020\r2\b\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0015H\u0002J\u001a\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001fH\u0016\u00a8\u0006-"}, d2={"Lmods/eln/item/electricalitem/ElectricalAxe;", "Lmods/eln/item/electricalitem/ElectricalTool;", "name", "", "strengthOn", "", "strengthOff", "energyStorage", "", "energyPerBlock", "chargePower", "(Ljava/lang/String;FFDDD)V", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "getCapitation", "stack", "getStrVsBlock", "block", "Lnet/minecraft/block/Block;", "onBlockDestroyed", "w", "Lnet/minecraft/world/World;", "x", "", "y", "z", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "onItemRightClick", "s", "p", "setCapitation", "capitation", "setParent", "item", "Lnet/minecraft/item/Item;", "damage", "Eln"})
public final class ElectricalAxe
extends ElectricalTool {
    public ElectricalAxe(@NotNull String name, float strengthOn, float strengthOff, double energyStorage, double energyPerBlock, double chargePower) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name, strengthOn, strengthOff, energyStorage, energyPerBlock, chargePower);
    }

    @Override
    public void setParent(@Nullable Item item, int damage) {
        super.setParent(item, damage);
        Data.addPortable(this.newItemStack());
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        String string = I18N.tr("Cuts down trees. Right-click to make it act like a regular axe.", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Cuts down trees. Rig\u2026act like a regular axe.\")");
        list.add(string);
    }

    @Override
    public float getStrVsBlock(@NotNull ItemStack stack, @Nullable Block block) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return block != null && (block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151582_l) ? this.getStrength(stack) : super.getStrVsBlock(stack, block);
    }

    @Override
    @NotNull
    public ItemStack onItemRightClick(@NotNull ItemStack s, @NotNull World w, @NotNull EntityPlayer p) {
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter(p, "p");
        if (!w.field_72995_K) {
            this.setCapitation(p, s, !this.getCapitation(s));
        }
        return s;
    }

    private final boolean getCapitation(ItemStack stack) {
        NBTTagCompound nbt = this.getNbt(stack);
        if (!nbt.func_74764_b("capitation")) {
            nbt.func_74757_a("capitation", true);
        }
        return nbt.func_74767_n("capitation");
    }

    private final void setCapitation(EntityPlayer p, ItemStack stack, boolean capitation) {
        this.getNbt(stack).func_74757_a("capitation", capitation);
        if (p != null) {
            Utils.addChatMessage(p, "Set treecapitation to " + capitation);
        }
    }

    @Override
    public boolean onBlockDestroyed(@NotNull ItemStack stack, @NotNull World w, @NotNull Block block, int x, int y, int z, @NotNull EntityLivingBase entity) {
        boolean bl;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (entity instanceof EntityPlayer && this.getCapitation(stack)) {
            TreeCapitation treeCapitation = TreeCapitation.INSTANCE;
            ChunkCoordinates chunkCoordinates = new ChunkCoordinates(x, y, z);
            treeCapitation.addBlockSwapper(w, (EntityPlayer)entity, this, chunkCoordinates, true, stack);
            bl = true;
        } else {
            bl = super.onBlockDestroyed(stack, w, block, x, y, z, entity);
        }
        return bl;
    }
}

