/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.List;
import java.util.Locale;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.item.electricalitem.LampItem;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.text.StringsKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ2\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u0001052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0004072\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u0002012\u0006\u0010;\u001a\u0002032\u0006\u0010<\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010;\u001a\u000203H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010?\u001a\u00020\t2\u0006\u0010;\u001a\u000203H\u0016J\u0010\u0010@\u001a\u00020\t2\u0006\u0010;\u001a\u000203H\u0016J\u0010\u0010A\u001a\u00020\t2\u0006\u0010;\u001a\u000203H\u0016J\u0010\u0010B\u001a\u00020\u00062\u0006\u0010;\u001a\u000203H\u0016J\u000e\u0010C\u001a\u00020\u00062\u0006\u0010;\u001a\u000203J\u0010\u0010D\u001a\u00020\u00062\u0006\u0010;\u001a\u000203H\u0016J\u0010\u0010E\u001a\u00020\u00062\u0006\u0010;\u001a\u000203H\u0016J\u0010\u0010F\u001a\u00020\u00062\u0006\u0010;\u001a\u000203H\u0016J\u001c\u0010G\u001a\u0002092\b\u0010H\u001a\u0004\u0018\u0001032\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J \u0010K\u001a\u0002032\u0006\u0010L\u001a\u0002032\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u000205H\u0016J9\u0010P\u001a\u0002012\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010H\u001a\u0004\u0018\u0001032\u0016\u0010Q\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010S0R\"\u0004\u0018\u00010SH\u0016\u00a2\u0006\u0002\u0010TJ\u0018\u0010U\u001a\u0002012\u0006\u0010;\u001a\u0002032\u0006\u0010V\u001a\u00020\tH\u0016J\u0018\u0010W\u001a\u0002012\b\u0010;\u001a\u0004\u0018\u0001032\u0006\u0010V\u001a\u00020\u0006J\u001a\u0010X\u001a\u0002012\b\u0010H\u001a\u0004\u0018\u00010Y2\u0006\u0010Z\u001a\u00020\u0006H\u0016J&\u0010[\u001a\u0002092\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010H\u001a\u0004\u0018\u0001032\b\u0010\\\u001a\u0004\u0018\u00010]H\u0016R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u001a\u0010\r\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010!\"\u0004\b%\u0010#R\u001a\u0010&\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0013\"\u0004\b(\u0010\u0015R\u001a\u0010)\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0013\"\u0004\b+\u0010\u0015R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010!\"\u0004\b-\u0010#R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010!\"\u0004\b/\u0010#\u00a8\u0006^"}, d2={"Lmods/eln/item/electricalitem/ElectricalLampItem;", "Lmods/eln/item/electricalitem/LampItem;", "Lmods/eln/item/electricalinterface/IItemEnergyBattery;", "name", "", "lightMin", "", "rangeMin", "dischargeMin", "", "lightMax", "rangeMax", "dischargeMax", "energyStorage", "chargePower", "(Ljava/lang/String;IIDIIDDD)V", "boosted", "Lnet/minecraft/util/ResourceLocation;", "getBoosted", "()Lnet/minecraft/util/ResourceLocation;", "setBoosted", "(Lnet/minecraft/util/ResourceLocation;)V", "getChargePower", "()D", "setChargePower", "(D)V", "getDischargeMax", "setDischargeMax", "getDischargeMin", "setDischargeMin", "getEnergyStorage", "setEnergyStorage", "getLightMax", "()I", "setLightMax", "(I)V", "getLightMin", "setLightMin", "off", "getOff", "setOff", "on", "getOn", "setOn", "getRangeMax", "setRangeMax", "getRangeMin", "setRangeMin", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "electricalItemUpdate", "stack", "time", "getDefaultNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "getDischagePower", "getEnergy", "getEnergyMax", "getLight", "getLightLevel", "getLightState", "getPriority", "getRange", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "onItemRightClick", "s", "w", "Lnet/minecraft/world/World;", "p", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setEnergy", "value", "setLightState", "setParent", "Lnet/minecraft/item/Item;", "damage", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "Eln"})
public final class ElectricalLampItem
extends LampItem
implements IItemEnergyBattery {
    private int lightMin;
    private int rangeMin;
    private int lightMax;
    private int rangeMax;
    private double energyStorage;
    private double dischargeMin;
    private double dischargeMax;
    private double chargePower;
    @NotNull
    private ResourceLocation on;
    @NotNull
    private ResourceLocation off;
    @NotNull
    private ResourceLocation boosted;

    public ElectricalLampItem(@NotNull String name, int lightMin, int rangeMin, double dischargeMin, int lightMax, int rangeMax, double dischargeMax, double energyStorage, double chargePower) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name);
        this.lightMin = lightMin;
        this.rangeMin = rangeMin;
        this.lightMax = lightMax;
        this.rangeMax = rangeMax + 1;
        this.chargePower = chargePower;
        this.dischargeMin = dischargeMin;
        this.dischargeMax = dischargeMax;
        this.energyStorage = energyStorage;
        this.setDefaultIcon(name + "off");
        StringBuilder stringBuilder = new StringBuilder().append("textures/items/");
        String string = StringsKt.replace$default(name, " ", "", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.boosted = new ResourceLocation("eln", stringBuilder.append(string).append("boosted.png").toString());
        StringBuilder stringBuilder2 = new StringBuilder().append("textures/items/");
        String string2 = StringsKt.replace$default(name, " ", "", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.on = new ResourceLocation("eln", stringBuilder2.append(string2).append("on.png").toString());
        StringBuilder stringBuilder3 = new StringBuilder().append("textures/items/");
        String string3 = StringsKt.replace$default(name, " ", "", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.off = new ResourceLocation("eln", stringBuilder3.append(string3).append("off.png").toString());
    }

    public final int getLightMin() {
        return this.lightMin;
    }

    public final void setLightMin(int n) {
        this.lightMin = n;
    }

    public final int getRangeMin() {
        return this.rangeMin;
    }

    public final void setRangeMin(int n) {
        this.rangeMin = n;
    }

    public final int getLightMax() {
        return this.lightMax;
    }

    public final void setLightMax(int n) {
        this.lightMax = n;
    }

    public final int getRangeMax() {
        return this.rangeMax;
    }

    public final void setRangeMax(int n) {
        this.rangeMax = n;
    }

    public final double getEnergyStorage() {
        return this.energyStorage;
    }

    public final void setEnergyStorage(double d) {
        this.energyStorage = d;
    }

    public final double getDischargeMin() {
        return this.dischargeMin;
    }

    public final void setDischargeMin(double d) {
        this.dischargeMin = d;
    }

    public final double getDischargeMax() {
        return this.dischargeMax;
    }

    public final void setDischargeMax(double d) {
        this.dischargeMax = d;
    }

    public final double getChargePower() {
        return this.chargePower;
    }

    public final void setChargePower(double d) {
        this.chargePower = d;
    }

    @NotNull
    public final ResourceLocation getOn() {
        return this.on;
    }

    public final void setOn(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter(resourceLocation, "<set-?>");
        this.on = resourceLocation;
    }

    @NotNull
    public final ResourceLocation getOff() {
        return this.off;
    }

    public final void setOff(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter(resourceLocation, "<set-?>");
        this.off = resourceLocation;
    }

    @NotNull
    public final ResourceLocation getBoosted() {
        return this.boosted;
    }

    public final void setBoosted(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter(resourceLocation, "<set-?>");
        this.boosted = resourceLocation;
    }

    @Override
    public void setParent(@Nullable Item item, int damage) {
        super.setParent(item, damage);
        Data.addPortable(this.newItemStack());
        Data.addLight(this.newItemStack());
    }

    @Override
    public int getRange(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getLightState(stack) == 1 ? this.rangeMin : this.rangeMax;
    }

    @Override
    public int getLight(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        double energy = this.getEnergy(stack);
        int state = this.getLightState(stack);
        double power2 = 0.0;
        switch (state) {
            case 1: {
                power2 = this.dischargeMin;
                break;
            }
            case 2: {
                power2 = this.dischargeMax;
            }
        }
        return energy > power2 ? this.getLightLevel(stack) : 0;
    }

    @Override
    @Nullable
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", 0.0);
        nbt.func_74757_a("powerOn", false);
        nbt.func_74768_a("rand", (int)(Math.random() * (double)0xFFFFFFF));
        return nbt;
    }

    @Override
    public int getLightState(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getNbt(stack).func_74762_e("LightState");
    }

    public final void setLightState(@Nullable ItemStack stack, int value) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull(itemStack);
        this.getNbt(itemStack).func_74768_a("LightState", value);
    }

    public final int getLightLevel(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getLightState(stack) == 1 ? this.lightMin : this.lightMax;
    }

    @Override
    @NotNull
    public ItemStack onItemRightClick(@NotNull ItemStack s, @NotNull World w, @NotNull EntityPlayer p) {
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter(p, "p");
        if (!w.field_72995_K && this.getEnergy(s) > 0.0) {
            int lightState = this.getLightState(s) + 1;
            if (lightState > 2) {
                lightState = 0;
            }
            switch (lightState) {
                case 0: {
                    Utils.addChatMessage((EntityPlayer)((EntityPlayerMP)p), "Flashlight OFF");
                    break;
                }
                case 1: {
                    Utils.addChatMessage((EntityPlayer)((EntityPlayerMP)p), "Flashlight ON");
                    break;
                }
                case 2: {
                    Utils.addChatMessage((EntityPlayer)((EntityPlayerMP)p), "Flashlight BOOSTED");
                }
            }
            this.setLightState(s, lightState);
        }
        return s;
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        Object[] objectArray = new Object[]{Utils.plotValue(this.dischargeMin)};
        String string = I18N.tr("Discharge power: %1$W", objectArray);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Discharge power: %1\\\u2026.plotValue(dischargeMin))");
        list.add(string);
        if (itemStack != null) {
            objectArray = new Object[]{Utils.plotValue(this.getEnergy(itemStack)), (int)(this.getEnergy(itemStack) / this.energyStorage * (double)100)};
            String string2 = I18N.tr("Stored Energy: %1$J (%2$%)", objectArray);
            Intrinsics.checkNotNullExpressionValue(string2, "tr(\"Stored Energy: %1\\$J\u2026gyStorage * 100).toInt())");
            list.add(string2);
            list.add(I18N.tr("State:", new Object[0]) + ' ' + (this.getLightState(itemStack) != 0 ? I18N.tr("On", new Object[0]) : I18N.tr("Off", new Object[0])));
        }
    }

    @Override
    public double getEnergy(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getNbt(stack).func_74769_h("energy");
    }

    @Override
    public void setEnergy(@NotNull ItemStack stack, double value) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        this.getNbt(stack).func_74780_a("energy", value);
    }

    @Override
    public double getEnergyMax(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.energyStorage;
    }

    @Override
    public double getChargePower(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.chargePower;
    }

    @Override
    public double getDischagePower(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return 0.0;
    }

    @Override
    public int getPriority(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return 0;
    }

    @Override
    public boolean shouldUseRenderHelper(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, @Nullable IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(@Nullable ItemStack item, @Nullable IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(data, "data");
        ResourceLocation drawlightstate = this.off;
        ItemStack itemStack = item;
        Intrinsics.checkNotNull(itemStack);
        switch (this.getLightState(itemStack)) {
            case 0: {
                drawlightstate = this.off;
                break;
            }
            case 1: {
                drawlightstate = this.on;
                break;
            }
            case 2: {
                drawlightstate = this.boosted;
            }
        }
        IItemRenderer.ItemRenderType itemRenderType = type;
        Intrinsics.checkNotNull(itemRenderType);
        UtilsClient.drawIcon(itemRenderType, drawlightstate);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            UtilsClient.INSTANCE.drawEnergyBare(type, (float)(this.getEnergy(item) / this.getEnergyMax(item)));
        }
    }

    @Override
    public void electricalItemUpdate(@NotNull ItemStack stack, double time) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        double energy = this.getEnergy(stack);
        int state = this.getLightState(stack);
        double power2 = 0.0;
        switch (state) {
            case 1: {
                power2 = this.dischargeMin * time;
                break;
            }
            case 2: {
                power2 = this.dischargeMax * time;
            }
        }
        if (energy > power2) {
            this.setEnergy(stack, energy - power2);
        } else {
            this.setEnergy(stack, 0.0);
            this.setLightState(stack, 0);
        }
    }
}

