/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalitem.ElectricalTool;
import mods.eln.item.electricalitem.TreeCapitation;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.wiki.Data;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ2\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u001a\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J@\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0011H\u0016J\"\u0010'\u001a\u00020\r2\b\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0015H\u0002J\u001a\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020 H\u0016\u00a8\u0006-"}, d2={"Lmods/eln/item/electricalitem/ElectricalPickaxe;", "Lmods/eln/item/electricalitem/ElectricalTool;", "name", "", "strengthOn", "", "strengthOff", "energyStorage", "", "energyPerBlock", "chargePower", "(Ljava/lang/String;FFDDD)V", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "getConservative", "s", "getStrVsBlock", "stack", "block", "Lnet/minecraft/block/Block;", "onBlockDestroyed", "w", "Lnet/minecraft/world/World;", "x", "", "y", "z", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "onItemRightClick", "p", "setConservative", "state", "setParent", "item", "Lnet/minecraft/item/Item;", "damage", "Eln"})
@SourceDebugExtension(value={"SMAP\nElectricalPickaxe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElectricalPickaxe.kt\nmods/eln/item/electricalitem/ElectricalPickaxe\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,76:1\n12744#2,2:77\n*S KotlinDebug\n*F\n+ 1 ElectricalPickaxe.kt\nmods/eln/item/electricalitem/ElectricalPickaxe\n*L\n33#1:77,2\n*E\n"})
public final class ElectricalPickaxe
extends ElectricalTool {
    public ElectricalPickaxe(@NotNull String name, float strengthOn, float strengthOff, double energyStorage, double energyPerBlock, double chargePower) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name, strengthOn, strengthOff, energyStorage, energyPerBlock, chargePower);
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        String string = I18N.tr("Opens holes. Right-click to open smaller holes.", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Opens holes. Right-c\u2026 to open smaller holes.\")");
        list.add(string);
    }

    @Override
    public void setParent(@Nullable Item item, int damage) {
        super.setParent(item, damage);
        Data.addPortable(this.newItemStack());
    }

    @Override
    public float getStrVsBlock(@NotNull ItemStack stack, @Nullable Block block) {
        boolean bl;
        float value;
        block2: {
            Intrinsics.checkNotNullParameter(stack, "stack");
            value = block != null && (block.func_149688_o() == Material.field_151573_f || block.func_149688_o() == Material.field_151592_s || block.func_149688_o() == Material.field_151574_g || block.func_149688_o() == Material.field_151576_e) ? this.getStrength(stack) : super.getStrVsBlock(stack, block);
            Block[] $this$any$iv = ElectricalTool.Companion.getBlocksEffectiveAgainst();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Block element$iv;
                Block it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it, block)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            value = this.getStrength(stack);
        }
        return value;
    }

    @Override
    @NotNull
    public ItemStack onItemRightClick(@NotNull ItemStack s, @NotNull World w, @NotNull EntityPlayer p) {
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter(p, "p");
        if (!w.field_72995_K) {
            this.setConservative(p, s, !this.getConservative(s));
        }
        return s;
    }

    private final boolean getConservative(ItemStack s) {
        return this.getNbt(s).func_74767_n("conservative");
    }

    private final void setConservative(EntityPlayer p, ItemStack s, boolean state) {
        this.getNbt(s).func_74757_a("conservative", state);
        if (p != null) {
            Utils.addChatMessage(p, "Set land conservation to " + state);
        }
    }

    @Override
    public boolean onBlockDestroyed(@NotNull ItemStack stack, @NotNull World w, @NotNull Block block, int x, int y, int z, @NotNull EntityLivingBase entity) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(entity, "entity");
        boolean ok = super.onBlockDestroyed(stack, w, block, x, y, z, entity);
        if (!(entity instanceof EntityPlayer)) {
            return ok;
        }
        if (!ok) {
            return ok;
        }
        if (!this.getConservative(stack)) {
            for (int a = -1; a < 2; ++a) {
                for (int b = -1; b < 1; ++b) {
                    for (int c = -1; c < 2; ++c) {
                        if (a == 0 && b == 0 && c == 0) continue;
                        int i = x + a;
                        int j = y + b;
                        int k = z + c;
                        TreeCapitation.INSTANCE.removeBlockWithDrops((EntityPlayer)entity, this, stack, w, i, j, k);
                    }
                }
            }
        }
        return ok;
    }
}

