/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.text.StringsKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 [2\u00020\u00012\u00020\u0002:\u0001[B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ2\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0004012\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020+2\u0006\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u00105\u001a\u00020-H\u0016J\n\u00107\u001a\u0004\u0018\u000108H\u0016J\u0010\u00109\u001a\u00020\t2\u0006\u00105\u001a\u00020-H\u0016J\u0010\u0010:\u001a\u00020\t2\u0006\u00105\u001a\u00020-H\u0016J\u0010\u0010;\u001a\u00020\t2\u0006\u00105\u001a\u00020-H\u0016J\u0010\u0010<\u001a\u0002032\b\u00105\u001a\u0004\u0018\u00010-J\u0010\u0010=\u001a\u00020\u00162\u0006\u00105\u001a\u00020-H\u0016J\u000e\u0010>\u001a\u00020\u00062\u0006\u00105\u001a\u00020-J\u001c\u0010?\u001a\u0002032\b\u0010@\u001a\u0004\u0018\u00010-2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J@\u0010C\u001a\u0002032\u0006\u00105\u001a\u00020-2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u00162\u0006\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u00020LH\u0016J\u001c\u0010M\u001a\u0002032\b\u0010N\u001a\u0004\u0018\u00010L2\b\u00105\u001a\u0004\u0018\u00010-H\u0016J9\u0010O\u001a\u00020+2\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010@\u001a\u0004\u0018\u00010-2\u0016\u0010P\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010R0Q\"\u0004\u0018\u00010RH\u0016\u00a2\u0006\u0002\u0010SJ\u0018\u0010T\u001a\u00020+2\u0006\u00105\u001a\u00020-2\u0006\u0010U\u001a\u00020\tH\u0016J\u0018\u0010V\u001a\u00020+2\b\u00105\u001a\u0004\u0018\u00010-2\u0006\u0010U\u001a\u000203J&\u0010W\u001a\u0002032\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010@\u001a\u0004\u0018\u00010-2\b\u0010X\u001a\u0004\u0018\u00010YH\u0016J\u0016\u0010Z\u001a\u00020+2\u0006\u00105\u001a\u00020-2\u0006\u0010F\u001a\u00020GR\u001a\u0010\u000b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0018\"\u0004\b#\u0010\u001aR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'\u00a8\u0006\\"}, d2={"Lmods/eln/item/electricalitem/ElectricalTool;", "Lmods/eln/generic/GenericItemUsingDamageDescriptor;", "Lmods/eln/item/electricalinterface/IItemEnergyBattery;", "name", "", "strengthOn", "", "strengthOff", "energyStorage", "", "energyPerBlock", "chargePower", "(Ljava/lang/String;FFDDD)V", "getChargePower", "()D", "setChargePower", "(D)V", "getEnergyPerBlock", "setEnergyPerBlock", "getEnergyStorage", "setEnergyStorage", "light", "", "getLight", "()I", "setLight", "(I)V", "rIcon", "Lnet/minecraft/util/ResourceLocation;", "getRIcon", "()Lnet/minecraft/util/ResourceLocation;", "setRIcon", "(Lnet/minecraft/util/ResourceLocation;)V", "range", "getRange", "setRange", "getStrengthOff", "()F", "setStrengthOff", "(F)V", "getStrengthOn", "setStrengthOn", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "electricalItemUpdate", "stack", "time", "getDefaultNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "getDischagePower", "getEnergy", "getEnergyMax", "getPowerOn", "getPriority", "getStrength", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "onBlockDestroyed", "w", "Lnet/minecraft/world/World;", "block", "Lnet/minecraft/block/Block;", "x", "y", "z", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "onEntitySwing", "entityLiving", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setEnergy", "value", "setPowerOn", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "subtractEnergyForBlockBreak", "Companion", "Eln"})
public class ElectricalTool
extends GenericItemUsingDamageDescriptor
implements IItemEnergyBattery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float strengthOn;
    private float strengthOff;
    private double energyStorage;
    private double energyPerBlock;
    private double chargePower;
    private int light;
    private int range;
    @NotNull
    private ResourceLocation rIcon;
    @NotNull
    private static final Block[] blocksEffectiveAgainst;

    public ElectricalTool(@NotNull String name, float strengthOn, float strengthOff, double energyStorage, double energyPerBlock, double chargePower) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name, null, 2, null);
        this.strengthOn = strengthOn;
        this.strengthOff = strengthOff;
        this.energyStorage = energyStorage;
        this.energyPerBlock = energyPerBlock;
        this.chargePower = chargePower;
        StringBuilder stringBuilder = new StringBuilder().append("textures/items/");
        String string = StringsKt.replace$default(name, " ", "", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.rIcon = new ResourceLocation("eln", stringBuilder.append(string).append(".png").toString());
    }

    public final float getStrengthOn() {
        return this.strengthOn;
    }

    public final void setStrengthOn(float f) {
        this.strengthOn = f;
    }

    public final float getStrengthOff() {
        return this.strengthOff;
    }

    public final void setStrengthOff(float f) {
        this.strengthOff = f;
    }

    public final double getEnergyStorage() {
        return this.energyStorage;
    }

    public final void setEnergyStorage(double d) {
        this.energyStorage = d;
    }

    public final double getEnergyPerBlock() {
        return this.energyPerBlock;
    }

    public final void setEnergyPerBlock(double d) {
        this.energyPerBlock = d;
    }

    public final double getChargePower() {
        return this.chargePower;
    }

    public final void setChargePower(double d) {
        this.chargePower = d;
    }

    public final int getLight() {
        return this.light;
    }

    public final void setLight(int n) {
        this.light = n;
    }

    public final int getRange() {
        return this.range;
    }

    public final void setRange(int n) {
        this.range = n;
    }

    @NotNull
    public final ResourceLocation getRIcon() {
        return this.rIcon;
    }

    public final void setRIcon(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter(resourceLocation, "<set-?>");
        this.rIcon = resourceLocation;
    }

    @Override
    public boolean onEntitySwing(@Nullable EntityLivingBase entityLiving, @Nullable ItemStack stack) {
        EntityLivingBase entityLivingBase = entityLiving;
        Intrinsics.checkNotNull(entityLivingBase);
        if (entityLivingBase.field_70170_p.field_72995_K) {
            return false;
        }
        Eln.itemEnergyInventoryProcess.addExclusion(this, 2.0);
        return super.onEntitySwing(entityLiving, stack);
    }

    @Override
    public boolean onBlockDestroyed(@NotNull ItemStack stack, @NotNull World w, @NotNull Block block, int x, int y, int z, @NotNull EntityLivingBase entity) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(entity, "entity");
        this.subtractEnergyForBlockBreak(stack, block);
        Utils.println("destroy");
        return true;
    }

    public final void subtractEnergyForBlockBreak(@NotNull ItemStack stack, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(block, "block");
        if (this.getStrVsBlock(stack, block) == this.strengthOn) {
            double e = this.getEnergy(stack) - this.energyPerBlock;
            if (e < 0.0) {
                e = 0.0;
            }
            this.setEnergy(stack, e);
        }
    }

    public final float getStrength(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getEnergy(stack) >= this.energyPerBlock ? this.strengthOn : this.strengthOff;
    }

    @Override
    @Nullable
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", 0.0);
        nbt.func_74757_a("powerOn", false);
        nbt.func_74768_a("rand", (int)(Math.random() * (double)0xFFFFFFF));
        return nbt;
    }

    public final boolean getPowerOn(@Nullable ItemStack stack) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull(itemStack);
        return this.getNbt(itemStack).func_74767_n("powerOn");
    }

    public final void setPowerOn(@Nullable ItemStack stack, boolean value) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull(itemStack);
        this.getNbt(itemStack).func_74757_a("powerOn", value);
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (itemStack != null) {
            Object[] objectArray = new Object[]{Utils.plotValue(this.getEnergy(itemStack)), (int)(this.getEnergy(itemStack) / this.energyStorage * (double)100)};
            String string = I18N.tr("Stored energy: %1$J (%2$%)", objectArray);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Stored energy: %1\\$J\u2026gyStorage * 100).toInt())");
            list.add(string);
        }
    }

    @Override
    public double getEnergy(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getNbt(stack).func_74769_h("energy");
    }

    @Override
    public void setEnergy(@NotNull ItemStack stack, double value) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        this.getNbt(stack).func_74780_a("energy", value);
    }

    @Override
    public double getEnergyMax(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.energyStorage;
    }

    @Override
    public double getChargePower(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.chargePower;
    }

    @Override
    public double getDischagePower(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return 0.0;
    }

    @Override
    public int getPriority(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return 0;
    }

    @Override
    public boolean shouldUseRenderHelper(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, @Nullable IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(@Nullable ItemStack item, @Nullable IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(data, "data");
        super.renderItem(type, item, Arrays.copyOf(data, data.length));
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            ItemStack itemStack = item;
            Intrinsics.checkNotNull(itemStack);
            UtilsClient.INSTANCE.drawEnergyBare(type, (float)(this.getEnergy(itemStack) / this.getEnergyMax(item)));
        }
    }

    @Override
    public void electricalItemUpdate(@NotNull ItemStack stack, double time) {
        Intrinsics.checkNotNullParameter(stack, "stack");
    }

    static {
        Block[] blockArray = new Block[]{(Block)Blocks.field_150349_c, Blocks.field_150346_d, (Block)Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150433_aE, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, (Block)Blocks.field_150391_bh};
        blocksEffectiveAgainst = blockArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lmods/eln/item/electricalitem/ElectricalTool$Companion;", "", "()V", "blocksEffectiveAgainst", "", "Lnet/minecraft/block/Block;", "mods.eln.shadow.kotlin.jvm.PlatformType", "getBlocksEffectiveAgainst", "()[Lnet/minecraft/block/Block;", "[Lnet/minecraft/block/Block;", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Block[] getBlocksEffectiveAgainst() {
            return blocksEffectiveAgainst;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

