/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.item.electricalitem.OreColorMapping;
import mods.eln.item.electricalitem.State;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.shadow.kotlin.ExperimentalUnsignedTypes;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.UByte;
import mods.eln.shadow.kotlin.UInt;
import mods.eln.shadow.kotlin.UShort;
import mods.eln.shadow.kotlin.UShortArray;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.collections.IntIterator;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.JvmOverloads;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.ranges.IntRange;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.wiki.Data;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0005\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0086\u0001BO\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J2\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\b\u0010N\u001a\u0004\u0018\u00010O2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00040Q2\u0006\u0010R\u001a\u00020SH\u0016J\u0018\u0010T\u001a\u00020K2\u0006\u0010U\u001a\u00020M2\u0006\u0010V\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010U\u001a\u00020MH\u0016J\u0010\u0010W\u001a\u00020X2\b\u0010U\u001a\u0004\u0018\u00010MJ\u0010\u0010Y\u001a\u00020 2\b\u0010U\u001a\u0004\u0018\u00010MJ\n\u0010Z\u001a\u0004\u0018\u00010[H\u0016J\u0010\u0010\\\u001a\u00020\b2\u0006\u0010U\u001a\u00020MH\u0016J\u0010\u0010]\u001a\u00020\b2\u0006\u0010U\u001a\u00020MH\u0016J\u0010\u0010^\u001a\u00020\b2\u0006\u0010U\u001a\u00020MH\u0016J\u0010\u0010_\u001a\u00020\u000f2\u0006\u0010U\u001a\u00020MH\u0016J\u0010\u0010`\u001a\u00020a2\u0006\u0010U\u001a\u00020MH\u0002J\u001c\u0010b\u001a\u00020S2\b\u0010c\u001a\u0004\u0018\u00010M2\b\u0010d\u001a\u0004\u0018\u00010eH\u0016J4\u0010f\u001a\u00020S2\b\u0010g\u001a\u0004\u0018\u00010M2\u0006\u0010h\u001a\u00020\u000f2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010j\u001a\u00020\u000f2\b\u0010k\u001a\u0004\u0018\u00010OH\u0016J\u001a\u0010l\u001a\u00020S2\u0006\u0010c\u001a\u00020M2\b\u0010k\u001a\u0004\u0018\u00010OH\u0016J \u0010m\u001a\u00020M2\u0006\u0010n\u001a\u00020M2\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020OH\u0016J0\u0010r\u001a\u00020K2\u0006\u0010U\u001a\u00020M2\u0006\u0010s\u001a\u00020p2\u0006\u0010t\u001a\u00020u2\u0006\u0010R\u001a\u00020\u000f2\u0006\u0010v\u001a\u00020SH\u0016J9\u0010w\u001a\u00020K2\b\u0010d\u001a\u0004\u0018\u00010e2\b\u0010c\u001a\u0004\u0018\u00010M2\u0016\u0010x\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010y02\"\u0004\u0018\u00010yH\u0016\u00a2\u0006\u0002\u0010zJ\u0018\u0010{\u001a\u00020K2\b\u0010U\u001a\u0004\u0018\u00010M2\u0006\u0010|\u001a\u00020XJ\u0018\u0010}\u001a\u00020K2\b\u0010U\u001a\u0004\u0018\u00010M2\u0006\u0010|\u001a\u00020 J\u0018\u0010~\u001a\u00020K2\u0006\u0010U\u001a\u00020M2\u0006\u0010|\u001a\u00020\bH\u0016J\u001c\u0010\u007f\u001a\u00020K2\t\u0010c\u001a\u0005\u0018\u00010\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u00020\u000fH\u0016J\u0019\u0010\u0082\u0001\u001a\u00020K2\u0006\u0010U\u001a\u00020M2\u0006\u0010|\u001a\u00020aH\u0002J)\u0010\u0083\u0001\u001a\u00020S2\b\u0010d\u001a\u0004\u0018\u00010e2\b\u0010c\u001a\u0004\u0018\u00010M2\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u0001H\u0016R\u001e\u0010\u0012\u001a\u00060\u0013R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00060\u0013R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010\u001eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001e\u0010%\u001a\u00060\u0013R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0015\"\u0004\b'\u0010\u0017R\u001e\u0010(\u001a\u00060\u0013R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0015\"\u0004\b*\u0010\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010,\"\u0004\b0\u0010.R&\u00101\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u000602X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00107\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001e\u00108\u001a\u00060\u0013R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0015\"\u0004\b:\u0010\u0017R&\u0010;\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u000602X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00107\u001a\u0004\b<\u00104\"\u0004\b=\u00106R\u001e\u0010>\u001a\u00060\u0013R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0015\"\u0004\b@\u0010\u0017R\u001e\u0010A\u001a\u00060\u0013R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0015\"\u0004\bC\u0010\u0017R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010E\"\u0004\bI\u0010G\u00a8\u0006\u0087\u0001"}, d2={"Lmods/eln/item/electricalitem/PortableOreScannerItem;", "Lmods/eln/generic/GenericItemUsingDamageDescriptor;", "Lmods/eln/item/electricalinterface/IItemEnergyBattery;", "name", "", "obj", "Lmods/eln/misc/Obj3D;", "energyStorage", "", "chargePower", "dischargePower", "viewRange", "", "viewYAlpha", "resWidth", "", "resHeight", "(Ljava/lang/String;Lmods/eln/misc/Obj3D;DDDFFII)V", "base", "Lmods/eln/misc/Obj3D$Obj3DPart;", "getBase", "()Lmods/eln/misc/Obj3D$Obj3DPart;", "setBase", "(Lmods/eln/misc/Obj3D$Obj3DPart;)V", "buttons", "getButtons", "setButtons", "getChargePower", "()D", "setChargePower", "(D)V", "damagePerBreakLevel", "", "getDischargePower", "setDischargePower", "getEnergyStorage", "setEnergyStorage", "led", "getLed", "setLed", "ledHalo", "getLedHalo", "setLedHalo", "getResHeight", "()I", "setResHeight", "(I)V", "getResWidth", "setResWidth", "screenDamage", "", "getScreenDamage", "()[Lmods/eln/misc/Obj3D$Obj3DPart;", "setScreenDamage", "([Lmods/eln/misc/Obj3D$Obj3DPart;)V", "[Lmods/eln/misc/Obj3D$Obj3DPart;", "screenLuma", "getScreenLuma", "setScreenLuma", "textBat", "getTextBat", "setTextBat", "textInit", "getTextInit", "setTextInit", "textRun", "getTextRun", "setTextRun", "getViewRange", "()F", "setViewRange", "(F)V", "getViewYAlpha", "setViewYAlpha", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "electricalItemUpdate", "stack", "time", "getCounter", "", "getDamage", "getDefaultNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "getDischagePower", "getEnergy", "getEnergyMax", "getPriority", "getState", "Lmods/eln/item/electricalitem/State;", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "onBlockStartBreak", "itemstack", "x", "y", "z", "player", "onDroppedByPlayer", "onItemRightClick", "s", "w", "Lnet/minecraft/world/World;", "p", "onUpdate", "world", "entity", "Lnet/minecraft/entity/Entity;", "par5", "renderItem", "data", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setCounter", "value", "setDamage", "setEnergy", "setParent", "Lnet/minecraft/item/Item;", "damage", "setState", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "RenderStorage", "Eln"})
@ExperimentalUnsignedTypes
@SourceDebugExtension(value={"SMAP\nPortableOreScannerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortableOreScannerItem.kt\nmods/eln/item/electricalitem/PortableOreScannerItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,544:1\n1549#2:545\n1620#2,3:546\n1549#2:551\n1620#2,3:552\n37#3,2:549\n37#3,2:555\n*S KotlinDebug\n*F\n+ 1 PortableOreScannerItem.kt\nmods/eln/item/electricalitem/PortableOreScannerItem\n*L\n34#1:545\n34#1:546,3\n38#1:551\n38#1:552,3\n34#1:549,2\n38#1:555,2\n*E\n"})
public final class PortableOreScannerItem
extends GenericItemUsingDamageDescriptor
implements IItemEnergyBattery {
    @NotNull
    private final Obj3D obj;
    private double energyStorage;
    private double chargePower;
    private double dischargePower;
    private float viewRange;
    private float viewYAlpha;
    private int resWidth;
    private int resHeight;
    @NotNull
    private Obj3D.Obj3DPart base;
    @NotNull
    private Obj3D.Obj3DPart led;
    @NotNull
    private Obj3D.Obj3DPart ledHalo;
    @NotNull
    private Obj3D.Obj3DPart[] textBat;
    @NotNull
    private Obj3D.Obj3DPart textRun;
    @NotNull
    private Obj3D.Obj3DPart textInit;
    @NotNull
    private Obj3D.Obj3DPart buttons;
    @NotNull
    private Obj3D.Obj3DPart[] screenDamage;
    @NotNull
    private Obj3D.Obj3DPart screenLuma;
    private final byte damagePerBreakLevel;

    /*
     * WARNING - void declaration
     */
    public PortableOreScannerItem(@Nullable String name, @NotNull Obj3D obj, double energyStorage, double chargePower, double dischargePower, float viewRange, float viewYAlpha, int resWidth, int resHeight) {
        Iterable $this$toTypedArray$iv;
        int it;
        Collection collection;
        int item$iv$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter(obj, "obj");
        String string = name;
        Intrinsics.checkNotNull(string);
        super(string, null, 2, null);
        this.obj = obj;
        this.energyStorage = energyStorage;
        this.chargePower = chargePower;
        this.dischargePower = dischargePower;
        this.viewRange = viewRange;
        this.viewYAlpha = viewYAlpha;
        this.resWidth = resWidth;
        this.resHeight = resHeight;
        Obj3D.Obj3DPart obj3DPart = this.obj.getPart("Base");
        Intrinsics.checkNotNullExpressionValue(obj3DPart, "obj.getPart(\"Base\")");
        this.base = obj3DPart;
        Obj3D.Obj3DPart obj3DPart2 = this.obj.getPart("Led");
        Intrinsics.checkNotNullExpressionValue(obj3DPart2, "obj.getPart(\"Led\")");
        this.led = obj3DPart2;
        Obj3D.Obj3DPart obj3DPart3 = this.obj.getPart("LedHalo");
        Intrinsics.checkNotNullExpressionValue(obj3DPart3, "obj.getPart(\"LedHalo\")");
        this.ledHalo = obj3DPart3;
        Iterable iterable = new IntRange(0, 3);
        PortableOreScannerItem portableOreScannerItem = this;
        boolean $i$f$map = false;
        void var15_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.obj.getPart("TextBat" + it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        portableOreScannerItem.textBat = thisCollection$iv.toArray(new Obj3D.Obj3DPart[0]);
        Obj3D.Obj3DPart obj3DPart4 = this.obj.getPart("TextRun");
        Intrinsics.checkNotNullExpressionValue(obj3DPart4, "obj.getPart(\"TextRun\")");
        this.textRun = obj3DPart4;
        Obj3D.Obj3DPart obj3DPart5 = this.obj.getPart("TextInit");
        Intrinsics.checkNotNullExpressionValue(obj3DPart5, "obj.getPart(\"TextInit\")");
        this.textInit = obj3DPart5;
        Obj3D.Obj3DPart obj3DPart6 = this.obj.getPart("Buttons");
        Intrinsics.checkNotNullExpressionValue(obj3DPart6, "obj.getPart(\"Buttons\")");
        this.buttons = obj3DPart6;
        $this$toTypedArray$iv = new IntRange(0, 2);
        portableOreScannerItem = this;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.obj.getPart("ScreenDamageL" + (it + 1)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        portableOreScannerItem.screenDamage = thisCollection$iv.toArray(new Obj3D.Obj3DPart[0]);
        Obj3D.Obj3DPart obj3DPart7 = this.obj.getPart("ScreenLuma");
        Intrinsics.checkNotNullExpressionValue(obj3DPart7, "obj.getPart(\"ScreenLuma\")");
        this.screenLuma = obj3DPart7;
        this.damagePerBreakLevel = (byte)3;
    }

    public final double getEnergyStorage() {
        return this.energyStorage;
    }

    public final void setEnergyStorage(double d) {
        this.energyStorage = d;
    }

    public final double getChargePower() {
        return this.chargePower;
    }

    public final void setChargePower(double d) {
        this.chargePower = d;
    }

    public final double getDischargePower() {
        return this.dischargePower;
    }

    public final void setDischargePower(double d) {
        this.dischargePower = d;
    }

    public final float getViewRange() {
        return this.viewRange;
    }

    public final void setViewRange(float f) {
        this.viewRange = f;
    }

    public final float getViewYAlpha() {
        return this.viewYAlpha;
    }

    public final void setViewYAlpha(float f) {
        this.viewYAlpha = f;
    }

    public final int getResWidth() {
        return this.resWidth;
    }

    public final void setResWidth(int n) {
        this.resWidth = n;
    }

    public final int getResHeight() {
        return this.resHeight;
    }

    public final void setResHeight(int n) {
        this.resHeight = n;
    }

    @NotNull
    public final Obj3D.Obj3DPart getBase() {
        return this.base;
    }

    public final void setBase(@NotNull Obj3D.Obj3DPart obj3DPart) {
        Intrinsics.checkNotNullParameter(obj3DPart, "<set-?>");
        this.base = obj3DPart;
    }

    @NotNull
    public final Obj3D.Obj3DPart getLed() {
        return this.led;
    }

    public final void setLed(@NotNull Obj3D.Obj3DPart obj3DPart) {
        Intrinsics.checkNotNullParameter(obj3DPart, "<set-?>");
        this.led = obj3DPart;
    }

    @NotNull
    public final Obj3D.Obj3DPart getLedHalo() {
        return this.ledHalo;
    }

    public final void setLedHalo(@NotNull Obj3D.Obj3DPart obj3DPart) {
        Intrinsics.checkNotNullParameter(obj3DPart, "<set-?>");
        this.ledHalo = obj3DPart;
    }

    @NotNull
    public final Obj3D.Obj3DPart[] getTextBat() {
        return this.textBat;
    }

    public final void setTextBat(@NotNull Obj3D.Obj3DPart[] obj3DPartArray) {
        Intrinsics.checkNotNullParameter(obj3DPartArray, "<set-?>");
        this.textBat = obj3DPartArray;
    }

    @NotNull
    public final Obj3D.Obj3DPart getTextRun() {
        return this.textRun;
    }

    public final void setTextRun(@NotNull Obj3D.Obj3DPart obj3DPart) {
        Intrinsics.checkNotNullParameter(obj3DPart, "<set-?>");
        this.textRun = obj3DPart;
    }

    @NotNull
    public final Obj3D.Obj3DPart getTextInit() {
        return this.textInit;
    }

    public final void setTextInit(@NotNull Obj3D.Obj3DPart obj3DPart) {
        Intrinsics.checkNotNullParameter(obj3DPart, "<set-?>");
        this.textInit = obj3DPart;
    }

    @NotNull
    public final Obj3D.Obj3DPart getButtons() {
        return this.buttons;
    }

    public final void setButtons(@NotNull Obj3D.Obj3DPart obj3DPart) {
        Intrinsics.checkNotNullParameter(obj3DPart, "<set-?>");
        this.buttons = obj3DPart;
    }

    @NotNull
    public final Obj3D.Obj3DPart[] getScreenDamage() {
        return this.screenDamage;
    }

    public final void setScreenDamage(@NotNull Obj3D.Obj3DPart[] obj3DPartArray) {
        Intrinsics.checkNotNullParameter(obj3DPartArray, "<set-?>");
        this.screenDamage = obj3DPartArray;
    }

    @NotNull
    public final Obj3D.Obj3DPart getScreenLuma() {
        return this.screenLuma;
    }

    public final void setScreenLuma(@NotNull Obj3D.Obj3DPart obj3DPart) {
        Intrinsics.checkNotNullParameter(obj3DPart, "<set-?>");
        this.screenLuma = obj3DPart;
    }

    @Override
    public void onUpdate(@NotNull ItemStack stack, @NotNull World world, @NotNull Entity entity, int par4, boolean par5) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        State state = this.getState(stack);
        short counter = this.getCounter(stack);
        if (this.getDamage(stack) / this.damagePerBreakLevel >= 4) {
            if (state != State.Idle) {
                this.setState(stack, State.Idle);
            }
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                counter = (short)(counter + -1);
                if (counter != 0) {
                    this.setCounter(stack, counter);
                    break;
                }
                this.setState(stack, State.Run);
                break;
            }
            case 2: {
                counter = (short)(counter + -1);
                if (counter != 0) {
                    this.setCounter(stack, counter);
                    break;
                }
                this.setState(stack, State.Idle);
            }
        }
    }

    @Override
    @NotNull
    public ItemStack onItemRightClick(@NotNull ItemStack s, @NotNull World w, @NotNull EntityPlayer p) {
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter(p, "p");
        if (w.field_72995_K) {
            return s;
        }
        double energy = this.getEnergy(s);
        State state = this.getState(s);
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 3: {
                if (!(energy > this.dischargePower)) break;
                this.setState(s, State.Boot);
                this.setCounter(s, (short)80);
                break;
            }
            case 4: {
                this.setState(s, State.Stop);
                this.setCounter(s, (short)20);
            }
        }
        return s;
    }

    @Override
    public void setParent(@Nullable Item item, int damage) {
        super.setParent(item, damage);
        Data.addPortable(this.newItemStack());
    }

    @Override
    @Nullable
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("e", this.energyStorage * 0.2);
        nbt.func_74774_a("s", State.Boot.getSerialized());
        nbt.func_74777_a("c", (short)80);
        nbt.func_74774_a("d", (byte)0);
        return nbt;
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        Object[] objectArray = new Object[]{Utils.plotValue(this.dischargePower)};
        String string = I18N.tr("Discharge power: %1$W", objectArray);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Discharge power: %1\\\u2026lotValue(dischargePower))");
        list.add(string);
        if (itemStack != null) {
            objectArray = new Object[]{Utils.plotValue(this.getEnergy(itemStack)), (int)(this.getEnergy(itemStack) / this.energyStorage * (double)100)};
            String string2 = I18N.tr("Stored energy: %1$J (%2$%)", objectArray);
            Intrinsics.checkNotNullExpressionValue(string2, "tr(\"Stored energy: %1\\$J\u2026gyStorage * 100).toInt())");
            list.add(string2);
        }
    }

    @Override
    public double getEnergy(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getNbt(stack).func_74769_h("e");
    }

    @Override
    public void setEnergy(@NotNull ItemStack stack, double value) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        this.getNbt(stack).func_74780_a("e", value);
    }

    private final State getState(ItemStack stack) {
        State state = State.Companion.from(this.getNbt(stack).func_74771_c("s"));
        if (state == null) {
            state = State.Idle;
        }
        return state;
    }

    private final void setState(ItemStack stack, State value) {
        this.getNbt(stack).func_74774_a("s", value.getSerialized());
    }

    public final short getCounter(@Nullable ItemStack stack) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull(itemStack);
        return this.getNbt(itemStack).func_74765_d("c");
    }

    public final void setCounter(@Nullable ItemStack stack, short value) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull(itemStack);
        this.getNbt(itemStack).func_74777_a("c", value);
    }

    public final byte getDamage(@Nullable ItemStack stack) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull(itemStack);
        return this.getNbt(itemStack).func_74771_c("d");
    }

    public final void setDamage(@Nullable ItemStack stack, byte value) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull(itemStack);
        this.getNbt(itemStack).func_74774_a("d", value);
    }

    @Override
    public boolean onDroppedByPlayer(@NotNull ItemStack item, @Nullable EntityPlayer player) {
        Intrinsics.checkNotNullParameter(item, "item");
        this.setState(item, State.Idle);
        return super.onDroppedByPlayer(item, player);
    }

    @Override
    public double getEnergyMax(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.energyStorage;
    }

    @Override
    public double getChargePower(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.chargePower;
    }

    @Override
    public double getDischagePower(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.dischargePower;
    }

    @Override
    public int getPriority(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return 0;
    }

    @Override
    public boolean handleRenderType(@Nullable ItemStack item, @Nullable IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, @Nullable IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean onBlockStartBreak(@Nullable ItemStack itemstack, int x, int y, int z, @Nullable EntityPlayer player) {
        EntityPlayer entityPlayer = player;
        Intrinsics.checkNotNull(entityPlayer);
        if (!entityPlayer.field_70170_p.field_72995_K) {
            this.setDamage(itemstack, (byte)(this.getDamage(itemstack) + 1));
        }
        return super.onBlockStartBreak(itemstack, x, y, z, player);
    }

    @Override
    public void renderItem(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, Arrays.copyOf(data, data.length));
            ItemStack itemStack = item;
            Intrinsics.checkNotNull(itemStack);
            UtilsClient.INSTANCE.drawEnergyBare(type, (float)(this.getEnergy(itemStack) / this.getEnergyMax(item)));
            return;
        }
        ItemStack itemStack = item;
        Intrinsics.checkNotNull(itemStack);
        double energy = this.getEnergy(itemStack);
        State state = this.getState(item);
        GL11.glPushMatrix();
        Entity e = null;
        IItemRenderer.ItemRenderType itemRenderType = type;
        switch (itemRenderType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[itemRenderType.ordinal()]) {
            case 1: {
                e = null;
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 2: {
                Object object = data[1];
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.minecraft.entity.Entity");
                e = (Entity)object;
                GL11.glRotatef((float)130.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)140.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)1.6f, (float)1.6f, (float)1.6f);
                GL11.glTranslatef((float)-0.2f, (float)0.7f, (float)-0.0f);
                break;
            }
            case 3: {
                Object object = data[1];
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.minecraft.entity.Entity");
                e = (Entity)object;
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)-0.2f);
                break;
            }
            case 4: {
                GL11.glPopMatrix();
                return;
            }
            case 5: {
                e = null;
                break;
            }
            default: {
                e = null;
            }
        }
        boolean drawScreen = e != null && UtilsClient.INSTANCE.clientDistanceTo(e) < 10.0;
        boolean drawRay = drawScreen && state == State.Run;
        this.base.draw();
        if (drawRay) {
            GL11.glPushMatrix();
            Object oRender = Eln.clientLiveDataManager.getData(item, 1);
            if (oRender == null) {
                oRender = Eln.clientLiveDataManager.newData(item, new RenderStorage(this.viewRange, this.viewYAlpha, this.resWidth, this.resHeight), 1);
            }
            Object object = oRender;
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type mods.eln.item.electricalitem.PortableOreScannerItem.RenderStorage");
            RenderStorage render = (RenderStorage)object;
            Entity entity = e;
            Intrinsics.checkNotNull(entity);
            World world = entity.field_70170_p;
            Intrinsics.checkNotNullExpressionValue(world, "e!!.worldObj");
            render.generate(world, e.field_70165_t, Utils.INSTANCE.getHeadPosY(e), e.field_70161_v, e.field_70177_z * (float)Math.PI / 180.0f, e.field_70125_A * (float)Math.PI / 180.0f);
            float scale = 1.0f / (float)this.resWidth * 0.5f;
            GL11.glTranslatef((float)0.90668f, (float)0.163f, (float)-0.25078f);
            GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)scale, (float)(-scale), (float)1.0f);
            RenderStorage.draw$default(render, 0.0f, 0.0f, 0.0f, 7, null);
            GL11.glPopMatrix();
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            int count = 0;
            for (int y = 0; y < this.resHeight; y += 6) {
                for (int x = 0; x < this.resHeight; x += 6) {
                    r += render.getScreenRed()[y][x];
                    g += render.getScreenGreen()[y][x];
                    b += render.getScreenBlue()[y][x];
                    ++count;
                }
            }
            UtilsClient.drawHalo(this.screenLuma, r /= (float)count, g /= (float)count, b /= (float)count, e, false);
        }
        if (drawScreen) {
            if (state == State.Idle) {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                this.led.draw();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.buttons.draw();
            }
            UtilsClient.disableLight();
            if (state != State.Idle) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.buttons.draw();
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 1: {
                        r = 0.9f;
                        g = 0.4f;
                        b = 0.0f;
                        break;
                    }
                    case 4: {
                        r = 0.0f;
                        g = 1.0f;
                        b = 0.0f;
                        break;
                    }
                    case 2: {
                        r = 1.0f;
                        g = 0.0f;
                        b = 0.0f;
                    }
                }
                GL11.glColor4f((float)(r * 0.6f), (float)(g * 0.6f), (float)(b * 0.6f), (float)1.0f);
                this.led.draw();
                UtilsClient.enableBlend();
                Entity entity = e;
                Intrinsics.checkNotNull(entity);
                UtilsClient.drawHaloNoLightSetup(this.ledHalo, r, g, b, entity, false);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    this.textInit.draw();
                    break;
                }
                case 4: {
                    this.textRun.draw();
                    int batLevel = Math.min(this.textBat.length - 1, (int)(energy / this.energyStorage * (double)this.textBat.length + (double)0.5f));
                    this.textBat[batLevel].draw();
                }
            }
            UtilsClient.enableBlend();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int breakLevel = this.getDamage(item) / this.damagePerBreakLevel;
            if (state == State.Idle) {
                breakLevel = Math.min(breakLevel, this.screenDamage.length - 1);
            }
            int n = breakLevel;
            for (int idx = 0; idx < n && idx != this.screenDamage.length; ++idx) {
                this.screenDamage[Math.min(this.screenDamage.length - 1, breakLevel - 1) - idx].draw();
            }
            UtilsClient.disableBlend();
            UtilsClient.enableLight();
        }
        GL11.glPopMatrix();
    }

    @Override
    public void electricalItemUpdate(@NotNull ItemStack stack, double time) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        double energy = this.getEnergy(stack);
        State state = this.getState(stack);
        if (WhenMappings.$EnumSwitchMapping$0[state.ordinal()] != 3) {
            if ((energy -= this.dischargePower * time) <= 0.0) {
                this.setState(stack, State.Idle);
                this.setEnergy(stack, 0.0);
                return;
            }
            this.setEnergy(stack, energy);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.Boot.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Stop.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Idle.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Run.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IItemRenderer.ItemRenderType.values().length];
            try {
                nArray[IItemRenderer.ItemRenderType.ENTITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IItemRenderer.ItemRenderType.EQUIPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IItemRenderer.ItemRenderType.INVENTORY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IItemRenderer.ItemRenderType.FIRST_PERSON_MAP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001CB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ&\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u00032\b\b\u0002\u00107\u001a\u00020\u00032\b\b\u0002\u00108\u001a\u00020\u0003H\u0007J6\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0003J\u0006\u0010B\u001a\u00020\u0003R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u001e\u0010\u0016\"\u0004\b\u001f\u0010\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\rR\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000b\"\u0004\b&\u0010\rR+\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00130\u0013X\u0086\u000e\u00f8\u0001\u0000\u00a2\u0006\u0010\n\u0002\u0010-\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010.\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u000f\"\u0004\b0\u0010\u0011R\u001a\u00101\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u000f\"\u0004\b3\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006D"}, d2={"Lmods/eln/item/electricalitem/PortableOreScannerItem$RenderStorage;", "", "viewRange", "", "viewYAlpha", "resWidth", "", "resHeight", "(FFII)V", "camDist", "getCamDist", "()F", "setCamDist", "(F)V", "getResHeight", "()I", "setResHeight", "(I)V", "screenBlue", "", "", "getScreenBlue", "()[[F", "setScreenBlue", "([[F)V", "[[F", "screenGreen", "getScreenGreen", "setScreenGreen", "screenRed", "getScreenRed", "setScreenRed", "getViewRange", "setViewRange", "viewXAlpha", "getViewXAlpha", "setViewXAlpha", "getViewYAlpha", "setViewYAlpha", "worldBlocks", "Lmods/eln/shadow/kotlin/UShortArray;", "getWorldBlocks", "()[[Lkotlin/UShortArray;", "setWorldBlocks", "([[Lkotlin/UShortArray;)V", "[[Lmods/eln/shadow/kotlin/UShortArray;", "worldBlocksDim", "getWorldBlocksDim", "setWorldBlocksDim", "worldBlocksDim2", "getWorldBlocksDim2", "setWorldBlocksDim2", "draw", "", "redFactor", "greenFactor", "blueFactor", "generate", "w", "Lnet/minecraft/world/World;", "posX", "", "posY", "posZ", "alphaY", "alphaX", "noiseRand", "OreScannerConfigElement", "Eln"})
    public static final class RenderStorage {
        private float viewRange;
        private float viewYAlpha;
        private float camDist;
        private float viewXAlpha;
        @JvmField
        public int resWidth;
        private int resHeight;
        @NotNull
        private float[][] screenRed;
        @NotNull
        private float[][] screenBlue;
        @NotNull
        private float[][] screenGreen;
        @NotNull
        private UShortArray[][] worldBlocks;
        private int worldBlocksDim;
        private int worldBlocksDim2;

        public RenderStorage(float viewRange, float viewYAlpha, int resWidth, int resHeight) {
            int n;
            this.viewRange = viewRange;
            this.viewYAlpha = viewYAlpha;
            this.camDist = (float)((double)(resWidth / 2) / Math.tan(this.viewYAlpha / (float)2));
            this.resWidth = resWidth;
            this.resHeight = resHeight;
            this.worldBlocksDim = (int)(this.viewRange * (float)2 + (float)3);
            this.worldBlocksDim2 = this.worldBlocksDim / 2;
            int n2 = 0;
            float[][] fArrayArray = new float[resHeight][];
            RenderStorage renderStorage = this;
            while (n2 < resHeight) {
                n = n2++;
                fArrayArray[n] = new float[resWidth];
            }
            renderStorage.screenRed = fArrayArray;
            n2 = 0;
            fArrayArray = new float[resHeight][];
            renderStorage = this;
            while (n2 < resHeight) {
                n = n2++;
                fArrayArray[n] = new float[resWidth];
            }
            renderStorage.screenBlue = fArrayArray;
            n2 = 0;
            fArrayArray = new float[resHeight][];
            renderStorage = this;
            while (n2 < resHeight) {
                n = n2++;
                fArrayArray[n] = new float[resWidth];
            }
            renderStorage.screenGreen = fArrayArray;
            int n3 = this.worldBlocksDim;
            UShortArray[][] uShortArrayArrayArray = new UShortArray[n3][];
            renderStorage = this;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = n2;
                int n5 = 0;
                int n6 = this.worldBlocksDim;
                UShortArray[] uShortArrayArray = new UShortArray[n6];
                int n7 = n4;
                UShortArray[][] uShortArrayArrayArray2 = uShortArrayArrayArray;
                while (n5 < n6) {
                    int n8 = n5++;
                    uShortArrayArray[n8] = UShortArray.box-impl(UShortArray.constructor-impl(this.worldBlocksDim));
                }
                uShortArrayArrayArray2[n7] = uShortArrayArray;
            }
            renderStorage.worldBlocks = uShortArrayArrayArray;
        }

        public final float getViewRange() {
            return this.viewRange;
        }

        public final void setViewRange(float f) {
            this.viewRange = f;
        }

        public final float getViewYAlpha() {
            return this.viewYAlpha;
        }

        public final void setViewYAlpha(float f) {
            this.viewYAlpha = f;
        }

        public final float getCamDist() {
            return this.camDist;
        }

        public final void setCamDist(float f) {
            this.camDist = f;
        }

        public final float getViewXAlpha() {
            return this.viewXAlpha;
        }

        public final void setViewXAlpha(float f) {
            this.viewXAlpha = f;
        }

        public final int getResHeight() {
            return this.resHeight;
        }

        public final void setResHeight(int n) {
            this.resHeight = n;
        }

        @NotNull
        public final float[][] getScreenRed() {
            return this.screenRed;
        }

        public final void setScreenRed(@NotNull float[][] fArray) {
            Intrinsics.checkNotNullParameter(fArray, "<set-?>");
            this.screenRed = fArray;
        }

        @NotNull
        public final float[][] getScreenBlue() {
            return this.screenBlue;
        }

        public final void setScreenBlue(@NotNull float[][] fArray) {
            Intrinsics.checkNotNullParameter(fArray, "<set-?>");
            this.screenBlue = fArray;
        }

        @NotNull
        public final float[][] getScreenGreen() {
            return this.screenGreen;
        }

        public final void setScreenGreen(@NotNull float[][] fArray) {
            Intrinsics.checkNotNullParameter(fArray, "<set-?>");
            this.screenGreen = fArray;
        }

        @NotNull
        public final UShortArray[][] getWorldBlocks() {
            return this.worldBlocks;
        }

        public final void setWorldBlocks(@NotNull UShortArray[][] uShortArrayArray) {
            Intrinsics.checkNotNullParameter(uShortArrayArray, "<set-?>");
            this.worldBlocks = uShortArrayArray;
        }

        public final int getWorldBlocksDim() {
            return this.worldBlocksDim;
        }

        public final void setWorldBlocksDim(int n) {
            this.worldBlocksDim = n;
        }

        public final int getWorldBlocksDim2() {
            return this.worldBlocksDim2;
        }

        public final void setWorldBlocksDim2(int n) {
            this.worldBlocksDim2 = n;
        }

        public final void generate(@NotNull World w, double posX, double posY, double posZ, float alphaY, float alphaX) {
            int n;
            Intrinsics.checkNotNullParameter(w, "w");
            float[] blockKeyFactor = OreColorMapping.INSTANCE.getMap();
            int posXint = (int)Math.round(posX);
            int posYint = (int)Math.round(posY);
            int posZint = (int)Math.round(posZ);
            int n2 = this.worldBlocksDim;
            for (int z = 0; z < n2; ++z) {
                n = this.worldBlocksDim;
                for (int y = 0; y < n; ++y) {
                    int n3 = this.worldBlocksDim;
                    for (int x = 0; x < n3; ++x) {
                        UShortArray.set-01HTLdE(this.worldBlocks[x][y].unbox-impl(), z, (short)-1);
                    }
                }
            }
            n2 = this.resHeight;
            for (int screenY = 0; screenY < n2; ++screenY) {
                n = this.resWidth;
                for (int screenX = 0; screenX < n; ++screenX) {
                    float dBest;
                    float x = (float)(posX - (double)posXint);
                    float y = (float)(posY - (double)posYint);
                    float z = (float)(posZ - (double)posZint);
                    float vx = 0.0f;
                    vx = -((float)(screenX - this.resWidth / 2));
                    float vy = 0.0f;
                    vy = -((float)(screenY - this.resHeight / 2));
                    float vz = 0.0f;
                    vz = this.camDist;
                    RenderStorage $this$generate_u24lambda_u240 = this;
                    boolean bl = false;
                    float sin = MathHelper.func_76126_a((float)alphaX);
                    float cos = MathHelper.func_76134_b((float)alphaX);
                    float temp = vy;
                    vy = vy * cos - vz * sin;
                    vz = vz * cos + temp * sin;
                    RenderStorage $this$generate_u24lambda_u241 = this;
                    boolean bl2 = false;
                    sin = MathHelper.func_76126_a((float)alphaY);
                    cos = MathHelper.func_76134_b((float)alphaY);
                    temp = vx;
                    vx = vx * cos - vz * sin;
                    vz = vz * cos + temp * sin;
                    float normInv = 1.0f / (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
                    vy *= normInv;
                    vz *= normInv;
                    if ((vx *= normInv) == 0.0f) {
                        vx += 1.0E-4f;
                    }
                    if (vy == 0.0f) {
                        vy += 1.0E-4f;
                    }
                    if (vz == 0.0f) {
                        vz += 1.0E-4f;
                    }
                    float vxInv = 1.0f / vx;
                    float vyInv = 1.0f / vy;
                    float vzInv = 1.0f / vz;
                    float stackRed = 0.0f;
                    float stackBlue = 0.0f;
                    float stackGreen = 0.0f;
                    for (float d = 0.0f; d < this.viewRange; d += dBest) {
                        float xFloor = MathHelper.func_76141_d((float)x);
                        float yFloor = MathHelper.func_76141_d((float)y);
                        float zFloor = MathHelper.func_76141_d((float)z);
                        float dx = x - xFloor;
                        float dy = y - yFloor;
                        float dz = z - zFloor;
                        dx = vx > 0.0f ? (1.0f - dx) * vxInv : -dx * vxInv;
                        dy = vy > 0.0f ? (1.0f - dy) * vyInv : -dy * vyInv;
                        dz = vz > 0.0f ? (1.0f - dz) * vzInv : -dz * vzInv;
                        dBest = Math.min(Math.min(dx, dy), dz) + 0.01f;
                        int xInt = (int)xFloor + this.worldBlocksDim2;
                        int yInt = (int)yFloor + this.worldBlocksDim2;
                        int zInt = (int)zFloor + this.worldBlocksDim2;
                        short blockKey = UShortArray.get-Mh2AYeg(this.worldBlocks[xInt][yInt].unbox-impl(), zInt);
                        if (blockKey == UShort.constructor-impl((short)65535)) {
                            ExtendedBlockStorage storage;
                            Chunk chunk;
                            int xBlock = posXint + (int)xFloor;
                            int yBlock = posYint + (int)yFloor;
                            int zBlock = posZint + (int)zFloor;
                            blockKey = 0;
                            boolean bl3 = 0 <= yBlock ? yBlock < 256 : false;
                            if (bl3 && (chunk = w.func_72938_d(xBlock, zBlock)) != null && (storage = chunk.func_76587_i()[yBlock >> 4]) != null) {
                                int xLocal = xBlock & 0xF;
                                int yLocal = yBlock & 0xF;
                                int zLocal = zBlock & 0xF;
                                byte blockId = UByte.constructor-impl(storage.func_76658_g()[yLocal << 8 | zLocal << 4 | xLocal]);
                                if (storage.func_76660_i() != null) {
                                    blockId = UByte.constructor-impl((byte)(blockId | UByte.constructor-impl((byte)(storage.func_76660_i().func_76582_a(xLocal, yLocal, zLocal) << 8))));
                                }
                                int n4 = UInt.constructor-impl(UInt.constructor-impl(storage.func_76665_b(xLocal, yLocal, zLocal)) << 12);
                                blockKey = UShort.constructor-impl((short)UInt.constructor-impl(UInt.constructor-impl(blockId & 0xFF) + n4));
                            }
                            int n5 = UInt.constructor-impl(1024 * 64);
                            if (Integer.compareUnsigned(UInt.constructor-impl(blockKey & 0xFFFF), n5) >= 0) {
                                blockKey = 0;
                            }
                            UShortArray.set-01HTLdE(this.worldBlocks[xInt][yInt].unbox-impl(), zInt, blockKey);
                        }
                        float dToStack = 0.0f;
                        dToStack = d + dBest < this.viewRange ? dBest : this.viewRange - d;
                        stackGreen += blockKeyFactor[blockKey & 0xFFFF] * dToStack;
                        Block b = Block.func_149729_e((int)(UShort.constructor-impl((short)(blockKey & 0xFFF)) & 0xFFFF));
                        if (b != Blocks.field_150350_a && b != Eln.lightBlock) {
                            stackRed += b.func_149662_c() ? 0.2f * dToStack : 0.1f * dToStack;
                        } else {
                            stackBlue += 0.06f * dToStack;
                        }
                        x += vx * dBest;
                        y += vy * dBest;
                        z += vz * dBest;
                    }
                    this.screenRed[screenY][screenX] = stackRed - stackGreen * 0.0f;
                    this.screenGreen[screenY][screenX] = stackGreen;
                    this.screenBlue[screenY][screenX] = stackBlue - stackGreen * 0.0f;
                }
            }
        }

        public final float noiseRand() {
            return ((float)Math.random() - 0.5f) * 0.03f;
        }

        @JvmOverloads
        public final void draw(float redFactor, float greenFactor, float blueFactor) {
            UtilsClient.disableLight();
            UtilsClient.disableTexture();
            int n = this.resHeight;
            for (int screenY = 0; screenY < n; ++screenY) {
                GL11.glBegin((int)8);
                int n2 = this.resWidth + 1;
                for (int screenX = 0; screenX < n2; ++screenX) {
                    if (screenX != this.resWidth) {
                        GL11.glColor3f((float)(this.screenRed[screenY][screenX] * redFactor + this.noiseRand()), (float)(this.screenGreen[screenY][screenX] * greenFactor + this.noiseRand()), (float)(this.screenBlue[screenY][screenX] * blueFactor + this.noiseRand()));
                    }
                    GL11.glVertex3f((float)screenX, (float)screenY, (float)0.0f);
                    GL11.glVertex3f((float)screenX, (float)(screenY + 1), (float)0.0f);
                }
                GL11.glEnd();
            }
            UtilsClient.enableTexture();
            UtilsClient.enableLight();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }

        public static /* synthetic */ void draw$default(RenderStorage renderStorage, float f, float f2, float f3, int n, Object object) {
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            if ((n & 2) != 0) {
                f2 = 1.0f;
            }
            if ((n & 4) != 0) {
                f3 = 1.0f;
            }
            renderStorage.draw(f, f2, f3);
        }

        @JvmOverloads
        public final void draw(float redFactor, float greenFactor) {
            RenderStorage.draw$default(this, redFactor, greenFactor, 0.0f, 4, null);
        }

        @JvmOverloads
        public final void draw(float redFactor) {
            RenderStorage.draw$default(this, redFactor, 0.0f, 0.0f, 6, null);
        }

        @JvmOverloads
        public final void draw() {
            RenderStorage.draw$default(this, 0.0f, 0.0f, 0.0f, 7, null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lmods/eln/item/electricalitem/PortableOreScannerItem$RenderStorage$OreScannerConfigElement;", "", "blockKey", "", "factor", "", "(IF)V", "getBlockKey", "()I", "setBlockKey", "(I)V", "getFactor", "()F", "setFactor", "(F)V", "Eln"})
        public static final class OreScannerConfigElement {
            private int blockKey;
            private float factor;

            public OreScannerConfigElement(int blockKey, float factor) {
                this.blockKey = blockKey;
                this.factor = factor;
            }

            public final int getBlockKey() {
                return this.blockKey;
            }

            public final void setBlockKey(int n) {
                this.blockKey = n;
            }

            public final float getFactor() {
                return this.factor;
            }

            public final void setFactor(float f) {
                this.factor = f;
            }
        }
    }
}

