/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import mods.eln.item.electricalitem.ElectricalTool;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.IProcess;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J>\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lmods/eln/item/electricalitem/TreeCapitation;", "Lmods/eln/sim/IProcess;", "()V", "BLOCK_RANGE", "", "BLOCK_SWAP_RATE", "LEAF_BLOCK_RANGE", "SINGLE_BLOCK_RADIUS", "blockSwappers", "", "", "Lmods/eln/item/electricalitem/TreeCapitation$BlockSwapper;", "addBlockSwapper", "", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "tool", "Lmods/eln/item/electricalitem/ElectricalTool;", "origCoords", "Lnet/minecraft/util/ChunkCoordinates;", "leaves", "", "stack", "Lnet/minecraft/item/ItemStack;", "process", "time", "", "removeBlockWithDrops", "x", "y", "z", "BlockSwapper", "Eln"})
@SourceDebugExtension(value={"SMAP\nElectricalAxe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElectricalAxe.kt\nmods/eln/item/electricalitem/TreeCapitation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,395:1\n766#2:396\n857#2,2:397\n*S KotlinDebug\n*F\n+ 1 ElectricalAxe.kt\nmods/eln/item/electricalitem/TreeCapitation\n*L\n124#1:396\n124#1:397,2\n*E\n"})
public final class TreeCapitation
implements IProcess {
    @NotNull
    public static final TreeCapitation INSTANCE = new TreeCapitation();
    public static final int BLOCK_SWAP_RATE = 10;
    public static final int BLOCK_RANGE = 32;
    public static final int LEAF_BLOCK_RANGE = 3;
    public static final int SINGLE_BLOCK_RADIUS = 1;
    @NotNull
    private static final Map<Integer, List<BlockSwapper>> blockSwappers = new HashMap();

    private TreeCapitation() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(double time) {
        for (Map.Entry<Integer, List<BlockSwapper>> entry : blockSwappers.entrySet()) {
            void $this$filterTo$iv$iv;
            int dim = ((Number)entry.getKey()).intValue();
            List<BlockSwapper> swappers = entry.getValue();
            Map<Integer, List<BlockSwapper>> map = blockSwappers;
            Integer n = dim;
            Iterable $this$filter$iv = swappers;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BlockSwapper it = (BlockSwapper)element$iv$iv;
                boolean bl = false;
                if (!it.tick()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            map.put(n, list);
        }
    }

    public final void addBlockSwapper(@NotNull World world, @NotNull EntityPlayer player, @NotNull ElectricalTool tool, @NotNull ChunkCoordinates origCoords, boolean leaves, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(tool, "tool");
        Intrinsics.checkNotNullParameter(origCoords, "origCoords");
        Intrinsics.checkNotNullParameter(stack, "stack");
        BlockSwapper swapper = new BlockSwapper(world, player, tool, origCoords, 32, leaves, stack);
        if (world.field_72995_K) {
            return;
        }
        int dim = world.field_73011_w.field_76574_g;
        Map<Integer, List<BlockSwapper>> map = blockSwappers;
        Integer n = dim;
        List<BlockSwapper> list = blockSwappers.get(dim);
        if (list == null || (list = CollectionsKt.plus((Collection)list, swapper)) == null) {
            list = CollectionsKt.listOf(swapper);
        }
        List<BlockSwapper> list2 = list;
        map.put(n, list2);
    }

    public final void removeBlockWithDrops(@NotNull EntityPlayer player, @NotNull ElectricalTool tool, @NotNull ItemStack stack, @NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(tool, "tool");
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(world, "world");
        if (world.field_72995_K || !world.func_72899_e(x, y, z)) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block != null && !block.isAir((IBlockAccess)world, x, y, z) && block.func_149737_a(player, world, x, y, z) > 0.0f) {
            if (!block.canHarvestBlock(player, meta)) {
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                double energy = tool.getEnergy(stack);
                tool.subtractEnergyForBlockBreak(stack, block);
                double newEnergy = tool.getEnergy(stack);
                if (newEnergy > 0.0 && newEnergy < energy) {
                    int localMeta = world.func_72805_g(x, y, z);
                    block.func_149681_a(world, x, y, z, localMeta, player);
                    if (block.removedByPlayer(world, player, x, y, z, true)) {
                        block.func_149664_b(world, x, y, z, localMeta);
                        block.func_149636_a(world, player, x, y, z, localMeta);
                    }
                }
            } else {
                world.func_147468_f(x, y, z);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\rR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lmods/eln/item/electricalitem/TreeCapitation$BlockSwapper;", "", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "tool", "Lmods/eln/item/electricalitem/ElectricalTool;", "origin", "Lnet/minecraft/util/ChunkCoordinates;", "range", "", "treatLeavesSpecial", "", "stack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lmods/eln/item/electricalitem/ElectricalTool;Lnet/minecraft/util/ChunkCoordinates;IZLnet/minecraft/item/ItemStack;)V", "candidateQueue", "Ljava/util/PriorityQueue;", "Lmods/eln/item/electricalitem/TreeCapitation$BlockSwapper$SwapCandidate;", "completedCoords", "", "getStack", "()Lnet/minecraft/item/ItemStack;", "adjacent", "", "original", "tick", "SwapCandidate", "Eln"})
    private static final class BlockSwapper {
        @NotNull
        private final World world;
        @NotNull
        private final EntityPlayer player;
        @NotNull
        private final ElectricalTool tool;
        @NotNull
        private final ChunkCoordinates origin;
        private final int range;
        private final boolean treatLeavesSpecial;
        @NotNull
        private final ItemStack stack;
        @NotNull
        private final PriorityQueue<SwapCandidate> candidateQueue;
        @NotNull
        private final Set<ChunkCoordinates> completedCoords;

        public BlockSwapper(@NotNull World world, @NotNull EntityPlayer player, @NotNull ElectricalTool tool, @NotNull ChunkCoordinates origin, int range, boolean treatLeavesSpecial, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter(world, "world");
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(tool, "tool");
            Intrinsics.checkNotNullParameter(origin, "origin");
            Intrinsics.checkNotNullParameter(stack, "stack");
            this.world = world;
            this.player = player;
            this.tool = tool;
            this.origin = origin;
            this.range = range;
            this.treatLeavesSpecial = treatLeavesSpecial;
            this.stack = stack;
            this.candidateQueue = new PriorityQueue();
            this.completedCoords = new HashSet();
            this.candidateQueue.offer(new SwapCandidate(this.origin, this.range));
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        public final boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 10;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate candidate = this.candidateQueue.poll();
                if (this.completedCoords.contains(candidate.getCoordinates()) || candidate.getRange() <= 0) continue;
                INSTANCE.removeBlockWithDrops(this.player, this.tool, this.stack, this.world, candidate.getCoordinates().field_71574_a, candidate.getCoordinates().field_71572_b, candidate.getCoordinates().field_71573_c);
                --remainingSwaps;
                this.completedCoords.add(candidate.getCoordinates());
                for (ChunkCoordinates adj : this.adjacent(candidate.getCoordinates())) {
                    Block block = this.world.func_147439_a(adj.field_71574_a, adj.field_71572_b, adj.field_71573_c);
                    boolean isWood = block.isWood((IBlockAccess)this.world, adj.field_71574_a, adj.field_71572_b, adj.field_71573_c);
                    boolean isLeaf = block.isLeaves((IBlockAccess)this.world, adj.field_71574_a, adj.field_71572_b, adj.field_71573_c);
                    if (!isWood && !isLeaf) continue;
                    int newRange = this.treatLeavesSpecial && isLeaf ? Math.min(3, candidate.getRange() - 1) : candidate.getRange() - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        @NotNull
        public final List<ChunkCoordinates> adjacent(@NotNull ChunkCoordinates original) {
            Intrinsics.checkNotNullParameter(original, "original");
            ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>();
            for (int dx = -1; dx < 2; ++dx) {
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dz = -1; dz < 2; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(new ChunkCoordinates(original.field_71574_a + dx, original.field_71572_b + dy, original.field_71573_c + dz));
                    }
                }
            }
            return coords;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lmods/eln/item/electricalitem/TreeCapitation$BlockSwapper$SwapCandidate;", "", "coordinates", "Lnet/minecraft/util/ChunkCoordinates;", "range", "", "(Lnet/minecraft/util/ChunkCoordinates;I)V", "getCoordinates", "()Lnet/minecraft/util/ChunkCoordinates;", "setCoordinates", "(Lnet/minecraft/util/ChunkCoordinates;)V", "getRange", "()I", "setRange", "(I)V", "compareTo", "other", "equals", "", "", "hashCode", "Eln"})
        public static final class SwapCandidate
        implements Comparable<SwapCandidate> {
            @NotNull
            private ChunkCoordinates coordinates;
            private int range;

            public SwapCandidate(@NotNull ChunkCoordinates coordinates, int range) {
                Intrinsics.checkNotNullParameter(coordinates, "coordinates");
                this.coordinates = coordinates;
                this.range = range;
            }

            @NotNull
            public final ChunkCoordinates getCoordinates() {
                return this.coordinates;
            }

            public final void setCoordinates(@NotNull ChunkCoordinates chunkCoordinates) {
                Intrinsics.checkNotNullParameter(chunkCoordinates, "<set-?>");
                this.coordinates = chunkCoordinates;
            }

            public final int getRange() {
                return this.range;
            }

            public final void setRange(int n) {
                this.range = n;
            }

            @Override
            public int compareTo(@NotNull SwapCandidate other) {
                Intrinsics.checkNotNullParameter(other, "other");
                return other.range - this.range;
            }

            public boolean equals(@Nullable Object other) {
                if (!(other instanceof SwapCandidate)) {
                    return false;
                }
                SwapCandidate cand = (SwapCandidate)other;
                return Intrinsics.areEqual(this.coordinates, cand.coordinates) && this.range == cand.range;
            }

            public int hashCode() {
                int result = this.coordinates.hashCode();
                result = 31 * result + this.range;
                return result;
            }
        }
    }
}

