/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamage;
import mods.eln.mechanical.ClutchContainer;
import mods.eln.mechanical.ClutchPlateItem;
import mods.eln.mechanical.ShaftElement;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.DirectionSet;
import mods.eln.misc.IFunction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.process.destruct.DelayedDestruction;
import mods.eln.sim.process.destruct.WorldExplosion;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002uvB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020<2\u0006\u0010K\u001a\u00020(H\u0016J\b\u0010L\u001a\u00020MH\u0016J\u001a\u0010N\u001a\u00020I2\u0006\u0010J\u001a\u00020<2\b\u0010K\u001a\u0004\u0018\u00010(H\u0016J\u0018\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020<2\u0006\u0010Q\u001a\u00020RH\u0016J\u0018\u0010S\u001a\u00020T2\u0006\u0010P\u001a\u00020<2\u0006\u0010Q\u001a\u00020RH\u0016J\u0012\u0010U\u001a\u0004\u0018\u00010(2\u0006\u0010V\u001a\u00020<H\u0016J\u001a\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010P\u001a\u00020<2\u0006\u0010Q\u001a\u00020RH\u0016J\u0014\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020[0ZH\u0016J\b\u0010\\\u001a\u00020CH\u0016J\b\u0010]\u001a\u00020IH\u0016J\b\u0010^\u001a\u00020CH\u0016J\u0018\u0010_\u001a\u00020C2\u0006\u0010`\u001a\u00020<2\u0006\u0010a\u001a\u00020<H\u0016J\u0010\u0010b\u001a\u00020I2\u0006\u0010c\u001a\u00020dH\u0016J\u0018\u0010e\u001a\u00020f2\u0006\u0010P\u001a\u00020<2\u0006\u0010g\u001a\u00020hH\u0016J0\u0010i\u001a\u00020C2\u0006\u0010g\u001a\u00020h2\u0006\u0010P\u001a\u00020<2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020k2\u0006\u0010m\u001a\u00020kH\u0016J\b\u0010n\u001a\u00020IH\u0016J\u0010\u0010o\u001a\u00020I2\u0006\u0010p\u001a\u00020qH\u0016J\u001a\u0010r\u001a\u00020I2\u0006\u0010V\u001a\u00020<2\b\u0010K\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010s\u001a\u00020[2\u0006\u0010P\u001a\u00020<H\u0016J\u0010\u0010t\u001a\u00020I2\u0006\u0010p\u001a\u00020qH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\"\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00104\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u00105\u001a\b\u0012\u0004\u0012\u00020/0.X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00104\u001a\u0004\b6\u00101\"\u0004\b7\u00103R\u001a\u00108\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010*\"\u0004\b:\u0010,R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020<0.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020/X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010G\u00a8\u0006w"}, d2={"Lmods/eln/mechanical/ClutchElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "LEFT", "", "getLEFT", "()I", "RIGHT", "getRIGHT", "clutchPinStack", "Lnet/minecraft/item/ItemStack;", "getClutchPinStack", "()Lnet/minecraft/item/ItemStack;", "clutchPlateDescriptor", "Lmods/eln/mechanical/ClutchPlateItem;", "getClutchPlateDescriptor$annotations", "()V", "getClutchPlateDescriptor", "()Lmods/eln/mechanical/ClutchPlateItem;", "clutchPlateStack", "getClutchPlateStack", "connectedSides", "Lmods/eln/misc/DirectionSet;", "getConnectedSides", "()Lmods/eln/misc/DirectionSet;", "inputGate", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "getInputGate", "()Lmods/eln/sim/nbt/NbtElectricalGateInput;", "inv", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "getInv", "()Lmods/eln/node/transparent/TransparentNodeElementInventory;", "inventory", "getInventory", "leftShaft", "Lmods/eln/mechanical/ShaftNetwork;", "getLeftShaft", "()Lmods/eln/mechanical/ShaftNetwork;", "setLeftShaft", "(Lmods/eln/mechanical/ShaftNetwork;)V", "preEnergy", "", "", "getPreEnergy", "()[Ljava/lang/Double;", "setPreEnergy", "([Ljava/lang/Double;)V", "[Ljava/lang/Double;", "preRads", "getPreRads", "setPreRads", "rightShaft", "getRightShaft", "setRightShaft", "shaftConnectivity", "Lmods/eln/misc/Direction;", "getShaftConnectivity", "()[Lmods/eln/misc/Direction;", "shaftMass", "getShaftMass", "()D", "slipping", "", "getSlipping", "()Z", "setSlipping", "(Z)V", "connectedOnSide", "", "direction", "net", "coordonate", "Lmods/eln/misc/Coordinate;", "disconnectedOnSide", "getConnectionMask", "side", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getShaft", "dir", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "initialize", "isDestructing", "isInternallyConnected", "a", "b", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "newContainer", "Lmods/eln/mechanical/ClutchContainer;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockActivated", "vx", "", "vy", "vz", "onBreakElement", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "setShaft", "thermoMeterString", "writeToNBT", "ClutchPostProcess", "ClutchPreProcess", "Eln"})
@SourceDebugExtension(value={"SMAP\nClutch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Clutch.kt\nmods/eln/mechanical/ClutchElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,551:1\n1549#2:552\n1620#2,3:553\n1549#2:556\n1620#2,3:557\n1549#2:560\n1620#2,3:561\n*S KotlinDebug\n*F\n+ 1 Clutch.kt\nmods/eln/mechanical/ClutchElement\n*L\n410#1:552\n410#1:553,3\n413#1:556\n413#1:557,3\n417#1:560\n417#1:561,3\n*E\n"})
public final class ClutchElement
extends SimpleShaftElement {
    private final double shaftMass;
    @NotNull
    private final DirectionSet connectedSides;
    @NotNull
    private ShaftNetwork leftShaft;
    @NotNull
    private ShaftNetwork rightShaft;
    @NotNull
    private final TransparentNodeElementInventory inv;
    @NotNull
    private final TransparentNodeElementInventory inventory;
    @NotNull
    private final NbtElectricalGateInput inputGate;
    private boolean slipping;
    private final int LEFT;
    private final int RIGHT;
    @NotNull
    private Double[] preRads;
    @NotNull
    private Double[] preEnergy;

    public ClutchElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        this.shaftMass = 0.5;
        this.connectedSides = new DirectionSet();
        this.leftShaft = new ShaftNetwork();
        this.rightShaft = new ShaftNetwork();
        this.inventory = this.inv = new TransparentNodeElementInventory(2, 1, this);
        this.inputGate = new NbtElectricalGateInput("clutchIn");
        this.slipping = true;
        this.RIGHT = 1;
        Double[] doubleArray = new Double[]{0.0, 0.0};
        this.preRads = doubleArray;
        doubleArray = new Double[]{0.0, 0.0};
        this.preEnergy = doubleArray;
        this.getSlowPreProcessList().add(new ClutchPreProcess());
        this.electricalLoadList.add(this.inputGate);
        this.getSlowPostProcessList().add(new ClutchPostProcess());
    }

    @Override
    public double getShaftMass() {
        return this.shaftMass;
    }

    @NotNull
    public final DirectionSet getConnectedSides() {
        return this.connectedSides;
    }

    @NotNull
    public final ShaftNetwork getLeftShaft() {
        return this.leftShaft;
    }

    public final void setLeftShaft(@NotNull ShaftNetwork shaftNetwork) {
        Intrinsics.checkNotNullParameter(shaftNetwork, "<set-?>");
        this.leftShaft = shaftNetwork;
    }

    @NotNull
    public final ShaftNetwork getRightShaft() {
        return this.rightShaft;
    }

    public final void setRightShaft(@NotNull ShaftNetwork shaftNetwork) {
        Intrinsics.checkNotNullParameter(shaftNetwork, "<set-?>");
        this.rightShaft = shaftNetwork;
    }

    @Override
    public void initialize() {
        this.reconnect();
        double lRads = this.leftShaft.getRads();
        double rRads = this.rightShaft.getRads();
        this.leftShaft = new ShaftNetwork((ShaftElement)this, this.front.left());
        this.rightShaft = new ShaftNetwork((ShaftElement)this, this.front.right());
        double d = lRads;
        this.leftShaft.setRads(!Double.isInfinite(d) && !Double.isNaN(d) ? lRads : 0.0);
        d = rRads;
        this.rightShaft.setRads(!Double.isInfinite(d) && !Double.isNaN(d) ? rRads : 0.0);
        this.leftShaft.connectShaft(this, this.front.left());
        this.rightShaft.connectShaft(this, this.front.right());
        if (!Intrinsics.areEqual(this.getShaft(this.front.left()), this.leftShaft)) {
            Utils.println("CE.init ERROR: getShaft(left) != leftShaft");
        }
        if (!Intrinsics.areEqual(this.getShaft(this.front.right()), this.rightShaft)) {
            Utils.println("CE.init ERROR: getShaft(right) != rightShaft");
        }
    }

    @Override
    public void onBreakElement() {
        this.leftShaft.disconnectShaft(this);
        this.rightShaft.disconnectShaft(this);
        super.onBreakElement();
    }

    @Override
    public boolean isDestructing() {
        return this.getDestructing();
    }

    @Override
    @Nullable
    public ShaftNetwork getShaft(@NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)dir, "dir");
        Direction direction = dir;
        return direction == this.front.left() ? this.leftShaft : (direction == this.front.right() ? this.rightShaft : null);
    }

    @Override
    public void setShaft(@NotNull Direction dir, @Nullable ShaftNetwork net) {
        block2: {
            Direction direction;
            block1: {
                Intrinsics.checkNotNullParameter((Object)dir, "dir");
                if (net == null) {
                    return;
                }
                direction = dir;
                if (direction != this.front.left()) break block1;
                this.leftShaft = net;
                break block2;
            }
            if (direction != this.front.right()) break block2;
            this.rightShaft = net;
        }
    }

    @Override
    public boolean isInternallyConnected(@NotNull Direction a, @NotNull Direction b) {
        Intrinsics.checkNotNullParameter((Object)a, "a");
        Intrinsics.checkNotNullParameter((Object)b, "b");
        return false;
    }

    @NotNull
    public final TransparentNodeElementInventory getInv() {
        return this.inv;
    }

    @NotNull
    public TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    @Override
    @NotNull
    public ClutchContainer newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new ClutchContainer(player, (IInventory)this.inv);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @NotNull
    public final NbtElectricalGateInput getInputGate() {
        return this.inputGate;
    }

    public final boolean getSlipping() {
        return this.slipping;
    }

    public final void setSlipping(boolean bl) {
        this.slipping = bl;
    }

    @Override
    @NotNull
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.inputGate;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return 4;
    }

    @Nullable
    public final ItemStack getClutchPlateStack() {
        return this.inv.func_70301_a(0);
    }

    @Nullable
    public final ClutchPlateItem getClutchPlateDescriptor() {
        ItemStack itemStack = this.getClutchPlateStack();
        if (itemStack == null) {
            return null;
        }
        ItemStack stack = itemStack;
        Item item = stack.func_77973_b();
        Intrinsics.checkNotNull(item);
        Object Descriptor = ((GenericItemUsingDamage)item).getDescriptor(stack);
        Intrinsics.checkNotNull(Descriptor, "null cannot be cast to non-null type mods.eln.mechanical.ClutchPlateItem");
        return (ClutchPlateItem)Descriptor;
    }

    public static /* synthetic */ void getClutchPlateDescriptor$annotations() {
    }

    @Nullable
    public final ItemStack getClutchPinStack() {
        return this.inv.func_70301_a(1);
    }

    public final int getLEFT() {
        return this.LEFT;
    }

    public final int getRIGHT() {
        return this.RIGHT;
    }

    @NotNull
    public final Double[] getPreRads() {
        return this.preRads;
    }

    public final void setPreRads(@NotNull Double[] doubleArray) {
        Intrinsics.checkNotNullParameter(doubleArray, "<set-?>");
        this.preRads = doubleArray;
    }

    @NotNull
    public final Double[] getPreEnergy() {
        return this.preEnergy;
    }

    public final void setPreEnergy(@NotNull Double[] doubleArray) {
        Intrinsics.checkNotNullParameter(doubleArray, "<set-?>");
        this.preEnergy = doubleArray;
    }

    @Override
    @NotNull
    public Direction[] getShaftConnectivity() {
        Direction[] directionArray = new Direction[]{this.front.left(), this.front.right()};
        return directionArray;
    }

    @Override
    public void connectedOnSide(@NotNull Direction direction, @NotNull ShaftNetwork net) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Intrinsics.checkNotNullParameter(net, "net");
        this.connectedSides.add(direction);
        this.needPublish();
    }

    @Override
    public void disconnectedOnSide(@NotNull Direction direction, @Nullable ShaftNetwork net) {
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        this.connectedSides.remove((Object)direction);
        this.needPublish();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        this.connectedSides.serialize(stream);
        stream.writeFloat((float)this.leftShaft.getRads());
        stream.writeFloat((float)this.rightShaft.getRads());
        stream.writeFloat((float)this.inputGate.getNormalized());
        stream.writeBoolean(this.slipping);
        stack = this.getClutchPlateStack();
        pDisc = this.getClutchPlateDescriptor();
        if (stack == null) ** GOTO lbl-1000
        v0 = pDisc;
        Intrinsics.checkNotNull(v0);
        if (v0.getWear(stack) >= 1.0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        worn = v1;
        stream.writeBoolean(worn);
        stream.writeBoolean(this.getClutchPinStack() != null);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        this.connectedSides.writeToNBT(nbt, "sides");
        this.leftShaft.writeToNBT(nbt, "leftShaft");
        this.rightShaft.writeToNBT(nbt, "rightShaft");
        nbt.func_74757_a("slipping", this.slipping);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.connectedSides.readFromNBT(nbt, "sides");
        this.leftShaft.readFromNBT(nbt, "leftShaft");
        this.rightShaft.readFromNBT(nbt, "rightShaft");
        this.slipping = nbt.func_74767_n("slipping");
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map.Entry it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map info = new LinkedHashMap();
        Object object = new Pair[]{new Pair<Direction, ShaftNetwork>(this.front.left(), this.leftShaft), new Pair<Direction, ShaftNetwork>(this.front.right(), this.rightShaft)};
        Set entries = MapsKt.mapOf(object).entrySet();
        object = entries;
        String string = "Speeds";
        Map map = info;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Utils.plotRads("", ((ShaftNetwork)it.getValue()).getRads()));
        }
        collection = (List)destination$iv$iv;
        map.put(string, CollectionsKt.joinToString$default(collection, ", ", null, null, 0, null, null, 62, null));
        $this$map$iv = entries;
        string = "Energies";
        map = info;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Utils.plotEnergy("", ((ShaftNetwork)it.getValue()).getEnergy()));
        }
        collection = (List)destination$iv$iv;
        map.put(string, CollectionsKt.joinToString$default(collection, ", ", null, null, 0, null, null, 62, null));
        if (Eln.wailaEasyMode) {
            $this$map$iv = entries;
            string = "Masses";
            map = info;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Utils.plotValue(((ShaftNetwork)it.getValue()).getMass() * (double)1000, "g"));
            }
            collection = (List)destination$iv$iv;
            map.put(string, CollectionsKt.joinToString$default(collection, ", ", null, null, 0, null, null, 62, null));
            ClutchPlateItem desc = this.getClutchPlateDescriptor();
            ItemStack stack = this.getClutchPlateStack();
            if (desc != null && stack != null) {
                String string2 = "%.6f";
                Object[] objectArray = new Object[]{desc.getWear(stack)};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                info.put("Wear", string3);
            }
        }
        info.put("Clutching", Utils.plotVolt(this.inputGate.getSignalVoltage()));
        if (Eln.wailaEasyMode) {
            info.put("Slipping", this.slipping ? "YES" : "NO");
        }
        return info;
    }

    @Override
    @NotNull
    public Coordinate coordonate() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        TransparentNodeElement transparentNodeElement = transparentNode.element;
        Intrinsics.checkNotNull(transparentNodeElement);
        return transparentNodeElement.coordinate();
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "";
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lmods/eln/mechanical/ClutchElement$ClutchPreProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/mechanical/ClutchElement;)V", "process", "", "time", "", "Eln"})
    public final class ClutchPreProcess
    implements IProcess {
        @Override
        public void process(double time) {
            ClutchElement.this.getPreRads()[ClutchElement.this.getLEFT()] = ClutchElement.this.getLeftShaft().getRads();
            ClutchElement.this.getPreRads()[ClutchElement.this.getRIGHT()] = ClutchElement.this.getRightShaft().getRads();
            ClutchElement.this.getPreEnergy()[ClutchElement.this.getLEFT()] = ClutchElement.this.getLeftShaft().getEnergy();
            ClutchElement.this.getPreEnergy()[ClutchElement.this.getRIGHT()] = ClutchElement.this.getRightShaft().getEnergy();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lmods/eln/mechanical/ClutchElement$ClutchPostProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/mechanical/ClutchElement;)V", "process", "", "time", "", "Eln"})
    public final class ClutchPostProcess
    implements IProcess {
        @Override
        public void process(double time) {
            double d;
            boolean hasPin;
            double d2;
            double clutching = ClutchElement.this.getInputGate().getNormalized();
            if (clutching == 0.0 || !(!Double.isInfinite(d2 = clutching) && !Double.isNaN(d2))) {
                ClutchElement.this.setSlipping(true);
                return;
            }
            ClutchPlateItem plateDescriptor = ClutchElement.this.getClutchPlateDescriptor();
            ItemStack stack = ClutchElement.this.getClutchPlateStack();
            if (plateDescriptor == null || stack == null) {
                ClutchElement.this.setSlipping(true);
                return;
            }
            double wear = plateDescriptor.getWear(stack);
            IFunction maxStaticEnergyF = plateDescriptor.maxStaticEnergyF(stack);
            IFunction dynamicMaxTransferF = plateDescriptor.dynamicMaxTransferF(stack);
            IFunction slipWearF = plateDescriptor.slipWearF(stack);
            if (wear >= 1.0) {
                ClutchElement.this.setSlipping(true);
                return;
            }
            boolean bl = hasPin = ClutchElement.this.getClutchPinStack() != null;
            if (Intrinsics.areEqual(ClutchElement.this.getLeftShaft(), ClutchElement.this.getRightShaft())) {
                Utils.println("WARN (ClutchProcess): Networks are the same!");
            }
            double d3 = !Double.isInfinite(d = ClutchElement.this.getLeftShaft().getMass()) && !Double.isNaN(d) ? ClutchElement.this.getLeftShaft().getMass() : 1.0;
            d = ClutchElement.this.getRightShaft().getMass();
            double mass = d3 + (!Double.isInfinite(d) && !Double.isNaN(d) ? ClutchElement.this.getRightShaft().getMass() : 1.0);
            ShaftNetwork slower = null;
            ShaftNetwork faster = null;
            int slowerIdx = 0;
            int fasterIdx = 0;
            if (ClutchElement.this.getPreRads()[ClutchElement.this.getLEFT()] > ClutchElement.this.getPreRads()[ClutchElement.this.getRIGHT()]) {
                slower = ClutchElement.this.getRightShaft();
                faster = ClutchElement.this.getLeftShaft();
                slowerIdx = ClutchElement.this.getRIGHT();
                fasterIdx = ClutchElement.this.getLEFT();
            } else {
                slower = ClutchElement.this.getLeftShaft();
                faster = ClutchElement.this.getRightShaft();
                slowerIdx = ClutchElement.this.getLEFT();
                fasterIdx = ClutchElement.this.getRIGHT();
            }
            if (ClutchElement.this.getSlipping()) {
                if (plateDescriptor.getExplodes() && faster.getRads() - slower.getRads() > 5.0) {
                    ClutchElement clutchElement = ClutchElement.this;
                    Intrinsics.checkNotNull(clutchElement, "null cannot be cast to non-null type mods.eln.mechanical.ShaftElement");
                    new DelayedDestruction(new WorldExplosion(clutchElement).machineExplosion(), 0.0);
                    return;
                }
                ClutchElement.this.needPublish();
                double torque = clutching * dynamicMaxTransferF.getValue(wear);
                double deltaR = faster.getRads() - slower.getRads();
                slower.setRads(slower.getRads() + torque / slower.getMass());
                faster.setRads(faster.getRads() - torque / faster.getMass());
                if (!(Math.signum(ClutchElement.this.getRightShaft().getRads() - ClutchElement.this.getLeftShaft().getRads()) == Math.signum(ClutchElement.this.getPreRads()[ClutchElement.this.getRIGHT()] - ClutchElement.this.getPreRads()[ClutchElement.this.getLEFT()]))) {
                    double t;
                    double dWFast = faster.getRads() - ClutchElement.this.getPreRads()[fasterIdx];
                    double dwSlow = slower.getRads() - ClutchElement.this.getPreRads()[slowerIdx];
                    double tnum = ClutchElement.this.getPreRads()[slowerIdx] - ClutchElement.this.getPreRads()[fasterIdx];
                    double tdenom = dWFast - dwSlow;
                    if (tdenom == 0.0) {
                        Utils.println("CPP.p: WARN: tdenom was 0?");
                        tdenom = 1.0;
                    }
                    if ((t = tnum / tdenom) <= 1.0 && t >= 0.0) {
                        ClutchElement.this.setSlipping(false);
                        double finalW = ClutchElement.this.getPreRads()[fasterIdx] + t * dWFast;
                        faster.setRads(finalW);
                        slower.setRads(finalW);
                    }
                } else {
                    ClutchPlateItem clutchPlateItem = ClutchElement.this.getClutchPlateDescriptor();
                    Intrinsics.checkNotNull(clutchPlateItem);
                    ItemStack itemStack = ClutchElement.this.getClutchPlateStack();
                    Intrinsics.checkNotNull(itemStack);
                    clutchPlateItem.setWear(itemStack, wear + clutching * slipWearF.getValue(Math.abs(deltaR)));
                }
            } else {
                double energy;
                double maxE = clutching * maxStaticEnergyF.getValue(wear);
                double leftEnergy = energy = ClutchElement.this.getLeftShaft().getEnergy() + ClutchElement.this.getRightShaft().getEnergy();
                double rightEnergy = energy;
                double flow = ClutchElement.this.getLeftShaft().getEnergy() - ClutchElement.this.getRightShaft().getEnergy() - ClutchElement.this.getPreEnergy()[ClutchElement.this.getLEFT()] + ClutchElement.this.getPreEnergy()[ClutchElement.this.getRIGHT()];
                if (Math.abs(flow) > maxE && !hasPin) {
                    ShaftNetwork shaftNetwork = ClutchElement.this.getLeftShaft();
                    shaftNetwork.setEnergy(shaftNetwork.getEnergy() - Math.signum(flow) * maxE);
                    shaftNetwork = ClutchElement.this.getRightShaft();
                    shaftNetwork.setEnergy(shaftNetwork.getEnergy() + Math.signum(flow) * maxE);
                    ClutchElement.this.setSlipping(true);
                    ClutchElement.this.needPublish();
                } else {
                    ClutchElement.this.getLeftShaft().setRads(Math.sqrt((double)2 * leftEnergy / (mass * Eln.shaftEnergyFactor)));
                    ClutchElement.this.getRightShaft().setRads(Math.sqrt((double)2 * rightEnergy / (mass * Eln.shaftEnergyFactor)));
                }
            }
        }
    }
}

