/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.util.List;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.IFunction;
import mods.eln.misc.LinearFunction;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018J\u0016\u0010&\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00182\u0006\u0010'\u001a\u00020$J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006)"}, d2={"Lmods/eln/mechanical/ClutchPlateItem;", "Lmods/eln/generic/GenericItemUsingDamageDescriptor;", "name", "", "maxEF", "", "minEF", "maxDTF", "minDTF", "wearSpeed", "explodes", "", "(Ljava/lang/String;FFFFFZ)V", "getExplodes", "()Z", "getMaxDTF", "()F", "getMaxEF", "getMinDTF", "getMinEF", "getWearSpeed", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "dynamicMaxTransferF", "Lmods/eln/misc/IFunction;", "stack", "getDefaultNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "getWear", "", "maxStaticEnergyF", "setWear", "wear", "slipWearF", "Eln"})
public final class ClutchPlateItem
extends GenericItemUsingDamageDescriptor {
    private final float maxEF;
    private final float minEF;
    private final float maxDTF;
    private final float minDTF;
    private final float wearSpeed;
    private final boolean explodes;

    public ClutchPlateItem(@NotNull String name, float maxEF, float minEF, float maxDTF, float minDTF, float wearSpeed, boolean explodes) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name, null, 2, null);
        this.maxEF = maxEF;
        this.minEF = minEF;
        this.maxDTF = maxDTF;
        this.minDTF = minDTF;
        this.wearSpeed = wearSpeed;
        this.explodes = explodes;
    }

    public final float getMaxEF() {
        return this.maxEF;
    }

    public final float getMinEF() {
        return this.minEF;
    }

    public final float getMaxDTF() {
        return this.maxDTF;
    }

    public final float getMinDTF() {
        return this.minDTF;
    }

    public final float getWearSpeed() {
        return this.wearSpeed;
    }

    public final boolean getExplodes() {
        return this.explodes;
    }

    @Override
    @NotNull
    public NBTTagCompound getDefaultNBT() {
        return new NBTTagCompound();
    }

    public final void setWear(@NotNull ItemStack stack, double wear) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (!stack.func_77942_o()) {
            stack.func_77982_d(this.getDefaultNBT());
        }
        stack.func_77978_p().func_74780_a("wear", wear);
    }

    public final double getWear(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (!stack.func_77942_o()) {
            return 0.0;
        }
        return stack.func_77978_p().func_74769_h("wear");
    }

    @NotNull
    public final IFunction maxStaticEnergyF(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return new LinearFunction(0.0f, this.maxEF, 1.0f, this.minEF);
    }

    @NotNull
    public final IFunction dynamicMaxTransferF(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return new LinearFunction(0.0f, this.maxDTF, 1.0f, this.minDTF);
    }

    @NotNull
    public final IFunction slipWearF(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return new LinearFunction(0.0f, 0.0f, 1000.0f, this.wearSpeed);
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (itemStack != null) {
            double wear = this.getWear(itemStack);
            if (wear < 0.2) {
                list.add(I18N.tr("Condition:", new Object[0]) + ' ' + I18N.tr("New", new Object[0]));
            } else if (wear < 0.5) {
                list.add(I18N.tr("Condition:", new Object[0]) + ' ' + I18N.tr("Good", new Object[0]));
            } else if (wear < 0.8) {
                list.add(I18N.tr("Condition:", new Object[0]) + ' ' + I18N.tr("Used", new Object[0]));
            } else if (wear < 0.9) {
                list.add(I18N.tr("Condition:", new Object[0]) + ' ' + I18N.tr("End of life", new Object[0]));
            } else {
                list.add(I18N.tr("Condition:", new Object[0]) + ' ' + I18N.tr("Bad", new Object[0]));
            }
        }
    }
}

