/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataInputStream;
import mods.eln.Eln;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.mechanical.ClutchDescriptor;
import mods.eln.mechanical.ClutchGui;
import mods.eln.mechanical.ShaftRender;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.DirectionSet;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBlockEntity;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sound.LoopedSound;
import mods.eln.sound.SoundCommand;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001MB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020@2\u0006\u0010K\u001a\u00020LH\u0016R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u001a\u0010&\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u000f\"\u0004\b(\u0010\u0011R\u0011\u0010)\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000fR\u001a\u0010+\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u000f\"\u0004\b-\u0010\u0011R\u001a\u0010.\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001d\"\u0004\b0\u0010\u001fR\u001a\u00101\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u000f\"\u0004\b3\u0010\u0011R\u0011\u00104\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000fR\u001a\u00106\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u000f\"\u0004\b8\u0010\u0011R\u001a\u00109\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001d\"\u0004\b;\u0010\u001fR\u001a\u0010<\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u001d\"\u0004\b>\u0010\u001f\u00a8\u0006N"}, d2={"Lmods/eln/mechanical/ClutchRender;", "Lmods/eln/mechanical/ShaftRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "cableRender", "Lmods/eln/cable/CableRenderDescriptor;", "mods.eln.shadow.kotlin.jvm.PlatformType", "getCableRender", "()Lmods/eln/cable/CableRenderDescriptor;", "clutching", "", "getClutching", "()D", "setClutching", "(D)V", "connectedSides", "Lmods/eln/misc/DirectionSet;", "getConnectedSides", "()Lmods/eln/misc/DirectionSet;", "desc", "Lmods/eln/mechanical/ClutchDescriptor;", "getDesc", "()Lmods/eln/mechanical/ClutchDescriptor;", "hasPin", "", "getHasPin", "()Z", "setHasPin", "(Z)V", "inv", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "getInv", "()Lmods/eln/node/transparent/TransparentNodeElementInventory;", "inventory", "getInventory", "lAngle", "getLAngle", "setLAngle", "lLogRads", "getLLogRads", "lRads", "getLRads", "setLRads", "lastSlipping", "getLastSlipping", "setLastSlipping", "rAngle", "getRAngle", "setRAngle", "rLogRads", "getRLogRads", "rRads", "getRRads", "setRRads", "slipping", "getSlipping", "setSlipping", "worn", "getWorn", "setWorn", "draw", "", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "side", "Lmods/eln/misc/Direction;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "refresh", "deltaT", "", "ClutchLoopedSound", "Eln"})
@SourceDebugExtension(value={"SMAP\nClutch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Clutch.kt\nmods/eln/mechanical/ClutchRender\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 GLUtil.kt\nmods/eln/misc/GLUtilKt\n*L\n1#1,551:1\n13579#2,2:552\n12#3,7:554\n12#3,7:561\n*S KotlinDebug\n*F\n+ 1 Clutch.kt\nmods/eln/mechanical/ClutchRender\n*L\n508#1:552,2\n474#1:554,7\n483#1:561,7\n*E\n"})
public final class ClutchRender
extends ShaftRender {
    @NotNull
    private final ClutchDescriptor desc;
    @NotNull
    private final DirectionSet connectedSides;
    private final CableRenderDescriptor cableRender;
    @NotNull
    private final TransparentNodeElementInventory inv;
    @NotNull
    private final TransparentNodeElementInventory inventory;
    private double lRads;
    private double rRads;
    private double lAngle;
    private double rAngle;
    private double clutching;
    private boolean slipping;
    private boolean lastSlipping;
    private boolean worn;
    private boolean hasPin;

    public ClutchRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(entity, desc_);
        this.desc = (ClutchDescriptor)desc_;
        this.connectedSides = new DirectionSet();
        this.cableRender = Eln.instance.stdCableRenderSignal;
        this.inventory = this.inv = new TransparentNodeElementInventory(2, 1, this);
        this.addLoopedSound(new ClutchLoopedSound(this.desc.getSlipSound(), this.coordinate()));
        LRDU[] $this$forEach$iv = LRDU.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            LRDU element$iv;
            LRDU it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.getEConn().set(it, true);
            this.getMask().set(it, true);
        }
        this.getVolumeSetting().setTarget(0.0f);
    }

    @NotNull
    public final ClutchDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final DirectionSet getConnectedSides() {
        return this.connectedSides;
    }

    @Override
    public CableRenderDescriptor getCableRender() {
        return this.cableRender;
    }

    @NotNull
    public final TransparentNodeElementInventory getInv() {
        return this.inv;
    }

    @NotNull
    public TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    public final double getLRads() {
        return this.lRads;
    }

    public final void setLRads(double d) {
        this.lRads = d;
    }

    public final double getRRads() {
        return this.rRads;
    }

    public final void setRRads(double d) {
        this.rRads = d;
    }

    public final double getLLogRads() {
        return Math.log(this.lRads + 1.0) / Math.log(1.2);
    }

    public final double getRLogRads() {
        return Math.log(this.rRads + 1.0) / Math.log(1.2);
    }

    public final double getLAngle() {
        return this.lAngle;
    }

    public final void setLAngle(double d) {
        this.lAngle = d;
    }

    public final double getRAngle() {
        return this.rAngle;
    }

    public final void setRAngle(double d) {
        this.rAngle = d;
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.lAngle += (double)deltaT * this.getLLogRads();
        this.rAngle += (double)deltaT * this.getRLogRads();
        this.getVolumeSetting().step(deltaT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw() {
        boolean $i$f$preserveMatrix = false;
        Unit ret$iv = null;
        try {
            double d;
            GL11.glPushMatrix();
            boolean bl = false;
            Direction direction = this.front;
            Intrinsics.checkNotNull((Object)direction);
            direction.glRotateXnRef();
            Direction direction2 = this.front;
            switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
                case 1: 
                case 2: {
                    d = 1.0;
                    break;
                }
                default: {
                    d = -1.0;
                }
            }
            double angSign = d;
            this.desc.draw(this.lAngle * angSign, this.rAngle * angSign);
            ret$iv = Unit.INSTANCE;
        }
        finally {
            GL11.glPopMatrix();
        }
        $i$f$preserveMatrix = false;
        ret$iv = null;
        try {
            GL11.glPushMatrix();
            boolean bl = false;
            if (this.getCableRefresh()) {
                this.setCableRefresh(false);
                NodeBlockEntity nodeBlockEntity = this.getTileEntity();
                LRDUMask lRDUMask = this.getEConn();
                Direction direction = this.front;
                Intrinsics.checkNotNull((Object)direction);
                this.setConnectionType(CableRender.connectionType(nodeBlockEntity, lRDUMask, direction.down()));
            }
            Direction direction = this.front;
            Intrinsics.checkNotNull((Object)direction);
            this.glCableTransform(direction.down());
            CableRenderDescriptor cableRenderDescriptor = this.getCableRender();
            Intrinsics.checkNotNull(cableRenderDescriptor);
            cableRenderDescriptor.bindCableTexture();
            for (LRDU lrdu : LRDU.values()) {
                CableRenderType cableRenderType = this.getConnectionType();
                Intrinsics.checkNotNull(cableRenderType);
                Utils.setGlColorFromDye(cableRenderType.otherdry[lrdu.toInt()]);
                if (!this.getEConn().get(lrdu)) continue;
                this.getMask().set(1 << lrdu.ordinal());
                CableRenderDescriptor cableRenderDescriptor2 = this.getCableRender();
                LRDUMask lRDUMask = this.getMask();
                CableRenderType cableRenderType2 = this.getConnectionType();
                Intrinsics.checkNotNull(cableRenderType2);
                CableRender.drawCable$default(cableRenderDescriptor2, lRDUMask, cableRenderType2, 0.0f, false, 24, null);
            }
            ret$iv = Unit.INSTANCE;
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    public final double getClutching() {
        return this.clutching;
    }

    public final void setClutching(double d) {
        this.clutching = d;
    }

    public final boolean getSlipping() {
        return this.slipping;
    }

    public final void setSlipping(boolean bl) {
        this.slipping = bl;
    }

    public final boolean getLastSlipping() {
        return this.lastSlipping;
    }

    public final void setLastSlipping(boolean bl) {
        this.lastSlipping = bl;
    }

    public final boolean getWorn() {
        return this.worn;
    }

    public final void setWorn(boolean bl) {
        this.worn = bl;
    }

    public final boolean getHasPin() {
        return this.hasPin;
    }

    public final void setHasPin(boolean bl) {
        this.hasPin = bl;
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        this.connectedSides.deserialize(stream);
        this.lRads = stream.readFloat();
        this.rRads = stream.readFloat();
        this.clutching = stream.readFloat();
        this.slipping = stream.readBoolean();
        this.worn = stream.readBoolean();
        this.hasPin = stream.readBoolean();
        if (this.slipping && !this.worn) {
            this.getVolumeSetting().setTarget((float)(Math.min(1.0, Math.abs(this.lRads - this.rRads) / 20.0) * this.clutching * 0.5));
        } else {
            this.getVolumeSetting().setTarget(0.0f);
            this.getVolumeSetting().setPosition(0.0f);
        }
        if (this.lastSlipping && !this.slipping && this.hasPin) {
            this.play(new SoundCommand(this.desc.getSlipStopSound()));
        }
        this.lastSlipping = this.slipping;
    }

    @Override
    @NotNull
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return (GuiScreen)new ClutchGui(player, (IInventory)this.inv, this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lmods/eln/mechanical/ClutchRender$ClutchLoopedSound;", "Lmods/eln/sound/LoopedSound;", "sound", "", "coord", "Lmods/eln/misc/Coordinate;", "(Lmods/eln/mechanical/ClutchRender;Ljava/lang/String;Lmods/eln/misc/Coordinate;)V", "getPitch", "", "getVolume", "Eln"})
    public final class ClutchLoopedSound
    extends LoopedSound {
        public ClutchLoopedSound(@NotNull String sound2, Coordinate coord) {
            Intrinsics.checkNotNullParameter(sound2, "sound");
            Intrinsics.checkNotNullParameter(coord, "coord");
            super(sound2, coord, null, 4, null);
        }

        @Override
        public float func_147655_f() {
            return (float)Math.max(0.1, Math.min(1.5, Math.abs(ClutchRender.this.getLRads() - ClutchRender.this.getRRads()) / 200.0));
        }

        @Override
        public float func_147653_e() {
            return ClutchRender.this.getVolumeSetting().getPosition();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.XP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ZP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

