/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import mods.eln.mechanical.CrankableShaftDescriptor;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.ShaftNetworkKt;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.ranges.RangesKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.IProcess;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lmods/eln/mechanical/CrankableShaftElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/mechanical/CrankableShaftDescriptor;", "getDesc", "()Lmods/eln/mechanical/CrankableShaftDescriptor;", "lastE", "", "playerInputEnergy", "shaftProcess", "Lmods/eln/sim/IProcess;", "coordonate", "Lmods/eln/misc/Coordinate;", "getWaila", "", "", "maybePublishE", "", "energy", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "side", "Lmods/eln/misc/Direction;", "vx", "", "vy", "vz", "Eln"})
public final class CrankableShaftElement
extends SimpleShaftElement {
    @NotNull
    private final CrankableShaftDescriptor desc;
    private double playerInputEnergy;
    private double lastE;
    @NotNull
    private final IProcess shaftProcess;

    public CrankableShaftElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        this.desc = (CrankableShaftDescriptor)desc_;
        this.shaftProcess = arg_0 -> CrankableShaftElement.shaftProcess$lambda$0(this, arg_0);
        this.electricalProcessList.add(this.shaftProcess);
    }

    @NotNull
    public final CrankableShaftDescriptor getDesc() {
        return this.desc;
    }

    private final void maybePublishE(double energy) {
        if (Math.abs(energy - this.lastE) / (double)this.desc.getNominalP() > 0.01) {
            this.lastE = energy;
            this.needPublish();
        }
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        this.playerInputEnergy += (double)this.desc.getNominalP() / 20.0;
        return false;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeDouble(this.lastE);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info = new LinkedHashMap();
        info.put("Energy", Utils.plotEnergy("", this.getShaft().getEnergy()));
        info.put("Speed", Utils.plotRads("", this.getShaft().getRads()));
        return info;
    }

    @Override
    @NotNull
    public Coordinate coordonate() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        return transparentNode.coordinate;
    }

    private static final void shaftProcess$lambda$0(CrankableShaftElement this$0, double time) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.maybePublishE(this$0.playerInputEnergy / time);
        this$0.playerInputEnergy -= ShaftNetworkKt.getDefaultDrag() * RangesKt.coerceAtLeast(this$0.getShaft().getRads(), 1.0);
        if (this$0.getShaft().getRads() <= 20.0) {
            ShaftNetwork shaftNetwork = this$0.getShaft();
            shaftNetwork.setEnergy(shaftNetwork.getEnergy() + this$0.playerInputEnergy);
        }
        this$0.playerInputEnergy = 0.0;
    }
}

