/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.mechanical.StraightJointElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LinearFunction;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.ArraysKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.IProcess;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u001e\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lmods/eln/mechanical/FlyWheelElement;", "Lmods/eln/mechanical/StraightJointElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "flingProcess", "Lmods/eln/mechanical/FlyWheelElement$FlyWheelFlingProcess;", "getFlingProcess", "()Lmods/eln/mechanical/FlyWheelElement$FlyWheelFlingProcess;", "setFlingProcess", "(Lmods/eln/mechanical/FlyWheelElement$FlyWheelFlingProcess;)V", "shaftMass", "", "getShaftMass", "()D", "getWaila", "", "", "FlyWheelFlingProcess", "Eln"})
public final class FlyWheelElement
extends StraightJointElement {
    private final double shaftMass;
    @NotNull
    private FlyWheelFlingProcess flingProcess;

    public FlyWheelElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        Double d = Eln.flywheelMass;
        this.shaftMass = d == null ? 50.0 : d;
        this.flingProcess = new FlyWheelFlingProcess();
        this.slowProcessList.add(this.flingProcess);
    }

    @Override
    public double getShaftMass() {
        return this.shaftMass;
    }

    @NotNull
    public final FlyWheelFlingProcess getFlingProcess() {
        return this.flingProcess;
    }

    public final void setFlingProcess(@NotNull FlyWheelFlingProcess flyWheelFlingProcess) {
        Intrinsics.checkNotNullParameter(flyWheelFlingProcess, "<set-?>");
        this.flingProcess = flyWheelFlingProcess;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info = new LinkedHashMap();
        info.put("Speed", Utils.plotRads("", this.getShaft().getRads()));
        info.put("Energy", Utils.plotEnergy("", this.getShaft().getEnergy()));
        return info;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0006\u0010\u001a\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u001b"}, d2={"Lmods/eln/mechanical/FlyWheelElement$FlyWheelFlingProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/mechanical/FlyWheelElement;)V", "damageF", "Lmods/eln/misc/LinearFunction;", "getDamageF", "()Lmods/eln/misc/LinearFunction;", "interval", "", "getInterval", "()D", "minRads", "getMinRads", "timer", "getTimer", "setTimer", "(D)V", "velocityF", "getVelocityF", "xzTolerance", "getXzTolerance", "yTolerance", "getYTolerance", "process", "", "time", "slowProcess", "Eln"})
    public final class FlyWheelFlingProcess
    implements IProcess {
        private final double interval;
        private final double yTolerance;
        private final double xzTolerance;
        private final double minRads;
        @NotNull
        private final LinearFunction velocityF = new LinearFunction(0.0f, 0.0f, 250.0f, 10.0f);
        @NotNull
        private final LinearFunction damageF = new LinearFunction(5.0f, 1.0f, 250.0f, 10.0f);
        private double timer;

        public FlyWheelFlingProcess() {
            this.interval = 0.05;
            this.yTolerance = 1.0;
            this.xzTolerance = 0.5;
            this.minRads = 5.0;
        }

        public final double getInterval() {
            return this.interval;
        }

        public final double getYTolerance() {
            return this.yTolerance;
        }

        public final double getXzTolerance() {
            return this.xzTolerance;
        }

        public final double getMinRads() {
            return this.minRads;
        }

        @NotNull
        public final LinearFunction getVelocityF() {
            return this.velocityF;
        }

        @NotNull
        public final LinearFunction getDamageF() {
            return this.damageF;
        }

        public final double getTimer() {
            return this.timer;
        }

        public final void setTimer(double d) {
            this.timer = d;
        }

        @Override
        public void process(double time) {
            this.timer += time;
            if (this.timer >= this.interval) {
                this.timer = 0.0;
                this.slowProcess();
            }
        }

        public final void slowProcess() {
            double rads = FlyWheelElement.this.getShaft().getRads();
            if (rads < this.minRads) {
                return;
            }
            Coordinate coord = FlyWheelElement.this.coordinate();
            List objects = coord.world().func_72872_a(Entity.class, coord.getAxisAlignedBB(1));
            for (Object obj : objects) {
                Object[] objectArray;
                Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type net.minecraft.entity.Entity");
                Entity ent = (Entity)obj;
                String string = "FPP.sP: considering %s";
                Object[] objectArray2 = new Object[]{ent};
                String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
                Utils.println(string2);
                double dx = Math.abs(ent.field_70165_t - (double)coord.x - 0.5);
                double dy = Math.abs(ent.field_70163_u - (double)coord.y - 1.0);
                double dz = Math.abs(ent.field_70161_v - (double)coord.z - 0.5);
                if (dy > this.yTolerance) {
                    Utils.println("FPP.sP: dy out of range (" + dy + "; c.y " + coord.y + " e.y" + ent.field_70163_u + "): " + ent);
                    continue;
                }
                if (dx > this.xzTolerance) {
                    Utils.println("FPP.sP: dx out of range (" + dx + "; c.x " + coord.x + " e.x" + ent.field_70165_t + "): " + ent);
                    continue;
                }
                if (dz > this.xzTolerance) {
                    Utils.println("FPP.sP: dz out of range (" + dz + "; c.z " + coord.z + " e.z" + ent.field_70161_v + "): " + ent);
                    continue;
                }
                double mag = this.velocityF.getValue(rads);
                switch (WhenMappings.$EnumSwitchMapping$0[FlyWheelElement.this.front.ordinal()]) {
                    case 1: 
                    case 2: {
                        Object[] objectArray3 = new Double[]{0.0, mag * 0.1, mag};
                        objectArray = objectArray3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        Object[] objectArray3 = new Double[]{mag, mag * 0.1, 0.0};
                        objectArray = objectArray3;
                        break;
                    }
                    default: {
                        Object[] objectArray3 = new Double[]{0.0, mag, 0.0};
                        objectArray = objectArray3;
                    }
                }
                Object[] vel = objectArray;
                ent.func_70024_g(vel[0].doubleValue(), vel[1].doubleValue(), vel[2].doubleValue());
                int dmg = (int)this.damageF.getValue(rads);
                if (ent instanceof EntityPlayer) {
                    Entity ply = ent;
                    if (!((EntityPlayer)ply).field_71075_bZ.field_75098_d) {
                        ent.func_70024_g(vel[0].doubleValue(), vel[1].doubleValue(), vel[2].doubleValue());
                    }
                } else {
                    ent.func_70024_g(vel[0].doubleValue(), vel[1].doubleValue(), vel[2].doubleValue());
                }
                Utils.println("FFP.sP: ent " + ent + " flung " + ArraysKt.joinToString$default(vel, (CharSequence)",", null, null, 0, null, null, 62, null) + " for damage " + dmg);
                if (dmg <= 0) continue;
                ent.func_70097_a(new DamageSource("Flywheel"), (float)dmg);
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.values().length];
                try {
                    nArray[Direction.ZN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.ZP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.XN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.XP.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

