/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.mechanical.GeneratorDescriptor;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.ShaftNetworkKt;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002STB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000204H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0018\u0010@\u001a\u00020,2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0014\u0010A\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020C0BH\u0016J\u000e\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020 J\u0010\u0010F\u001a\u00020C2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010G\u001a\u0002042\u0006\u0010H\u001a\u00020IH\u0016J0\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010:\u001a\u00020;2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020OH\u0016J\u0010\u0010R\u001a\u00020C2\u0006\u0010:\u001a\u00020;H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u0018\u0010'\u001a\u00060(R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006U"}, d2={"Lmods/eln/mechanical/GeneratorElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/mechanical/GeneratorDescriptor;", "getDesc", "()Lmods/eln/mechanical/GeneratorDescriptor;", "electricalPowerSource", "Lmods/eln/sim/mna/component/VoltageSource;", "getElectricalPowerSource$Eln", "()Lmods/eln/sim/mna/component/VoltageSource;", "electricalProcess", "Lmods/eln/mechanical/GeneratorElement$GeneratorElectricalProcess;", "getElectricalProcess$Eln", "()Lmods/eln/mechanical/GeneratorElement$GeneratorElectricalProcess;", "heater", "Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "getHeater$Eln", "()Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "inputLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getInputLoad$Eln", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "inputToPositiveResistor", "Lmods/eln/sim/mna/component/Resistor;", "getInputToPositiveResistor$Eln", "()Lmods/eln/sim/mna/component/Resistor;", "lastE", "", "getLastE", "()D", "setLastE", "(D)V", "positiveLoad", "getPositiveLoad$Eln", "shaftProcess", "Lmods/eln/mechanical/GeneratorElement$GeneratorShaftProcess;", "getShaftProcess$Eln", "()Lmods/eln/mechanical/GeneratorElement$GeneratorShaftProcess;", "thermal", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermal$Eln", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "thermalLoadWatchDog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalLoadWatchDog$Eln", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "connectJob", "", "coordonate", "Lmods/eln/misc/Coordinate;", "disconnectJob", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getThermalLoad", "getWaila", "", "", "maybePublishE", "E", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "thermoMeterString", "GeneratorElectricalProcess", "GeneratorShaftProcess", "Eln"})
public final class GeneratorElement
extends SimpleShaftElement {
    @NotNull
    private final GeneratorDescriptor desc;
    @NotNull
    private final NbtElectricalLoad inputLoad;
    @NotNull
    private final NbtElectricalLoad positiveLoad;
    @NotNull
    private final Resistor inputToPositiveResistor;
    @NotNull
    private final VoltageSource electricalPowerSource;
    @NotNull
    private final GeneratorElectricalProcess electricalProcess;
    @NotNull
    private final GeneratorShaftProcess shaftProcess;
    @NotNull
    private final NbtThermalLoad thermal;
    @NotNull
    private final ElectricalLoadHeatThermalLoad heater;
    @NotNull
    private final ThermalLoadWatchDog thermalLoadWatchDog;
    private double lastE;

    public GeneratorElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        this.desc = (GeneratorDescriptor)desc_;
        this.inputLoad = new NbtElectricalLoad("inputLoad");
        this.positiveLoad = new NbtElectricalLoad("positiveLoad");
        this.inputToPositiveResistor = new Resistor(this.inputLoad, this.positiveLoad);
        this.electricalPowerSource = new VoltageSource("PowerSource", this.positiveLoad, null);
        this.electricalProcess = new GeneratorElectricalProcess();
        this.shaftProcess = new GeneratorShaftProcess();
        this.thermal = new NbtThermalLoad("thermal");
        this.thermalLoadWatchDog = new ThermalLoadWatchDog(this.thermal);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.inputLoad);
        this.electricalComponentList.add(this.electricalPowerSource);
        this.electricalComponentList.add(this.inputToPositiveResistor);
        this.electricalProcessList.add(this.shaftProcess);
        this.desc.getCable().applyTo(this.inputLoad);
        this.desc.getCable().applyTo(this.inputToPositiveResistor);
        this.desc.getCable().applyTo(this.positiveLoad);
        this.desc.getThermalLoadInitializer().applyTo(this.thermal);
        this.desc.getThermalLoadInitializer().applyTo(this.thermalLoadWatchDog);
        this.thermal.setAsSlow();
        this.thermalLoadList.add(this.thermal);
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type mods.eln.mechanical.ShaftElement");
        this.thermalLoadWatchDog.setDestroys(new WorldExplosion(this).machineExplosion());
        this.slowProcessList.add(this.thermalLoadWatchDog);
        this.heater = new ElectricalLoadHeatThermalLoad(this.inputLoad, this.thermal);
        this.thermalFastProcessList.add(this.heater);
    }

    @NotNull
    public final GeneratorDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final NbtElectricalLoad getInputLoad$Eln() {
        return this.inputLoad;
    }

    @NotNull
    public final NbtElectricalLoad getPositiveLoad$Eln() {
        return this.positiveLoad;
    }

    @NotNull
    public final Resistor getInputToPositiveResistor$Eln() {
        return this.inputToPositiveResistor;
    }

    @NotNull
    public final VoltageSource getElectricalPowerSource$Eln() {
        return this.electricalPowerSource;
    }

    @NotNull
    public final GeneratorElectricalProcess getElectricalProcess$Eln() {
        return this.electricalProcess;
    }

    @NotNull
    public final GeneratorShaftProcess getShaftProcess$Eln() {
        return this.shaftProcess;
    }

    @NotNull
    public final NbtThermalLoad getThermal$Eln() {
        return this.thermal;
    }

    @NotNull
    public final ElectricalLoadHeatThermalLoad getHeater$Eln() {
        return this.heater;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalLoadWatchDog$Eln() {
        return this.thermalLoadWatchDog;
    }

    public final double getLastE() {
        return this.lastE;
    }

    public final void setLastE(double d) {
        this.lastE = d;
    }

    public final void maybePublishE(double E) {
        if (Math.abs(E - this.lastE) / (double)this.desc.getNominalP() > 0.01) {
            this.lastE = E;
            this.needPublish();
        }
    }

    @Override
    public void connectJob() {
        super.connectJob();
        Eln.simulator.mna.addProcess(this.electricalProcess);
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.electricalProcess);
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return null;
        }
        Direction direction = side;
        return direction == this.front ? (ElectricalLoad)this.inputLoad : (direction == this.front.back() ? (ElectricalLoad)this.inputLoad : null);
    }

    @Override
    @NotNull
    public NbtThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.thermal;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == LRDU.Down && (side == this.front || side == this.front.back())) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotER(this.getShaft().getEnergy(), this.getShaft().getRads()) + Utils.plotUIP(this.electricalPowerSource.getVoltage(), this.electricalPowerSource.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotCelsius("T", this.thermal.getTemperature());
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeDouble(this.lastE);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info = new LinkedHashMap();
        info.put("Energy", Utils.plotEnergy("", this.getShaft().getEnergy()));
        info.put("Speed", Utils.plotRads("", this.getShaft().getRads()));
        if (Eln.wailaEasyMode) {
            info.put("Voltage", Utils.plotVolt("", this.electricalPowerSource.getVoltage()));
            info.put("Current", Utils.plotAmpere("", this.electricalPowerSource.getCurrent()));
            info.put("Temperature", Utils.plotCelsius("", this.thermal.getTemperature()));
        }
        return info;
    }

    @Override
    @NotNull
    public Coordinate coordonate() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        return transparentNode.coordinate;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lmods/eln/mechanical/GeneratorElement$GeneratorElectricalProcess;", "Lmods/eln/sim/IProcess;", "Lmods/eln/sim/mna/misc/IRootSystemPreStepProcess;", "(Lmods/eln/mechanical/GeneratorElement;)V", "process", "", "time", "", "rootSystemPreStepProcess", "Eln"})
    public final class GeneratorElectricalProcess
    implements IProcess,
    IRootSystemPreStepProcess {
        @Override
        public void process(double time) {
            double targetU = GeneratorElement.this.getDesc().getRtoU().getValue(GeneratorElement.this.getShaft().getRads());
            SubSystem.Thevenin th = GeneratorElement.this.getPositiveLoad$Eln().getSubSystem().getTh(GeneratorElement.this.getPositiveLoad$Eln(), GeneratorElement.this.getElectricalPowerSource$Eln());
            double Ut = 0.0;
            if (targetU < th.voltage) {
                Ut = th.voltage * 0.999 + targetU * 0.001;
            } else if (th.isHighImpedance()) {
                Ut = targetU;
            } else {
                double a = 1.0 / th.resistance;
                double b = (double)GeneratorElement.this.getDesc().getPowerOutPerDeltaU() - th.voltage / th.resistance;
                double c = (double)(-GeneratorElement.this.getDesc().getPowerOutPerDeltaU()) * targetU;
                Ut = (-b + Math.sqrt(b * b - (double)4 * a * c)) / ((double)2 * a);
            }
            GeneratorElement.this.getElectricalPowerSource$Eln().setVoltage(Ut);
        }

        @Override
        public void rootSystemPreStepProcess() {
            this.process(0.0);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmods/eln/mechanical/GeneratorElement$GeneratorShaftProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/mechanical/GeneratorElement;)V", "powerFraction", "", "process", "", "time", "", "Eln"})
    public final class GeneratorShaftProcess
    implements IProcess {
        private float powerFraction;

        @Override
        public void process(double time) {
            double p = GeneratorElement.this.getElectricalPowerSource$Eln().getPower();
            this.powerFraction = (float)(p / (double)GeneratorElement.this.getDesc().getNominalP());
            double E = p * time;
            if (Double.isNaN(E)) {
                E = 0.0;
            }
            if (E < 0.0) {
                E *= 0.75;
            }
            GeneratorElement.this.maybePublishE(E / time);
            ShaftNetwork shaftNetwork = GeneratorElement.this.getShaft();
            shaftNetwork.setEnergy(shaftNetwork.getEnergy() - (E += ShaftNetworkKt.getDefaultDrag() * Math.max(GeneratorElement.this.getShaft().getRads(), 1.0)) * GeneratorElement.this.getDesc().getGenerationEfficiency());
            GeneratorElement.this.getThermal$Eln().movePowerTo(E * (1.0 - GeneratorElement.this.getDesc().getGenerationEfficiency()));
        }
    }
}

