/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.awt.Color;
import java.io.DataInputStream;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.mechanical.GeneratorDescriptor;
import mods.eln.mechanical.ShaftRender;
import mods.eln.misc.Direction;
import mods.eln.misc.HSLColor;
import mods.eln.misc.HSLColorKt;
import mods.eln.misc.LRDU;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.jvm.functions.Function0;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u001eH\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0016R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0013\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lmods/eln/mechanical/GeneratorRender;", "Lmods/eln/mechanical/ShaftRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "cableRender", "Lmods/eln/cable/CableRenderDescriptor;", "mods.eln.shadow.kotlin.jvm.PlatformType", "getCableRender", "()Lmods/eln/cable/CableRenderDescriptor;", "desc", "Lmods/eln/mechanical/GeneratorDescriptor;", "getDesc", "()Lmods/eln/mechanical/GeneratorDescriptor;", "getEntity", "()Lmods/eln/node/transparent/TransparentNodeEntity;", "ledColorBase", "", "Lmods/eln/misc/HSLColor;", "getLedColorBase", "()[Lmods/eln/misc/HSLColor;", "[Lmods/eln/misc/HSLColor;", "ledColors", "Ljava/awt/Color;", "getLedColors", "()[Ljava/awt/Color;", "[Ljava/awt/Color;", "calcPower", "", "power", "", "draw", "getCableRenderSide", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "Eln"})
public final class GeneratorRender
extends ShaftRender {
    @NotNull
    private final TransparentNodeEntity entity;
    private final CableRenderDescriptor cableRender;
    @NotNull
    private final GeneratorDescriptor desc;
    @NotNull
    private final Color[] ledColors;
    @NotNull
    private final HSLColor[] ledColorBase;

    public GeneratorRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(entity, desc_);
        this.entity = entity;
        this.cableRender = Eln.instance.stdCableRender3200V;
        this.desc = (GeneratorDescriptor)desc_;
        Object[] objectArray = new Color[7];
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        this.ledColors = objectArray;
        objectArray = new HSLColor[]{HSLColorKt.getGREEN(), HSLColorKt.getGREEN(), HSLColorKt.getGREEN(), HSLColorKt.getGREEN(), HSLColorKt.getYELLOW(), HSLColorKt.getRED(), HSLColorKt.getRED()};
        this.ledColorBase = objectArray;
    }

    @NotNull
    public final TransparentNodeEntity getEntity() {
        return this.entity;
    }

    @Override
    public CableRenderDescriptor getCableRender() {
        return this.cableRender;
    }

    @NotNull
    public final GeneratorDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final Color[] getLedColors() {
        return this.ledColors;
    }

    @NotNull
    public final HSLColor[] getLedColorBase() {
        return this.ledColorBase;
    }

    public final void calcPower(double power2) {
        if (power2 < 0.0) {
            for (int i = 1; i < 7; ++i) {
                Intrinsics.checkNotNullExpressionValue(Color.black, "black");
            }
            this.ledColors[0] = HSLColorKt.getRED().adjustLuminanceClamped((float)(-power2 / (double)this.desc.getNominalP() * (double)4 * (double)100), 0.0f, 60.0f);
        } else {
            float slice = this.desc.getNominalP() / (float)5;
            double remainder = power2;
            for (int i = 0; i < 7; ++i) {
                this.ledColors[i] = this.ledColorBase[i].adjustLuminanceClamped((float)(remainder / (double)slice * (double)100), 0.0f, 65.0f);
                remainder -= (double)slice;
            }
        }
    }

    @Override
    public void draw() {
        this.draw(new Function0<Unit>(this){
            final /* synthetic */ GeneratorRender this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEachIndexed$iv;
                Color[] colorArray = this.this$0.getLedColors();
                GeneratorRender generatorRender = this.this$0;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void color;
                    int n = index$iv++;
                    void var8_8 = item$iv;
                    int i = n;
                    boolean bl = false;
                    GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
                    generatorRender.getDesc().getPowerLights()[i].draw();
                }
            }
        });
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRenderSide(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == LRDU.Down && side == this.front) {
            return Eln.instance.stdCableRender3200V;
        }
        return null;
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        double power2 = stream.readDouble();
        this.calcPower(power2);
        this.getVolumeSetting().setTarget(0.05f + (float)Math.abs(power2 / (double)this.desc.getNominalP()) / 4.0f);
    }
}

