/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.mechanical.MotorDescriptor;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.ShaftNetworkKt;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002STB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000204H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0018\u0010@\u001a\u00020&2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0014\u0010A\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020C0BH\u0016J\u000e\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020\u0014J\u0010\u0010F\u001a\u00020C2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010G\u001a\u0002042\u0006\u0010H\u001a\u00020IH\u0016J0\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010:\u001a\u00020;2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020OH\u0016J\u0010\u0010R\u001a\u00020C2\u0006\u0010:\u001a\u00020;H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u00060\"R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010 R\u0014\u0010/\u001a\u000200X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006U"}, d2={"Lmods/eln/mechanical/MotorElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/mechanical/MotorDescriptor;", "getDesc", "()Lmods/eln/mechanical/MotorDescriptor;", "electricalProcess", "Lmods/eln/mechanical/MotorElement$MotorElectricalProcess;", "getElectricalProcess$Eln", "()Lmods/eln/mechanical/MotorElement$MotorElectricalProcess;", "heater", "Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "getHeater$Eln", "()Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "lastP", "", "getLastP", "()D", "setLastP", "(D)V", "powerSource", "Lmods/eln/sim/mna/component/VoltageSource;", "getPowerSource$Eln", "()Lmods/eln/sim/mna/component/VoltageSource;", "shaftLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getShaftLoad$Eln", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "shaftProcess", "Lmods/eln/mechanical/MotorElement$MotorShaftProcess;", "getShaftProcess$Eln", "()Lmods/eln/mechanical/MotorElement$MotorShaftProcess;", "thermal", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermal$Eln", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalWatchdog$Eln", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "wireLoad", "getWireLoad$Eln", "wireShaftResistor", "Lmods/eln/sim/mna/component/Resistor;", "getWireShaftResistor$Eln", "()Lmods/eln/sim/mna/component/Resistor;", "connectJob", "", "coordonate", "Lmods/eln/misc/Coordinate;", "disconnectJob", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getThermalLoad", "getWaila", "", "", "maybePublishP", "P", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "thermoMeterString", "MotorElectricalProcess", "MotorShaftProcess", "Eln"})
public final class MotorElement
extends SimpleShaftElement {
    @NotNull
    private final MotorDescriptor desc;
    @NotNull
    private final NbtElectricalLoad wireLoad;
    @NotNull
    private final NbtElectricalLoad shaftLoad;
    @NotNull
    private final Resistor wireShaftResistor;
    @NotNull
    private final VoltageSource powerSource;
    @NotNull
    private final MotorElectricalProcess electricalProcess;
    @NotNull
    private final MotorShaftProcess shaftProcess;
    @NotNull
    private final NbtThermalLoad thermal;
    @NotNull
    private final ElectricalLoadHeatThermalLoad heater;
    @NotNull
    private final ThermalLoadWatchDog thermalWatchdog;
    private double lastP;

    public MotorElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        this.desc = (MotorDescriptor)desc_;
        this.wireLoad = new NbtElectricalLoad("wireLoad");
        this.shaftLoad = new NbtElectricalLoad("shaftLoad");
        this.wireShaftResistor = new Resistor(this.wireLoad, this.shaftLoad);
        this.powerSource = new VoltageSource("powerSource", this.shaftLoad, null);
        this.electricalProcess = new MotorElectricalProcess();
        this.shaftProcess = new MotorShaftProcess();
        this.thermal = new NbtThermalLoad("thermal");
        this.thermalWatchdog = new ThermalLoadWatchDog(this.thermal);
        Object[] objectArray = new NbtElectricalLoad[]{this.wireLoad, this.shaftLoad};
        CollectionsKt.addAll((Collection)this.electricalLoadList, objectArray);
        objectArray = new Bipole[]{this.wireShaftResistor, this.powerSource};
        CollectionsKt.addAll((Collection)this.electricalComponentList, objectArray);
        this.electricalProcessList.add(this.shaftProcess);
        this.desc.getCable().applyTo(this.wireLoad);
        this.desc.getCable().applyTo(this.shaftLoad);
        this.desc.getCable().applyTo(this.wireShaftResistor);
        this.desc.getThermalLoadInitializer().applyTo(this.thermal);
        this.desc.getThermalLoadInitializer().applyTo(this.thermalWatchdog);
        this.thermal.setAsSlow();
        this.thermalLoadList.add(this.thermal);
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type mods.eln.mechanical.ShaftElement");
        this.thermalWatchdog.setDestroys(new WorldExplosion(this).machineExplosion());
        this.slowProcessList.add(this.thermalWatchdog);
        this.heater = new ElectricalLoadHeatThermalLoad(this.wireLoad, this.thermal);
        this.thermalFastProcessList.add(this.heater);
    }

    @NotNull
    public final MotorDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final NbtElectricalLoad getWireLoad$Eln() {
        return this.wireLoad;
    }

    @NotNull
    public final NbtElectricalLoad getShaftLoad$Eln() {
        return this.shaftLoad;
    }

    @NotNull
    public final Resistor getWireShaftResistor$Eln() {
        return this.wireShaftResistor;
    }

    @NotNull
    public final VoltageSource getPowerSource$Eln() {
        return this.powerSource;
    }

    @NotNull
    public final MotorElectricalProcess getElectricalProcess$Eln() {
        return this.electricalProcess;
    }

    @NotNull
    public final MotorShaftProcess getShaftProcess$Eln() {
        return this.shaftProcess;
    }

    @NotNull
    public final NbtThermalLoad getThermal$Eln() {
        return this.thermal;
    }

    @NotNull
    public final ElectricalLoadHeatThermalLoad getHeater$Eln() {
        return this.heater;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalWatchdog$Eln() {
        return this.thermalWatchdog;
    }

    public final double getLastP() {
        return this.lastP;
    }

    public final void setLastP(double d) {
        this.lastP = d;
    }

    public final void maybePublishP(double P) {
        if (Math.abs(P - this.lastP) / (double)this.desc.getNominalP() > 0.01) {
            this.lastP = P;
            this.needPublish();
        }
    }

    @Override
    public void connectJob() {
        super.connectJob();
        Eln.simulator.mna.addProcess(this.electricalProcess);
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.electricalProcess);
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return null;
        }
        Direction direction = side;
        return direction == this.front ? (ElectricalLoad)this.wireLoad : (direction == this.front.back() ? (ElectricalLoad)this.wireLoad : null);
    }

    @Override
    @NotNull
    public NbtThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.thermal;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == LRDU.Down && (side == this.front || side == this.front.back())) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotER(this.getShaft().getEnergy(), this.getShaft().getRads()) + Utils.plotUIP(this.powerSource.getVoltage(), this.powerSource.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotCelsius("T", this.thermal.getTemperature());
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeDouble(this.lastP);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info = new LinkedHashMap();
        info.put("Energy", Utils.plotEnergy("", this.getShaft().getEnergy()));
        info.put("Speed", Utils.plotRads("", this.getShaft().getRads()));
        if (Eln.wailaEasyMode) {
            info.put("Voltage", Utils.plotVolt("", this.powerSource.getVoltage()));
            info.put("Current", Utils.plotAmpere("", this.powerSource.getCurrent()));
            info.put("Temperature", Utils.plotCelsius("", this.thermal.getTemperature()));
        }
        return info;
    }

    @Override
    @NotNull
    public Coordinate coordonate() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        return transparentNode.coordinate;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lmods/eln/mechanical/MotorElement$MotorElectricalProcess;", "Lmods/eln/sim/IProcess;", "Lmods/eln/sim/mna/misc/IRootSystemPreStepProcess;", "(Lmods/eln/mechanical/MotorElement;)V", "process", "", "time", "", "rootSystemPreStepProcess", "Eln"})
    public final class MotorElectricalProcess
    implements IProcess,
    IRootSystemPreStepProcess {
        @Override
        public void process(double time) {
            double noTorqueU = MotorElement.this.getDesc().getRadsToU().getValue(MotorElement.this.getShaft().getRads());
            SubSystem.Thevenin th = MotorElement.this.getWireLoad$Eln().getSubSystem().getTh(MotorElement.this.getWireLoad$Eln(), MotorElement.this.getPowerSource$Eln());
            if (Double.isNaN(th.voltage)) {
                th.voltage = noTorqueU;
                th.resistance = 1.0E9;
            }
            double U = 0.0;
            if (noTorqueU < th.voltage) {
                U = th.voltage * 0.997 + noTorqueU * 0.003;
            } else if (th.isHighImpedance()) {
                U = noTorqueU;
            } else {
                double a = 1.0 / th.resistance;
                double b = (double)MotorElement.this.getDesc().getElecPPerDU() - th.voltage / th.resistance;
                double c = (double)(-MotorElement.this.getDesc().getElecPPerDU()) * noTorqueU;
                U = (-b + Math.sqrt(b * b - (double)4 * a * c)) / ((double)2 * a);
            }
            MotorElement.this.getPowerSource$Eln().setVoltage(U);
        }

        @Override
        public void rootSystemPreStepProcess() {
            this.process(0.0);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lmods/eln/mechanical/MotorElement$MotorShaftProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/mechanical/MotorElement;)V", "process", "", "time", "", "Eln"})
    public final class MotorShaftProcess
    implements IProcess {
        @Override
        public void process(double time) {
            double p = MotorElement.this.getPowerSource$Eln().getPower();
            double E = -p * time;
            if (Double.isNaN(E)) {
                E = 0.0;
            }
            if (E < 0.0) {
                E *= 10.0;
            }
            MotorElement.this.maybePublishP(E / time);
            ShaftNetwork shaftNetwork = MotorElement.this.getShaft();
            shaftNetwork.setEnergy(shaftNetwork.getEnergy() + (E -= ShaftNetworkKt.getDefaultDrag() * Math.max(MotorElement.this.getShaft().getRads(), 1.0)) * MotorElement.this.getDesc().getEfficiency());
            MotorElement.this.getThermal$Eln().movePowerTo(E * (1.0 - MotorElement.this.getDesc().getEfficiency()));
        }
    }
}

