/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.awt.Color;
import java.io.DataInputStream;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.mechanical.MotorDescriptor;
import mods.eln.mechanical.ShaftRender;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.HSLColor;
import mods.eln.misc.HSLColorKt;
import mods.eln.misc.LRDU;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.jvm.functions.Function0;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sound.LoopedSound;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0013\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006+"}, d2={"Lmods/eln/mechanical/MotorRender;", "Lmods/eln/mechanical/ShaftRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "cableRender", "Lmods/eln/cable/CableRenderDescriptor;", "mods.eln.shadow.kotlin.jvm.PlatformType", "getCableRender", "()Lmods/eln/cable/CableRenderDescriptor;", "desc", "Lmods/eln/mechanical/MotorDescriptor;", "getDesc", "()Lmods/eln/mechanical/MotorDescriptor;", "getEntity", "()Lmods/eln/node/transparent/TransparentNodeEntity;", "ledColorBase", "", "Lmods/eln/misc/HSLColor;", "getLedColorBase", "()[Lmods/eln/misc/HSLColor;", "[Lmods/eln/misc/HSLColor;", "ledColors", "Ljava/awt/Color;", "getLedColors", "()[Ljava/awt/Color;", "[Ljava/awt/Color;", "draw", "", "getCableRenderSide", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "setPower", "power", "", "MotorLoopedSound", "Eln"})
public final class MotorRender
extends ShaftRender {
    @NotNull
    private final TransparentNodeEntity entity;
    private final CableRenderDescriptor cableRender;
    @NotNull
    private final MotorDescriptor desc;
    @NotNull
    private final Color[] ledColors;
    @NotNull
    private final HSLColor[] ledColorBase;

    public MotorRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(entity, desc_);
        this.entity = entity;
        this.cableRender = Eln.instance.stdCableRender3200V;
        this.desc = (MotorDescriptor)desc_;
        Object[] objectArray = new Color[7];
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        this.ledColors = objectArray;
        objectArray = new HSLColor[]{HSLColorKt.getGREEN(), HSLColorKt.getGREEN(), HSLColorKt.getGREEN(), HSLColorKt.getGREEN(), HSLColorKt.getYELLOW(), HSLColorKt.getRED(), HSLColorKt.getRED()};
        this.ledColorBase = objectArray;
        this.addLoopedSound(new MotorLoopedSound(this.desc.getCustomSound(), this.coordinate()));
        this.getMask().set(LRDU.Down, true);
    }

    @NotNull
    public final TransparentNodeEntity getEntity() {
        return this.entity;
    }

    @Override
    public CableRenderDescriptor getCableRender() {
        return this.cableRender;
    }

    @NotNull
    public final MotorDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final Color[] getLedColors() {
        return this.ledColors;
    }

    @NotNull
    public final HSLColor[] getLedColorBase() {
        return this.ledColorBase;
    }

    public final void setPower(double power2) {
        if (power2 < 0.0) {
            for (int i = 1; i < 7; ++i) {
                Intrinsics.checkNotNullExpressionValue(Color.black, "black");
            }
            this.ledColors[0] = HSLColorKt.getRED().adjustLuminanceClamped((float)(-power2 / (double)this.desc.getNominalP() * (double)400), 0.0f, 60.0f);
        } else {
            float slice = this.desc.getMaxP() / (float)5;
            double current = power2;
            for (int i = 0; i < 7; ++i) {
                this.ledColors[i] = this.ledColorBase[i].adjustLuminanceClamped((float)(current / (double)slice * (double)100), 0.0f, 65.0f);
                current -= (double)slice;
            }
        }
    }

    @Override
    public void draw() {
        this.draw(new Function0<Unit>(this){
            final /* synthetic */ MotorRender this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEachIndexed$iv;
                Color[] colorArray = this.this$0.getLedColors();
                MotorRender motorRender = this.this$0;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void color;
                    int n = index$iv++;
                    void var8_8 = item$iv;
                    int i = n;
                    boolean bl = false;
                    GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
                    motorRender.getDesc().getLeds()[i].draw();
                }
            }
        });
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRenderSide(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == LRDU.Down && side == this.front) {
            return Eln.instance.stdCableRender3200V;
        }
        return null;
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        double power2 = stream.readDouble();
        this.setPower(power2);
        this.getVolumeSetting().setTarget(Math.min(1.0f, (float)Math.abs(power2 / (double)this.desc.getMaxP())) / 4.0f);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lmods/eln/mechanical/MotorRender$MotorLoopedSound;", "Lmods/eln/sound/LoopedSound;", "sound", "", "coord", "Lmods/eln/misc/Coordinate;", "(Lmods/eln/mechanical/MotorRender;Ljava/lang/String;Lmods/eln/misc/Coordinate;)V", "getPitch", "", "getVolume", "Eln"})
    public final class MotorLoopedSound
    extends LoopedSound {
        public MotorLoopedSound(@NotNull String sound2, Coordinate coord) {
            Intrinsics.checkNotNullParameter(sound2, "sound");
            Intrinsics.checkNotNullParameter(coord, "coord");
            super(sound2, coord, null, 4, null);
        }

        @Override
        public float func_147655_f() {
            return (float)Math.max(0.05, MotorRender.this.getRads() * (double)2 / (double)MotorRender.this.getDesc().getNominalRads());
        }

        @Override
        public float func_147653_e() {
            return MotorRender.this.getVolumeSetting().getPosition();
        }
    }
}

