/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import mods.eln.mechanical.ShaftElement;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.ShaftPart;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J?\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0006\u0010 \u001a\u00020\u0014J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006#"}, d2={"Lmods/eln/mechanical/ShaftNeighbour;", "", "thisPart", "Lmods/eln/mechanical/ShaftPart;", "thisShaft", "Lmods/eln/mechanical/ShaftNetwork;", "side", "Lmods/eln/misc/Direction;", "otherPart", "otherShaft", "(Lmods/eln/mechanical/ShaftPart;Lmods/eln/mechanical/ShaftNetwork;Lmods/eln/misc/Direction;Lmods/eln/mechanical/ShaftPart;Lmods/eln/mechanical/ShaftNetwork;)V", "getOtherPart", "()Lmods/eln/mechanical/ShaftPart;", "getOtherShaft", "()Lmods/eln/mechanical/ShaftNetwork;", "getSide", "()Lmods/eln/misc/Direction;", "getThisPart", "getThisShaft", "breakConnection", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "makeConnection", "toString", "", "Eln"})
public final class ShaftNeighbour {
    @NotNull
    private final ShaftPart thisPart;
    @Nullable
    private final ShaftNetwork thisShaft;
    @NotNull
    private final Direction side;
    @NotNull
    private final ShaftPart otherPart;
    @Nullable
    private final ShaftNetwork otherShaft;

    public ShaftNeighbour(@NotNull ShaftPart thisPart, @Nullable ShaftNetwork thisShaft, @NotNull Direction side, @NotNull ShaftPart otherPart, @Nullable ShaftNetwork otherShaft) {
        Intrinsics.checkNotNullParameter(thisPart, "thisPart");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(otherPart, "otherPart");
        this.thisPart = thisPart;
        this.thisShaft = thisShaft;
        this.side = side;
        this.otherPart = otherPart;
        this.otherShaft = otherShaft;
    }

    @NotNull
    public final ShaftPart getThisPart() {
        return this.thisPart;
    }

    @Nullable
    public final ShaftNetwork getThisShaft() {
        return this.thisShaft;
    }

    @NotNull
    public final Direction getSide() {
        return this.side;
    }

    @NotNull
    public final ShaftPart getOtherPart() {
        return this.otherPart;
    }

    @Nullable
    public final ShaftNetwork getOtherShaft() {
        return this.otherShaft;
    }

    public final void makeConnection() {
        ShaftNetwork otherNet;
        ShaftNetwork thisNet = this.thisPart.getElement().getShaft(this.thisPart.getSide());
        if (!Intrinsics.areEqual(thisNet, otherNet = this.otherPart.getElement().getShaft(this.otherPart.getSide()))) {
            Utils.println("ShaftNeighbour.makeConnection: WARNING: Not actually connected?");
        }
        ShaftElement shaftElement = this.thisPart.getElement();
        Direction direction = this.thisPart.getSide();
        ShaftNetwork shaftNetwork = thisNet;
        Intrinsics.checkNotNull(shaftNetwork);
        shaftElement.connectedOnSide(direction, shaftNetwork);
        ShaftElement shaftElement2 = this.otherPart.getElement();
        Direction direction2 = this.otherPart.getSide();
        ShaftNetwork shaftNetwork2 = otherNet;
        Intrinsics.checkNotNull(shaftNetwork2);
        shaftElement2.connectedOnSide(direction2, shaftNetwork2);
    }

    public final void breakConnection() {
        ShaftNetwork otherNet;
        ShaftNetwork thisNet = this.thisPart.getElement().getShaft(this.thisPart.getSide());
        if (!Intrinsics.areEqual(thisNet, otherNet = this.otherPart.getElement().getShaft(this.otherPart.getSide()))) {
            Utils.println("ShaftNeighbour.breakConnection: WARNING: Break already broken connection?");
        }
        this.thisPart.getElement().disconnectedOnSide(this.thisPart.getSide(), thisNet);
        this.otherPart.getElement().disconnectedOnSide(this.otherPart.getSide(), otherNet);
    }

    @NotNull
    public final ShaftPart component1() {
        return this.thisPart;
    }

    @Nullable
    public final ShaftNetwork component2() {
        return this.thisShaft;
    }

    @NotNull
    public final Direction component3() {
        return this.side;
    }

    @NotNull
    public final ShaftPart component4() {
        return this.otherPart;
    }

    @Nullable
    public final ShaftNetwork component5() {
        return this.otherShaft;
    }

    @NotNull
    public final ShaftNeighbour copy(@NotNull ShaftPart thisPart, @Nullable ShaftNetwork thisShaft, @NotNull Direction side, @NotNull ShaftPart otherPart, @Nullable ShaftNetwork otherShaft) {
        Intrinsics.checkNotNullParameter(thisPart, "thisPart");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(otherPart, "otherPart");
        return new ShaftNeighbour(thisPart, thisShaft, side, otherPart, otherShaft);
    }

    public static /* synthetic */ ShaftNeighbour copy$default(ShaftNeighbour shaftNeighbour, ShaftPart shaftPart, ShaftNetwork shaftNetwork, Direction direction, ShaftPart shaftPart2, ShaftNetwork shaftNetwork2, int n, Object object) {
        if ((n & 1) != 0) {
            shaftPart = shaftNeighbour.thisPart;
        }
        if ((n & 2) != 0) {
            shaftNetwork = shaftNeighbour.thisShaft;
        }
        if ((n & 4) != 0) {
            direction = shaftNeighbour.side;
        }
        if ((n & 8) != 0) {
            shaftPart2 = shaftNeighbour.otherPart;
        }
        if ((n & 0x10) != 0) {
            shaftNetwork2 = shaftNeighbour.otherShaft;
        }
        return shaftNeighbour.copy(shaftPart, shaftNetwork, direction, shaftPart2, shaftNetwork2);
    }

    @NotNull
    public String toString() {
        return "ShaftNeighbour(thisPart=" + this.thisPart + ", thisShaft=" + this.thisShaft + ", side=" + (Object)((Object)this.side) + ", otherPart=" + this.otherPart + ", otherShaft=" + this.otherShaft + ')';
    }

    public int hashCode() {
        int result = this.thisPart.hashCode();
        result = result * 31 + (this.thisShaft == null ? 0 : this.thisShaft.hashCode());
        result = result * 31 + this.side.hashCode();
        result = result * 31 + this.otherPart.hashCode();
        result = result * 31 + (this.otherShaft == null ? 0 : this.otherShaft.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShaftNeighbour)) {
            return false;
        }
        ShaftNeighbour shaftNeighbour = (ShaftNeighbour)other;
        if (!Intrinsics.areEqual(this.thisPart, shaftNeighbour.thisPart)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.thisShaft, shaftNeighbour.thisShaft)) {
            return false;
        }
        if (this.side != shaftNeighbour.side) {
            return false;
        }
        if (!Intrinsics.areEqual(this.otherPart, shaftNeighbour.otherPart)) {
            return false;
        }
        return Intrinsics.areEqual(this.otherShaft, shaftNeighbour.otherShaft);
    }
}

