/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.mechanical.ShaftElement;
import mods.eln.mechanical.ShaftNeighbour;
import mods.eln.mechanical.ShaftNetworkKt;
import mods.eln.mechanical.ShaftPart;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.node.NodeManager;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin._Assertions;
import mods.eln.shadow.kotlin.jvm.functions.Function1;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.process.destruct.DelayedDestruction;
import mods.eln.sim.process.destruct.WorldExplosion;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u000bB\u0005\u00a2\u0006\u0002\u0010\fJ\u0006\u0010,\u001a\u00020-J\u0016\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u00100\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0003J\u0016\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010/\u001a\u00020\u0003H\u0002J\u0010\u00104\u001a\u0002052\u0006\u0010\n\u001a\u00020\u0000H\u0016J\u0018\u00106\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u00010\u0003J\u0018\u00108\u001a\u00020-2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\r\u0010=\u001a\u00020-H\u0000\u00a2\u0006\u0002\b>J\u000e\u0010?\u001a\u00020-2\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010@\u001a\u00020-J\u0018\u0010A\u001a\u00020-2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0010\"\u0004\b\u001f\u0010\u0012R\u0014\u0010 \u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0010R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0019R$\u0010&\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0010\"\u0004\b(\u0010\u0012R\u001a\u0010)\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0010\"\u0004\b+\u0010\u0012\u00a8\u0006B"}, d2={"Lmods/eln/mechanical/ShaftNetwork;", "Lmods/eln/misc/INBTTReady;", "first", "Lmods/eln/mechanical/ShaftElement;", "side", "Lmods/eln/misc/Direction;", "(Lmods/eln/mechanical/ShaftElement;Lmods/eln/misc/Direction;)V", "sides", "", "(Lmods/eln/mechanical/ShaftElement;Ljava/util/Iterator;)V", "other", "(Lmods/eln/mechanical/ShaftNetwork;)V", "()V", "_mass", "", "get_mass", "()D", "set_mass", "(D)V", "_rads", "get_rads", "set_rads", "elements", "Ljava/util/HashSet;", "getElements", "()Ljava/util/HashSet;", "setElements", "(Ljava/util/HashSet;)V", "value", "energy", "getEnergy", "setEnergy", "mass", "getMass", "parts", "Lmods/eln/mechanical/ShaftPart;", "getParts", "v", "rads", "getRads", "setRads", "radsLastPublished", "getRadsLastPublished", "setRadsLastPublished", "afterSetRads", "", "connectShaft", "from", "disconnectShaft", "getNeighbours", "Ljava/util/ArrayList;", "Lmods/eln/mechanical/ShaftNeighbour;", "hasMergePrecedenceOver", "", "mergeShafts", "invoker", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "rebuildNetwork", "rebuildNetwork$Eln", "takeAll", "updateCache", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nShaftNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaftNetwork.kt\nmods/eln/mechanical/ShaftNetwork\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,387:1\n1855#2,2:388\n1855#2,2:390\n1855#2,2:394\n1855#2,2:396\n1855#2,2:398\n1855#2,2:400\n32#3,2:392\n*S KotlinDebug\n*F\n+ 1 ShaftNetwork.kt\nmods/eln/mechanical/ShaftNetwork\n*L\n43#1:388,2\n44#1:390,2\n64#1:394,2\n93#1:396,2\n258#1:398,2\n265#1:400,2\n53#1:392,2\n*E\n"})
public class ShaftNetwork
implements INBTTReady {
    @NotNull
    private final HashSet<ShaftPart> parts;
    @NotNull
    private HashSet<ShaftElement> elements;
    private double _mass;
    private double _rads;
    private double radsLastPublished;

    public ShaftNetwork() {
        this.parts = new HashSet();
        this.elements = new HashSet();
        this.radsLastPublished = this.getRads();
    }

    @NotNull
    public final HashSet<ShaftPart> getParts() {
        return this.parts;
    }

    @NotNull
    public final HashSet<ShaftElement> getElements() {
        return this.elements;
    }

    public final void setElements(@NotNull HashSet<ShaftElement> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.elements = hashSet;
    }

    public final double get_mass() {
        return this._mass;
    }

    public final void set_mass(double d) {
        this._mass = d;
    }

    public double getMass() {
        double d = this._mass;
        return !Double.isInfinite(d) && !Double.isNaN(d) ? this._mass : 0.0;
    }

    public final void updateCache() {
        Object it;
        Iterable $this$forEach$iv = this.parts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ShaftPart)element$iv;
            boolean bl = false;
            this.elements.add(((ShaftPart)it).getElement());
        }
        $this$forEach$iv = this.elements;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ShaftElement)element$iv;
            boolean bl = false;
            this._mass += it.getShaftMass();
        }
    }

    public ShaftNetwork(@NotNull ShaftElement first, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        this();
        this.parts.add(new ShaftPart(first, side));
        this.updateCache();
    }

    public ShaftNetwork(@NotNull ShaftElement first, @NotNull Iterator<? extends Direction> sides) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(sides, "sides");
        this();
        Iterator<? extends Direction> $this$forEach$iv = sides;
        boolean $i$f$forEach = false;
        Iterator<? extends Direction> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Direction element$iv;
            Direction it = element$iv = iterator2.next();
            boolean bl = false;
            this.parts.add(new ShaftPart(first, it));
        }
        this.updateCache();
    }

    public ShaftNetwork(@NotNull ShaftNetwork other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this();
        this.takeAll(other);
    }

    public final void takeAll(@NotNull ShaftNetwork other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Iterable $this$forEach$iv = other.parts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShaftPart it = (ShaftPart)element$iv;
            boolean bl = false;
            it.getElement().setShaft(it.getSide(), this);
        }
        this.parts.addAll((Collection<ShaftPart>)other.parts);
        other.parts.clear();
        this.updateCache();
    }

    public final double get_rads() {
        return this._rads;
    }

    public final void set_rads(double d) {
        this._rads = d;
    }

    public double getRads() {
        double d = this._rads;
        return !Double.isInfinite(d) && !Double.isNaN(d) ? this._rads : 0.0;
    }

    public void setRads(double v) {
        double d = v;
        if (!Double.isInfinite(d) && !Double.isNaN(d)) {
            this._rads = v;
        }
        this.afterSetRads();
    }

    public final double getRadsLastPublished() {
        return this.radsLastPublished;
    }

    public final void setRadsLastPublished(double d) {
        this.radsLastPublished = d;
    }

    public final double getEnergy() {
        double d = this.getMass();
        return !Double.isInfinite(d) && !Double.isNaN(d) && !Double.isInfinite(d = this.getRads()) && !Double.isNaN(d) ? this.getMass() * this.getRads() * this.getRads() * 0.5 * Eln.shaftEnergyFactor : 0.0;
    }

    public final void setEnergy(double value) {
        double d;
        if (value < 0.0 || !(!Double.isInfinite(d = value) && !Double.isNaN(d))) {
            this.setRads(0.0);
        } else {
            d = this.getMass();
            this.setRads(Math.sqrt((double)2 * value / ((!Double.isInfinite(d) && !Double.isNaN(d) ? this.getMass() : 0.0) * Eln.shaftEnergyFactor)));
        }
    }

    public final void afterSetRads() {
        if (this._rads < 0.0) {
            this._rads = 0.0;
        }
        if (this.radsLastPublished > this._rads * 1.05 || this.radsLastPublished < this._rads * 0.95) {
            Iterable $this$forEach$iv = this.elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShaftElement it = (ShaftElement)element$iv;
                boolean bl = false;
                it.needPublish();
            }
            this.radsLastPublished = this._rads;
        }
    }

    public boolean hasMergePrecedenceOver(@NotNull ShaftNetwork other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return false;
    }

    @NotNull
    public final ShaftNetwork mergeShafts(@NotNull ShaftNetwork other, @Nullable ShaftElement invoker) {
        boolean bl;
        Intrinsics.checkNotNullParameter(other, "other");
        boolean bl2 = bl = !Intrinsics.areEqual(other, this);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = "SN.ms(this=%s, %s, invoker=%s)";
        Object[] objectArray = new Object[]{this, other, invoker};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        Utils.println(string2);
        if (other.hasMergePrecedenceOver(this)) {
            string = "SN.mS: merge prec %s over %s";
            objectArray = new Object[]{other, this};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            Utils.println(string3);
            return other.mergeShafts(this, invoker);
        }
        boolean loadMerge = Loader.instance().getLoaderState() == LoaderState.SERVER_ABOUT_TO_START;
        double deltaRads = 0.0;
        double newEnergy = 0.0;
        if (!loadMerge) {
            deltaRads = Math.abs(this.getRads() - other.getRads());
            if (ShaftNetworkKt.wouldExplode(this, other) && invoker != null) {
                String string4 = "SN.mS: Bad matching, %s will explode";
                Object[] objectArray2 = new Object[]{invoker};
                String string5 = String.format(string4, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue(string5, "format(format, *args)");
                Utils.println(string5);
                new DelayedDestruction(new WorldExplosion(invoker).machineExplosion(), 0.0);
            }
            newEnergy = this.getEnergy() + other.getEnergy();
        }
        for (ShaftPart part : other.parts) {
            this.parts.add(part);
            part.getElement().setShaft(part.getSide(), this);
        }
        other.parts.clear();
        this.updateCache();
        other.updateCache();
        if (!loadMerge) {
            this.setEnergy(newEnergy - ShaftNetworkKt.getEnergyLostPerDeltaRad() * deltaRads * deltaRads);
        }
        return this;
    }

    public final void connectShaft(@NotNull ShaftElement from, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        boolean bl = this.parts.contains(new ShaftPart(from, side));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ArrayList<ShaftNeighbour> neighbours = this.getNeighbours(from);
        for (ShaftNeighbour neighbour : neighbours) {
            if (!Intrinsics.areEqual(neighbour.getThisShaft(), this)) {
                Utils.println("SN.cS: WARNING: Connecting part with this != getShaft(side)");
                continue;
            }
            if (neighbour.getOtherShaft() == null || Intrinsics.areEqual(neighbour.getOtherShaft(), this)) continue;
            this.mergeShafts(neighbour.getOtherShaft(), from);
            neighbour.makeConnection();
        }
    }

    public final void disconnectShaft(@NotNull ShaftElement from) {
        Intrinsics.checkNotNullParameter(from, "from");
        for (ShaftNeighbour neighbour : this.getNeighbours(from)) {
            if (!Intrinsics.areEqual(neighbour.getThisShaft(), this)) continue;
            neighbour.breakConnection();
            from.setShaft(neighbour.getThisPart().getSide(), new ShaftNetwork(from, neighbour.getThisPart().getSide()));
        }
        this.parts.removeIf(arg_0 -> ShaftNetwork.disconnectShaft$lambda$5(new Function1<ShaftPart, Boolean>(from){
            final /* synthetic */ ShaftElement $from;
            {
                this.$from = $from;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ShaftPart it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getElement(), this.$from);
            }
        }, arg_0));
        this.rebuildNetwork$Eln();
    }

    public final void rebuildNetwork$Eln() {
        HashSet unseen = new HashSet(this.parts);
        HashMap<ShaftPart, ShaftNetwork> queue = new HashMap<ShaftPart, ShaftNetwork>();
        HashSet seen = new HashSet();
        double curRads = Double.isNaN(this.getRads()) ? 0.0 : this.getRads();
        ShaftNetwork shaft = new ShaftNetwork();
        shaft.setRads(curRads);
        while (unseen.size() > 0) {
            shaft.parts.clear();
            Object e = unseen.iterator().next();
            Intrinsics.checkNotNullExpressionValue(e, "unseen.iterator().next()");
            ShaftPart start = (ShaftPart)e;
            unseen.remove(start);
            if (!seen.contains(start)) {
                queue.put(start, shaft);
            }
            while (queue.size() > 0) {
                Map.Entry next = ((Map)queue).entrySet().iterator().next();
                queue.remove(next.getKey());
                seen.add(next.getKey());
                shaft = (ShaftNetwork)next.getValue();
                if (((ShaftPart)next.getKey()).getElement().isDestructing()) continue;
                shaft.parts.add((ShaftPart)next.getKey());
                ((ShaftPart)next.getKey()).getElement().setShaft(((ShaftPart)next.getKey()).getSide(), shaft);
                for (Direction side : ((ShaftPart)next.getKey()).getElement().getShaftConnectivity()) {
                    ShaftPart part = new ShaftPart(((ShaftPart)next.getKey()).getElement(), side);
                    if (seen.contains(part)) continue;
                    ShaftNetwork shaftNetwork = ((ShaftPart)next.getKey()).getElement().getShaft(side);
                    if (shaftNetwork == null) {
                        shaftNetwork = shaft;
                    }
                    queue.put(part, shaftNetwork);
                }
                ArrayList<ShaftNeighbour> neighbours = this.getNeighbours(((ShaftPart)next.getKey()).getElement());
                for (ShaftNeighbour neighbour : neighbours) {
                    unseen.remove(neighbour.getOtherPart());
                    if (seen.contains(neighbour.getOtherPart())) continue;
                    ShaftPart shaftPart = neighbour.getOtherPart();
                    ShaftNetwork shaftNetwork = neighbour.getThisShaft();
                    Intrinsics.checkNotNull(shaftNetwork);
                    queue.put(shaftPart, shaftNetwork);
                }
            }
            shaft.updateCache();
            Iterable $this$forEach$iv = shaft.elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShaftElement it = (ShaftElement)element$iv;
                boolean bl = false;
                it.needPublish();
            }
            shaft = new ShaftNetwork();
            shaft.setRads(curRads);
        }
        shaft.updateCache();
        Iterable $this$forEach$iv = shaft.elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShaftElement it = (ShaftElement)element$iv;
            boolean bl = false;
            it.needPublish();
        }
    }

    private final ArrayList<ShaftNeighbour> getNeighbours(ShaftElement from) {
        Coordinate c = new Coordinate();
        ArrayList<ShaftNeighbour> ret = new ArrayList<ShaftNeighbour>(6);
        block0: for (Direction dir : from.getShaftConnectivity()) {
            c.copyFrom(from.coordonate());
            c.move(dir);
            NodeManager nodeManager = NodeManager.instance;
            Intrinsics.checkNotNull((Object)nodeManager);
            TransparentNodeElement to = nodeManager.getTransparentNodeFromCoordinate(c);
            if (!(to instanceof ShaftElement)) continue;
            for (Direction dir2 : ((ShaftElement)((Object)to)).getShaftConnectivity()) {
                if (dir2.getInverse() != dir) continue;
                ret.add(new ShaftNeighbour(new ShaftPart(from, dir), from.getShaft(dir), dir, new ShaftPart((ShaftElement)((Object)to), dir2), ((ShaftElement)((Object)to)).getShaft(dir2)));
                continue block0;
            }
        }
        return ret;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.setRads(nbt.func_74760_g(str + "rads"));
        double d = this.getRads();
        if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
            this.setRads(0.0);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        nbt.func_74776_a(str + "rads", (float)this.getRads());
    }

    private static final boolean disconnectShaft$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

