/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import mods.eln.mechanical.ShaftElement;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.process.destruct.ShaftSpeedWatchdog;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0011"}, d2={"absoluteMaximumShaftSpeed", "", "getAbsoluteMaximumShaftSpeed", "()D", "defaultDrag", "getDefaultDrag", "energyLostPerDeltaRad", "getEnergyLostPerDeltaRad", "createShaftWatchdog", "Lmods/eln/sim/process/destruct/ShaftSpeedWatchdog;", "shaftElement", "Lmods/eln/mechanical/ShaftElement;", "wouldExplode", "", "a", "Lmods/eln/mechanical/ShaftNetwork;", "b", "Eln"})
public final class ShaftNetworkKt {
    private static final double absoluteMaximumShaftSpeed = 250.0;
    private static final double defaultDrag = 0.02;
    private static final double energyLostPerDeltaRad = 0.05;

    public static final double getAbsoluteMaximumShaftSpeed() {
        return absoluteMaximumShaftSpeed;
    }

    public static final double getDefaultDrag() {
        return defaultDrag;
    }

    public static final double getEnergyLostPerDeltaRad() {
        return energyLostPerDeltaRad;
    }

    public static final boolean wouldExplode(@NotNull ShaftNetwork a, @NotNull ShaftNetwork b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return Math.abs(a.getRads() - b.getRads()) > 50.0 - 0.1 * Math.max(a.getRads(), b.getRads());
    }

    @NotNull
    public static final ShaftSpeedWatchdog createShaftWatchdog(@NotNull ShaftElement shaftElement) {
        Intrinsics.checkNotNullParameter(shaftElement, "shaftElement");
        return new ShaftSpeedWatchdog(shaftElement, absoluteMaximumShaftSpeed);
    }
}

