/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataInputStream;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.mechanical.ShaftNetworkKt;
import mods.eln.mechanical.ShaftRender;
import mods.eln.mechanical.SimpleShaftDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.SlewLimiter;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBlockEntity;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.jvm.functions.Function0;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sound.LoopedSound;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001;B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00100\u001a\u000201H\u0016J\u0014\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020103J\u0010\u00104\u001a\u0002012\u0006\u0010\u0004\u001a\u00020\u001dH\u0016J\u0010\u00105\u001a\u0002012\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002012\u0006\u00109\u001a\u00020:H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\n\"\u0004\b$\u0010\fR\u0011\u0010%\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010!R\u001a\u0010'\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\n\"\u0004\b)\u0010\fR\u0014\u0010*\u001a\b\u0018\u00010+R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006<"}, d2={"Lmods/eln/mechanical/ShaftRender;", "Lmods/eln/node/transparent/TransparentNodeElementRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "desc", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "angle", "", "getAngle", "()D", "setAngle", "(D)V", "cableRefresh", "", "getCableRefresh", "()Z", "setCableRefresh", "(Z)V", "cableRender", "Lmods/eln/cable/CableRenderDescriptor;", "getCableRender", "()Lmods/eln/cable/CableRenderDescriptor;", "connectionType", "Lmods/eln/cable/CableRenderType;", "getConnectionType", "()Lmods/eln/cable/CableRenderType;", "setConnectionType", "(Lmods/eln/cable/CableRenderType;)V", "Lmods/eln/mechanical/SimpleShaftDescriptor;", "eConn", "Lmods/eln/misc/LRDUMask;", "getEConn", "()Lmods/eln/misc/LRDUMask;", "logRads", "getLogRads", "setLogRads", "mask", "getMask", "rads", "getRads", "setRads", "soundLooper", "Lmods/eln/mechanical/ShaftRender$ShaftSoundLooper;", "volumeSetting", "Lmods/eln/misc/SlewLimiter;", "getVolumeSetting", "()Lmods/eln/misc/SlewLimiter;", "draw", "", "extra", "Lmods/eln/shadow/kotlin/Function0;", "initSound", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "refresh", "deltaT", "", "ShaftSoundLooper", "Eln"})
@SourceDebugExtension(value={"SMAP\nSimpleShaft.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleShaft.kt\nmods/eln/mechanical/ShaftRender\n+ 2 GLUtil.kt\nmods/eln/misc/GLUtilKt\n*L\n1#1,252:1\n12#2,7:253\n12#2,7:260\n*S KotlinDebug\n*F\n+ 1 SimpleShaft.kt\nmods/eln/mechanical/ShaftRender\n*L\n148#1:253,7\n159#1:260,7\n*E\n"})
public class ShaftRender
extends TransparentNodeElementRender {
    @NotNull
    private final SimpleShaftDescriptor desc;
    private double rads;
    private double logRads;
    private double angle;
    @NotNull
    private final LRDUMask eConn;
    @NotNull
    private final LRDUMask mask;
    @Nullable
    private CableRenderType connectionType;
    @Nullable
    private final CableRenderDescriptor cableRender;
    private boolean cableRefresh;
    @Nullable
    private ShaftSoundLooper soundLooper;
    @NotNull
    private final SlewLimiter volumeSetting;

    public ShaftRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor desc) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(desc, "desc");
        super(entity, desc);
        this.desc = (SimpleShaftDescriptor)desc;
        this.eConn = new LRDUMask();
        this.mask = new LRDUMask();
        this.cableRefresh = true;
        this.volumeSetting = new SlewLimiter(0.5f);
        this.initSound(this.desc);
        this.mask.set(LRDU.Down, true);
    }

    public final double getRads() {
        return this.rads;
    }

    public final void setRads(double d) {
        this.rads = d;
    }

    public final double getLogRads() {
        return this.logRads;
    }

    public final void setLogRads(double d) {
        this.logRads = d;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    @NotNull
    public final LRDUMask getEConn() {
        return this.eConn;
    }

    @NotNull
    public final LRDUMask getMask() {
        return this.mask;
    }

    @Nullable
    public final CableRenderType getConnectionType() {
        return this.connectionType;
    }

    public final void setConnectionType(@Nullable CableRenderType cableRenderType) {
        this.connectionType = cableRenderType;
    }

    @Nullable
    public CableRenderDescriptor getCableRender() {
        return this.cableRender;
    }

    public final boolean getCableRefresh() {
        return this.cableRefresh;
    }

    public final void setCableRefresh(boolean bl) {
        this.cableRefresh = bl;
    }

    @NotNull
    public final SlewLimiter getVolumeSetting() {
        return this.volumeSetting;
    }

    public void initSound(@NotNull SimpleShaftDescriptor desc) {
        Intrinsics.checkNotNullParameter(desc, "desc");
        this.volumeSetting.setTarget(1.0f);
        this.volumeSetting.setPosition(0.0f);
        String sound2 = desc.getSound$Eln();
        if (sound2 != null) {
            this.soundLooper = new ShaftSoundLooper(sound2, this.coordinate());
            this.addLoopedSound(this.soundLooper);
        } else {
            this.soundLooper = null;
        }
    }

    @Override
    public void draw() {
        this.draw(draw.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(@NotNull Function0<Unit> extra) {
        Intrinsics.checkNotNullParameter(extra, "extra");
        boolean $i$f$preserveMatrix = false;
        Unit ret$iv = null;
        try {
            GL11.glPushMatrix();
            boolean bl = false;
            Direction direction = this.front;
            Intrinsics.checkNotNull((Object)direction);
            direction.glRotateXnRef();
            if (this.front == Direction.XP || this.front == Direction.ZP) {
                this.desc.draw(this.angle);
            } else {
                this.desc.draw(-this.angle);
            }
            extra.invoke();
            ret$iv = Unit.INSTANCE;
        }
        finally {
            GL11.glPopMatrix();
        }
        if (this.getCableRender() != null) {
            $i$f$preserveMatrix = false;
            ret$iv = null;
            try {
                GL11.glPushMatrix();
                boolean bl = false;
                if (this.cableRefresh) {
                    this.cableRefresh = false;
                    NodeBlockEntity nodeBlockEntity = this.getTileEntity();
                    Direction direction = this.front;
                    Intrinsics.checkNotNull((Object)direction);
                    this.connectionType = CableRender.connectionType(nodeBlockEntity, this.eConn, direction.down());
                }
                Direction direction = this.front;
                Intrinsics.checkNotNull((Object)direction);
                this.glCableTransform(direction.down());
                CableRenderDescriptor cableRenderDescriptor = this.getCableRender();
                Intrinsics.checkNotNull(cableRenderDescriptor);
                cableRenderDescriptor.bindCableTexture();
                for (LRDU lrdu : LRDU.values()) {
                    CableRenderType cableRenderType = this.connectionType;
                    Intrinsics.checkNotNull(cableRenderType);
                    Utils.setGlColorFromDye(cableRenderType.otherdry[lrdu.toInt()]);
                    if (!this.eConn.get(lrdu)) continue;
                    Direction direction2 = this.front;
                    Intrinsics.checkNotNull((Object)direction2);
                    Direction direction3 = direction2.down();
                    Direction direction4 = this.front;
                    Intrinsics.checkNotNull((Object)direction4);
                    if (lrdu != direction3.getLRDUGoingTo(direction4)) {
                        LRDU lRDU = lrdu.inverse();
                        Direction direction5 = this.front;
                        Intrinsics.checkNotNull((Object)direction5);
                        Direction direction6 = direction5.down();
                        Direction direction7 = this.front;
                        Intrinsics.checkNotNull((Object)direction7);
                        if (lRDU != direction6.getLRDUGoingTo(direction7)) continue;
                    }
                    this.mask.set(1 << lrdu.ordinal());
                    CableRenderDescriptor cableRenderDescriptor2 = this.getCableRender();
                    CableRenderType cableRenderType2 = this.connectionType;
                    Intrinsics.checkNotNull(cableRenderType2);
                    CableRender.drawCable$default(cableRenderDescriptor2, this.mask, cableRenderType2, 0.0f, false, 24, null);
                }
                ret$iv = Unit.INSTANCE;
            }
            finally {
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.angle += this.logRads * (double)deltaT;
        this.volumeSetting.step(deltaT);
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        this.rads = stream.readFloat();
        this.logRads = Math.log(this.rads + 1.0) / Math.log(1.2);
        this.eConn.deserialize(stream);
        this.cableRefresh = true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lmods/eln/mechanical/ShaftRender$ShaftSoundLooper;", "Lmods/eln/sound/LoopedSound;", "sound", "", "coord", "Lmods/eln/misc/Coordinate;", "(Lmods/eln/mechanical/ShaftRender;Ljava/lang/String;Lmods/eln/misc/Coordinate;)V", "getPitch", "", "getVolume", "Eln"})
    private class ShaftSoundLooper
    extends LoopedSound {
        public ShaftSoundLooper(@NotNull String sound2, Coordinate coord) {
            Intrinsics.checkNotNullParameter(sound2, "sound");
            Intrinsics.checkNotNullParameter(coord, "coord");
            super(sound2, coord, null, 4, null);
        }

        @Override
        public float func_147655_f() {
            if (Intrinsics.areEqual(this.getSample(), "eln:FuelGenerator")) {
                return (float)(ShaftRender.this.getRads() / 250.0);
            }
            if (Intrinsics.areEqual(this.getSample(), "eln:generator")) {
                return (float)Math.max(0.05, ShaftRender.this.getRads() / ShaftNetworkKt.getAbsoluteMaximumShaftSpeed()) * 2.0f;
            }
            if (Intrinsics.areEqual(this.getSample(), "eln:plate_machine")) {
                return (float)Math.max(0.2, ShaftRender.this.getRads() / ShaftNetworkKt.getAbsoluteMaximumShaftSpeed() * (double)2);
            }
            return (float)Math.max(0.05, ShaftRender.this.getRads() / ShaftNetworkKt.getAbsoluteMaximumShaftSpeed());
        }

        @Override
        public float func_147653_e() {
            if (Intrinsics.areEqual(this.getSample(), "eln:FuelGenerator")) {
                if ((double)ShaftRender.this.getVolumeSetting().getPosition() < 0.001) {
                    return 0.0f;
                }
                return 1.0f;
            }
            if (Intrinsics.areEqual(this.getSample(), "eln:plate_machine")) {
                float maxVolume = 0.5f;
                return ShaftRender.this.getVolumeSetting().getPosition() * (ShaftRender.this.getRads() > (double)maxVolume ? maxVolume : (float)ShaftRender.this.getRads());
            }
            return ShaftRender.this.getVolumeSetting().getPosition();
        }
    }
}

