/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import mods.eln.mechanical.ShaftElement;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.ShaftNetworkKt;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.ArrayIteratorKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.process.destruct.WorldExplosion;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*H\u0016J\u001a\u0010\u0012\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lmods/eln/mechanical/SimpleShaftElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "Lmods/eln/mechanical/ShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "transparentNodeDescriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "destructing", "", "getDestructing", "()Z", "setDestructing", "(Z)V", "shaft", "Lmods/eln/mechanical/ShaftNetwork;", "getShaft", "()Lmods/eln/mechanical/ShaftNetwork;", "setShaft", "(Lmods/eln/mechanical/ShaftNetwork;)V", "shaftConnectivity", "", "Lmods/eln/misc/Direction;", "getShaftConnectivity", "()[Lmods/eln/misc/Direction;", "shaftMass", "", "getShaftMass", "()D", "dir", "initialize", "", "isDestructing", "multiMeterString", "", "side", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBreakElement", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "net", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nSimpleShaft.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleShaft.kt\nmods/eln/mechanical/SimpleShaftElement\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,252:1\n13579#2,2:253\n13579#2,2:255\n*S KotlinDebug\n*F\n+ 1 SimpleShaft.kt\nmods/eln/mechanical/SimpleShaftElement\n*L\n214#1:253,2\n225#1:255,2\n*E\n"})
public abstract class SimpleShaftElement
extends TransparentNodeElement
implements ShaftElement {
    private final double shaftMass;
    @NotNull
    private ShaftNetwork shaft;
    private boolean destructing;

    public SimpleShaftElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor transparentNodeDescriptor) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(transparentNodeDescriptor, "transparentNodeDescriptor");
        super(node, transparentNodeDescriptor);
        this.shaftMass = 5.0;
        this.shaft = new ShaftNetwork();
    }

    @Override
    public double getShaftMass() {
        return this.shaftMass;
    }

    @NotNull
    public ShaftNetwork getShaft() {
        return this.shaft;
    }

    public void setShaft(@NotNull ShaftNetwork shaftNetwork) {
        Intrinsics.checkNotNullParameter(shaftNetwork, "<set-?>");
        this.shaft = shaftNetwork;
    }

    @Override
    @Nullable
    public ShaftNetwork getShaft(@NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)dir, "dir");
        return this.getShaft();
    }

    @Override
    public void setShaft(@NotNull Direction dir, @Nullable ShaftNetwork net) {
        Intrinsics.checkNotNullParameter((Object)dir, "dir");
        if (net != null) {
            this.setShaft(net);
        }
    }

    public final boolean getDestructing() {
        return this.destructing;
    }

    public final void setDestructing(boolean bl) {
        this.destructing = bl;
    }

    @Override
    public boolean isDestructing() {
        return this.destructing;
    }

    @Override
    @NotNull
    public Direction[] getShaftConnectivity() {
        Direction[] directionArray = new Direction[]{this.front.left(), this.front.right()};
        return directionArray;
    }

    @Override
    public void initialize() {
        this.reconnect();
        double rads = this.getShaft().getRads();
        this.setShaft(new ShaftNetwork((ShaftElement)this, ArrayIteratorKt.iterator(this.getShaftConnectivity())));
        this.getShaft().setRads(rads);
        Direction[] $this$forEach$iv = this.getShaftConnectivity();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Direction element$iv;
            Direction it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.getShaft().connectShaft(this, it);
        }
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type mods.eln.mechanical.ShaftElement");
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(ShaftNetworkKt.createShaftWatchdog(this).setDestroys(exp));
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
        this.destructing = true;
        Direction[] $this$forEach$iv = this.getShaftConnectivity();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Direction element$iv;
            Direction it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.getShaft().disconnectShaft(this);
        }
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeFloat((float)this.getShaft().getRads());
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        this.getShaft().writeToNBT(nbt, "shaft");
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.getShaft().readFromNBT(nbt, "shaft");
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotER(this.getShaft().getEnergy(), this.getShaft().getRads());
    }

    @Override
    public boolean isInternallyConnected(@NotNull Direction a, @NotNull Direction b) {
        return ShaftElement.DefaultImpls.isInternallyConnected(this, a, b);
    }

    @Override
    public void connectedOnSide(@NotNull Direction direction, @NotNull ShaftNetwork net) {
        ShaftElement.DefaultImpls.connectedOnSide(this, direction, net);
    }

    @Override
    public void disconnectedOnSide(@NotNull Direction direction, @Nullable ShaftNetwork net) {
        ShaftElement.DefaultImpls.disconnectedOnSide(this, direction, net);
    }
}

