/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import mods.eln.item.IConfigurable;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0 H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020-H\u0016J\u0018\u00102\u001a\u00020%2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00103\u001a\u00020%2\u0006\u00101\u001a\u00020-H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00065"}, d2={"Lmods/eln/mechanical/TachometerElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "Lmods/eln/item/IConfigurable;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "maxRads", "", "minRads", "outputGate", "Lmods/eln/sim/nbt/NbtElectricalGateOutput;", "outputGateProcess", "Lmods/eln/sim/nbt/NbtElectricalGateOutputProcess;", "outputGateSlowProcess", "Lmods/eln/sim/IProcess;", "shaftMass", "", "getShaftMass", "()D", "coordonate", "Lmods/eln/misc/Coordinate;", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getWaila", "", "", "hasGui", "", "networkSerialize", "", "stream", "Ljava/io/DataOutputStream;", "networkUnserialize", "", "Ljava/io/DataInputStream;", "readConfigTool", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "Lnet/minecraft/entity/player/EntityPlayer;", "readFromNBT", "nbt", "writeConfigTool", "writeToNBT", "Companion", "Eln"})
public class TachometerElement
extends SimpleShaftElement
implements IConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double shaftMass;
    @NotNull
    private final NbtElectricalGateOutput outputGate;
    @NotNull
    private final NbtElectricalGateOutputProcess outputGateProcess;
    private float minRads;
    private float maxRads;
    @NotNull
    private final IProcess outputGateSlowProcess;
    private static final int SetRangeEventId = 1;
    private static final float DefaultMinRads;
    private static final float DefaultMaxRads;

    public TachometerElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        this.shaftMass = 0.5;
        this.outputGate = new NbtElectricalGateOutput("rpmOutput");
        this.outputGateProcess = new NbtElectricalGateOutputProcess("rpmOutputProcess", this.outputGate);
        this.minRads = DefaultMinRads;
        this.maxRads = DefaultMaxRads;
        this.outputGateSlowProcess = arg_0 -> TachometerElement.outputGateSlowProcess$lambda$0(this, arg_0);
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.slowProcessList.add(this.outputGateSlowProcess);
    }

    @Override
    public double getShaftMass() {
        return this.shaftMass;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.outputGate;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return side == this.front || side == this.front.getInverse() ? 4 : 0;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.lrduCubeMask.getTranslate(Direction.YN).serialize(stream);
        stream.writeFloat(this.minRads);
        stream.writeFloat(this.maxRads);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public byte networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        byte type = super.networkUnserialize(stream);
        if (type == SetRangeEventId) {
            this.minRads = stream.readFloat();
            this.maxRads = stream.readFloat();
            this.needPublish();
            return -128;
        }
        return type;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.minRads = nbt.func_74760_g("minRads");
        this.maxRads = nbt.func_74760_g("maxRads");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74776_a("minRads", this.minRads);
        nbt.func_74776_a("maxRads", this.maxRads);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public Coordinate coordonate() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        return transparentNode.coordinate;
    }

    @Override
    public void readConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        if (compound.func_74764_b("min")) {
            this.minRads = compound.func_74760_g("min");
        }
        if (compound.func_74764_b("max")) {
            this.maxRads = compound.func_74760_g("max");
        }
        this.needPublish();
    }

    @Override
    public void writeConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        compound.func_74776_a("min", this.minRads);
        compound.func_74776_a("max", this.maxRads);
        compound.func_74774_a("unit", (byte)6);
    }

    private static final void outputGateSlowProcess$lambda$0(TachometerElement this$0, double it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.outputGateProcess.setOutputNormalizedSafe((this$0.getShaft().getRads() - (double)this$0.minRads) / (double)(this$0.maxRads - this$0.minRads));
    }

    static {
        DefaultMaxRads = 2500.0f;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lmods/eln/mechanical/TachometerElement$Companion;", "", "()V", "DefaultMaxRads", "", "getDefaultMaxRads", "()F", "DefaultMinRads", "getDefaultMinRads", "SetRangeEventId", "", "getSetRangeEventId", "()I", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSetRangeEventId() {
            return SetRangeEventId;
        }

        public final float getDefaultMinRads() {
            return DefaultMinRads;
        }

        public final float getDefaultMaxRads() {
            return DefaultMaxRads;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

