/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataInputStream;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.mechanical.ShaftRender;
import mods.eln.mechanical.TachometerElement;
import mods.eln.mechanical.TachometerGui;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDUMask;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lmods/eln/mechanical/TachometerRender;", "Lmods/eln/mechanical/ShaftRender;", "entity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "desc", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "cableRender", "Lmods/eln/cable/CableRenderDescriptor;", "getCableRender", "()Lmods/eln/cable/CableRenderDescriptor;", "connections", "Lmods/eln/misc/LRDUMask;", "maxRads", "", "getMaxRads$Eln", "()F", "setMaxRads$Eln", "(F)V", "minRads", "getMinRads$Eln", "setMinRads$Eln", "renderPreProcess", "Lmods/eln/cable/CableRenderType;", "draw", "", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "side", "Lmods/eln/misc/Direction;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "Eln"})
public final class TachometerRender
extends ShaftRender {
    @Nullable
    private final CableRenderDescriptor cableRender;
    @Nullable
    private CableRenderType renderPreProcess;
    @NotNull
    private final LRDUMask connections;
    private float minRads;
    private float maxRads;

    public TachometerRender(@NotNull TransparentNodeEntity entity, @NotNull TransparentNodeDescriptor desc) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(desc, "desc");
        super(entity, desc);
        this.connections = new LRDUMask();
        this.minRads = TachometerElement.Companion.getDefaultMinRads();
        this.maxRads = TachometerElement.Companion.getDefaultMaxRads();
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender() {
        return this.cableRender;
    }

    public final float getMinRads$Eln() {
        return this.minRads;
    }

    public final void setMinRads$Eln(float f) {
        this.minRads = f;
    }

    public final float getMaxRads$Eln() {
        return this.maxRads;
    }

    public final void setMaxRads$Eln(float f) {
        this.maxRads = f;
    }

    @Override
    public void draw() {
        this.renderPreProcess = this.drawCable(Direction.YN, Eln.instance.stdCableRenderSignal, this.connections, this.renderPreProcess);
        super.draw();
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        this.connections.deserialize(stream);
        this.minRads = stream.readFloat();
        this.maxRads = stream.readFloat();
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new TachometerGui(this);
    }
}

