/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.mechanical;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.fluid.FuelRegistry;
import mods.eln.fluid.PreciseElementFluidHandler;
import mods.eln.mechanical.ShaftNetwork;
import mods.eln.mechanical.SimpleShaftElement;
import mods.eln.mechanical.TurbineDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.Utils;
import mods.eln.node.published;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.MutablePropertyReference1Impl;
import mods.eln.shadow.kotlin.jvm.internal.Reflection;
import mods.eln.shadow.kotlin.reflect.KProperty;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010/\u001a\u00020\u0015H\u0016J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0014\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020403H\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u0002042\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010=\u001a\u0002062\u0006\u0010:\u001a\u00020;H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\u001c\u001a\u00060\u001dR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR+\u0010!\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f8@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010\u000e\"\u0004\b#\u0010\u0010\u00a8\u0006?"}, d2={"Lmods/eln/mechanical/TurbineElement;", "Lmods/eln/mechanical/SimpleShaftElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "desc", "Lmods/eln/mechanical/TurbineDescriptor;", "getDesc", "()Lmods/eln/mechanical/TurbineDescriptor;", "efficiency", "", "getEfficiency", "()F", "setEfficiency", "(F)V", "fluidRate", "getFluidRate", "setFluidRate", "tank", "Lmods/eln/fluid/PreciseElementFluidHandler;", "getTank", "()Lmods/eln/fluid/PreciseElementFluidHandler;", "throttle", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "getThrottle$Eln", "()Lmods/eln/sim/nbt/NbtElectricalGateInput;", "turbineSlowProcess", "Lmods/eln/mechanical/TurbineElement$TurbineSlowProcess;", "getTurbineSlowProcess", "()Lmods/eln/mechanical/TurbineElement$TurbineSlowProcess;", "<set-?>", "volume", "getVolume$Eln", "setVolume$Eln", "volume$delegate", "Lmods/eln/node/published;", "coordonate", "Lmods/eln/misc/Coordinate;", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "getFluidHandler", "getThermalLoad", "", "getWaila", "", "", "networkSerialize", "", "stream", "Ljava/io/DataOutputStream;", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "thermoMeterString", "writeToNBT", "TurbineSlowProcess", "Eln"})
public final class TurbineElement
extends SimpleShaftElement {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final TurbineDescriptor desc;
    @NotNull
    private final PreciseElementFluidHandler tank;
    private float fluidRate;
    private float efficiency;
    @NotNull
    private final TurbineSlowProcess turbineSlowProcess;
    @NotNull
    private final NbtElectricalGateInput throttle;
    @NotNull
    private final published volume$delegate;

    public TurbineElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        this.desc = (TurbineDescriptor)desc_;
        this.tank = new PreciseElementFluidHandler((int)this.desc.getFluidConsumption());
        this.turbineSlowProcess = new TurbineSlowProcess();
        this.throttle = new NbtElectricalGateInput("throttle");
        this.volume$delegate = new published(Float.valueOf(0.0f), null, false, 6, null);
        this.tank.setFilter(FuelRegistry.INSTANCE.fluidListToFluids(this.desc.getFluidTypes()));
        this.slowProcessList.add(this.turbineSlowProcess);
        this.electricalLoadList.add(this.throttle);
    }

    @NotNull
    public final TurbineDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final PreciseElementFluidHandler getTank() {
        return this.tank;
    }

    public final float getFluidRate() {
        return this.fluidRate;
    }

    public final void setFluidRate(float f) {
        this.fluidRate = f;
    }

    public final float getEfficiency() {
        return this.efficiency;
    }

    public final void setEfficiency(float f) {
        this.efficiency = f;
    }

    @NotNull
    public final TurbineSlowProcess getTurbineSlowProcess() {
        return this.turbineSlowProcess;
    }

    @NotNull
    public final NbtElectricalGateInput getThrottle$Eln() {
        return this.throttle;
    }

    public final float getVolume$Eln() {
        return ((Number)this.volume$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0])).floatValue();
    }

    public final void setVolume$Eln(float f) {
        this.volume$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[0], Float.valueOf(f));
    }

    @Override
    @NotNull
    public PreciseElementFluidHandler getFluidHandler() {
        return this.tank;
    }

    @Override
    @NotNull
    public NbtElectricalGateInput getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.throttle;
    }

    @Nullable
    public Void getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == LRDU.Down && (side == this.front || side == this.front.back())) {
            return 4;
        }
        return 0;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotPercent(" Eff:", this.efficiency) + this.fluidRate + "mB/s";
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        this.tank.writeToNBT(nbt, "tank");
        this.turbineSlowProcess.writeToNBT(nbt, "proc");
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.tank.readFromNBT(nbt, "tank");
        this.turbineSlowProcess.readFromNBT(nbt, "proc");
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info = new LinkedHashMap();
        info.put("Speed", Utils.plotRads("", this.getShaft().getRads()));
        info.put("Energy", Utils.plotEnergy("", this.getShaft().getEnergy()));
        if (Eln.wailaEasyMode) {
            info.put("Efficency", Utils.plotPercent("", this.efficiency));
            info.put("Fuel usage", Utils.plotBuckets("", (double)this.fluidRate / 1000.0) + "/s");
        }
        return info;
    }

    @Override
    @NotNull
    public Coordinate coordonate() {
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        return transparentNode.coordinate;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeFloat(this.getVolume$Eln());
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(TurbineElement.class, "volume", "getVolume$Eln()F", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lmods/eln/mechanical/TurbineElement$TurbineSlowProcess;", "Lmods/eln/sim/IProcess;", "Lmods/eln/misc/INBTTReady;", "(Lmods/eln/mechanical/TurbineElement;)V", "rc", "Lmods/eln/misc/RcInterpolator;", "getRc", "()Lmods/eln/misc/RcInterpolator;", "process", "", "time", "", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "writeToNBT", "Eln"})
    public final class TurbineSlowProcess
    implements IProcess,
    INBTTReady {
        @NotNull
        private final RcInterpolator rc;

        public TurbineSlowProcess() {
            this.rc = new RcInterpolator(TurbineElement.this.getDesc().getInertia());
        }

        @NotNull
        public final RcInterpolator getRc() {
            return this.rc;
        }

        @Override
        public void process(double time) {
            float target = 0.0f;
            double computedEfficiency = Math.pow(Math.cos((TurbineElement.this.getShaft().getRads() - TurbineElement.this.getDesc().getOptimalRads()) / (TurbineElement.this.getDesc().getOptimalRads() * (double)TurbineElement.this.getDesc().getEfficiencyCurve()) * Math.PI / (double)2), 3.0);
            if (computedEfficiency >= (double)TurbineElement.this.getDesc().getEfficiencyCutoff()) {
                TurbineElement.this.setEfficiency((float)computedEfficiency);
                ArrayList<Component> arrayList = TurbineElement.this.getThrottle$Eln().getConnectedComponents();
                Intrinsics.checkNotNullExpressionValue(arrayList, "throttle.connectedComponents");
                double th = ((Collection)arrayList).size() > 0 ? TurbineElement.this.getThrottle$Eln().getNormalized() : 1.0;
                target = (float)((double)TurbineElement.this.getDesc().getFluidConsumption() * th);
            } else {
                TurbineElement.this.setEfficiency(0.0f);
                target = 0.0f;
            }
            float drained = (float)TurbineElement.this.getTank().drain((double)target * time);
            this.rc.setTarget((float)((double)drained / time));
            this.rc.step((float)time);
            TurbineElement.this.setFluidRate(this.rc.get());
            float power2 = TurbineElement.this.getFluidRate() * TurbineElement.this.getTank().getHeatEnergyPerMilliBucket() * TurbineElement.this.getEfficiency();
            ShaftNetwork shaftNetwork = TurbineElement.this.getShaft();
            shaftNetwork.setEnergy(shaftNetwork.getEnergy() + (double)(power2 * (float)time));
            TurbineElement.this.setVolume$Eln(power2 / (float)TurbineElement.this.getDesc().getMaxFluidPower());
        }

        @Override
        public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
            Intrinsics.checkNotNullParameter(nbt, "nbt");
            Intrinsics.checkNotNullParameter(str, "str");
            this.rc.readFromNBT(nbt, str);
        }

        @Override
        public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
            Intrinsics.checkNotNullParameter(nbt, "nbt");
            Intrinsics.checkNotNullParameter(str, "str");
            this.rc.writeToNBT(nbt, str);
        }
    }
}

